REM Run as DOS CMD Batch, not a PowerShell

REM Request to the user that they run this script elevated to ADMINISTRATOR rights.
@ECHO OFF & CLS & ECHO.
NET FILE 1>NUL 2>NUL & IF ERRORLEVEL 1 (ECHO You must right-click and select & ECHO "RUN AS ADMINISTRATOR"  to run this batch. Exiting... & ECHO. & PAUSE & EXIT /D)
REM ... proceed here with ADMINISTRATOR rights ...


REM  create a WebApps HOME folder, for the runtime installed files.

set WEBAPPS_BASE=C:\Arbutus
set WEBAPPS_HOME=%WEBAPPS_BASE%\WebApps
set INSTALL_HOME=%~dp0

REM create folder for WebApps if it does not already exist.

if not exist "%WEBAPPS_HOME%\NUL" mkdir "%WEBAPPS_HOME%"

REM copy all runtime files into desired locations

copy "%INSTALL_HOME%httpd-2.4.62-240904-win32-vs17.zip" "%WEBAPPS_HOME%"
"%INSTALL_HOME%7z.exe" x -o"%WEBAPPS_HOME%" "%WEBAPPS_HOME%\httpd-2.4.62-240904-win32-vs17.zip"

move "%WEBAPPS_HOME%\Apache24\conf\httpd.conf" "%WEBAPPS_HOME%\Apache24\conf\httpd.conf.original"
 
REM As this file has been edited by the user, this is only relevant for a first time install
REM and it should be replaced by the previous installs backup. see update.bat

copy "%INSTALL_HOME%httpd.conf" "%WEBAPPS_HOME%\Apache24\conf"
copy "%INSTALL_HOME%httpd-ahssl.conf" "%WEBAPPS_HOME%\Apache24\conf\extra"
mkdir "%WEBAPPS_HOME%\Apache24\conf\ssl"
copy "%INSTALL_HOME%ssl.7z" "%WEBAPPS_HOME%\Apache24\conf"
"%INSTALL_HOME%7z.exe" x -o"%WEBAPPS_HOME%\Apache24\conf\ssl" "%WEBAPPS_HOME%\Apache24\conf\ssl.7z"
del /q /f "%WEBAPPS_HOME%\Apache24\conf\ssl.7z"

REM Move and unzip 'App' Folder
REM if not exist %WEBAPPS_HOME%\App\NUL 

mkdir "%WEBAPPS_HOME%\App"
copy "%INSTALL_HOME%App.7z" "%WEBAPPS_HOME%\App"
"%INSTALL_HOME%7z.exe" x -o"%WEBAPPS_HOME%\App" "%WEBAPPS_HOME%\App\App.7z"

REM Exception manager binary is required in bin folder for Apache/WSGI to find.

copy "%WEBAPPS_HOME%\App\connectanywhere\encrypt_compress_wrapper.dll" "%WEBAPPS_HOME%\Apache24\bin"

REM make media directory
::mkdir %WEBAPPS_HOME%\App\connectanywhere\media

REM - Remove installer files no longer required in %WEBAPPS_HOME%

del /q /f "%WEBAPPS_HOME%\httpd-2.4.62-240904-win32-vs17.zip"
del /q /f "%WEBAPPS_HOME%\App\App.7z"

REM - copy source __Python folder to destination WEBAPPS_HOME

xcopy /s /e /i /y "%INSTALL_HOME%__Python" "%WEBAPPS_HOME%\__Python"

REM Currently django_model_utils 4.3.1 is the latest BUT it's __init__.py still uses
REM resource_pkg which is not compatible, the master branch has the fix using importlib instead.
REM So we patch the offical wheel with this change until 4.3.x > 4.3.1 is released as a pip.

copy /Y "%WEBAPPS_HOME%\__Python\ThirdParty\model_utils\__init__.py" "%WEBAPPS_HOME%\__Python\ThirdParty\model_utils\__init__.original"
copy /Y "%INSTALL_HOME%model_utils\__init__.py" "%WEBAPPS_HOME%\__Python\ThirdParty\model_utils\__init__.py"

REM setup Django
REM NOTE: As we are now using SQLLite3, the 
REM copy provided with a fresh install can already
REM have this setup and ready to go.

REM As this file has been edited by the user, this is only relevant for a first time install
REM and it should be replaced by the previous installs backup. see Update part below.

copy "%INSTALL_HOME%arbutus_db.sqlite3.original" "%WEBAPPS_HOME%\App\connectanywhere\arbutus_db.sqlite3"

REM determine the last backup and use it as the restore point of user configurable files.

set /p LAST_BACKUP=<%WEBAPPS_BASE%\last_webapps_backup.txt
set WEBAPPS_RESTORE=%LAST_BACKUP%

IF NOT EXIST "%WEBAPPS_RESTORE%\." GOTO NO_WEBAPPS_RESTORE_DIR

REM COPY back up files back into INSTALL location
mkdir "%INSTALL_HOME%Restore"
echo f | xcopy /y "%WEBAPPS_RESTORE%\Apache24\conf\httpd.conf" "%INSTALL_HOME%Restore\httpd.conf"
echo f | xcopy /y "%WEBAPPS_RESTORE%\Apache24\conf\extra\httpd-ahssl.conf" "%INSTALL_HOME%Restore\httpd-ahssl.conf"
echo f | xcopy /y "%WEBAPPS_RESTORE%\Apache24\conf\extra\httpd-ssl.conf" "%INSTALL_HOME%Restore\httpd-ssl.conf"
REM copy user certificates
echo f | xcopy /y /i "%WEBAPPS_RESTORE%\Apache24\conf\ssl\*.crt" "%INSTALL_HOME%Restore\"
echo f | xcopy /y /i "%WEBAPPS_RESTORE%\Apache24\conf\ssl\*.key" "%INSTALL_HOME%Restore\"
echo f | xcopy /y "%WEBAPPS_RESTORE%\App\connectanywhere\arbutus_db.sqlite3" "%INSTALL_HOME%Restore\arbutus_db.sqlite3" 
echo f | xcopy /y "%WEBAPPS_RESTORE%\App\connectanywhere\connectanywhere\settings.py" "%INSTALL_HOME%Restore\settings.py"

REM modify restored files of any necessary changes required for latest version of previous restored Version
REM This exe will modify the users backed up conf/settings where the old value backed up in no longer relevant.
echo f | xcopy /y "%INSTALL_HOME%config_update.exe" "%INSTALL_HOME%Restore\config_update.exe"
echo f | xcopy /y "%INSTALL_HOME%config_changes.txt" "%INSTALL_HOME%Restore\config_changes.txt"
start /W /D "%INSTALL_HOME%Restore" config_update.exe

REM After any mofications, copy into INSTALLATION destination folder ready for running.
echo f | xcopy /y "%INSTALL_HOME%Restore\httpd.conf" "%WEBAPPS_HOME%\Apache24\conf\httpd.conf"
echo f | xcopy /y "%INSTALL_HOME%Restore\httpd-ahssl.conf" "%WEBAPPS_HOME%\Apache24\conf\extra\httpd-ahssl.conf"
echo f | xcopy /y "%INSTALL_HOME%Restore\httpd-ssl.conf" "%WEBAPPS_HOME%\Apache24\conf\extra\httpd-ssl.conf"
REM copy user certificates
echo f | xcopy /y /i "%INSTALL_HOME%Restore\*.crt" "%WEBAPPS_HOME%\Apache24\conf\ssl\"
echo f | xcopy /y /i "%INSTALL_HOME%Restore\*.key" "%WEBAPPS_HOME%\Apache24\conf\ssl\"
echo f | xcopy /y "%INSTALL_HOME%Restore\arbutus_db.sqlite3" "%WEBAPPS_HOME%\App\connectanywhere\arbutus_db.sqlite3"
echo f | xcopy /y "%INSTALL_HOME%Restore\settings.py" "%WEBAPPS_HOME%\App\connectanywhere\connectanywhere\settings.py"

REM remove the working Restore folder - NOTE can comment out the rmdir to diagnose issues with config_update.exe
rmdir "%INSTALL_HOME%Restore" /s /q
:NO_WEBAPPS_RESTORE_DIR


REM *** UPDATE PART ***

REM initialize database schema
REM run migrations

REM python %WEBAPPS_HOME%\App\connectanywhere\manage.py migrate --noinput
REM "C:\Arbutus\WebApps\__Python\python.exe" "C:\Arbutus\WebApps\App\connectanywhere\manage.py" migrate --pythonpath "C:\Arbutus\WebApps\App\connectanywhere"  --noinput
"%WEBAPPS_HOME%\__Python\python.exe" "%WEBAPPS_HOME%\App\connectanywhere\manage.py" migrate --pythonpath "%WEBAPPS_HOME%\App\connectanywhere"  --noinput

REM insert skeleton data so admin can get started
:: create admin password
::django-admin createsuperuser --user admin --email  # need python script to insertinto db

REM create static content
REM %WEBAPPS_HOME%\App\connectanywhere\manage.py collectstatic --noinput
"%WEBAPPS_HOME%\__Python\python.exe" "%WEBAPPS_HOME%\App\connectanywhere\manage.py" collectstatic --pythonpath "%WEBAPPS_HOME%\App\connectanywhere"  --noinput


REM install and start apache as a service.
:: Stop Apache	 	httpd -k stop
:: Restart Apache	httpd -k restart
:: Uninstall Apache Service	httpd -k uninstall
:: Test Config Syntax	httpd -t
:: Version Details	httpd -V
:: Command Line Options List	httpd -h

"%WEBAPPS_HOME%\Apache24\bin\httpd.exe" -k install -n "Arbutus web server"
"%WEBAPPS_HOME%\Apache24\bin\httpd.exe" -k start -n "Arbutus web server"

REM Once done, exit the batch file -- skips executing the errorNoPython section

goto:eof
