:: Request to the user that they run this script elevated to ADMINISTRATOR rights. (For SYSTEM WIDE Python install)
@ECHO OFF & CLS & ECHO.
NET FILE 1>NUL 2>NUL & IF ERRORLEVEL 1 (ECHO You must right-click and select & ECHO "RUN AS ADMINISTRATOR"  to run this batch. Exiting... & ECHO. & PAUSE & EXIT /D)
REM ... proceed here with ADMINISTRATOR rights ...

:: create a Arbutus WebApps HOME folder, for the runtime installed files.
set WEBAPPS_BASE=C:\Arbutus
set WEBAPPS_HOME=%WEBAPPS_BASE%\WebApps

:: If there is a previous installation, backup user configurable files to a 
:: backup directory remove parts of time that are not compatible for directory name.
set timepart=%time:~0,8%
set timepart=%timepart::=-%
set datepart=%date:/=-%
setlocal enabledelayedexpansion
set timepart=%timepart: =%
set datepart=%datepart: =-%
setlocal disabledelayedexpansion
set WEBAPPS_BACKUP=%WEBAPPS_HOME%_BACKUP_%datepart%_%timepart%
mkdir "%WEBAPPS_BACKUP%"
>"%WEBAPPS_BASE%\last_webapps_backup.txt" echo(%WEBAPPS_BACKUP%

REM Backup user configurable files
echo f | xcopy "%WEBAPPS_HOME%\Apache24\conf\httpd.conf" "%WEBAPPS_BACKUP%\Apache24\conf\httpd.conf"
echo f | xcopy "%WEBAPPS_HOME%\Apache24\conf\extra\httpd-ahssl.conf" "%WEBAPPS_BACKUP%\Apache24\conf\extra\httpd-ahssl.conf"
echo f | xcopy "%WEBAPPS_HOME%\Apache24\conf\extra\httpd-ssl.conf" "%WEBAPPS_BACKUP%\Apache24\conf\extra\httpd-ssl.conf"
echo f | xcopy /i "%WEBAPPS_HOME%\Apache24\conf\ssl\*.crt" "%WEBAPPS_BACKUP%\Apache24\conf\ssl\"
echo f | xcopy /i "%WEBAPPS_HOME%\Apache24\conf\ssl\*.key" "%WEBAPPS_BACKUP%\Apache24\conf\ssl\"
echo f | xcopy "%WEBAPPS_HOME%\App\connectanywhere\arbutus_db.sqlite3" "%WEBAPPS_BACKUP%\App\connectanywhere\arbutus_db.sqlite3"
echo f | xcopy "%WEBAPPS_HOME%\App\connectanywhere\connectanywhere\settings.py" "%WEBAPPS_BACKUP%\App\connectanywhere\connectanywhere\settings.py"

REM install and start apache as a service.
:: Stop Apache	 	httpd -k stop
:: Restart Apache	httpd -k restart
:: Uninstall Apache Service	httpd -k uninstall
:: Test Config Syntax	httpd -t
:: Version Details	httpd -V
:: Command Line Options List	httpd -h

"%WEBAPPS_HOME%\Apache24\bin\httpd.exe" -k stop -n "Arbutus web server"
::timeout /t 10
"%WEBAPPS_HOME%\Apache24\bin\httpd.exe" -k uninstall -n "Arbutus web server"

REM remove install directory and its contents
rmdir "%WEBAPPS_HOME%" /s /q
