import os
import ctypes
import random
import string
from time import time

from .constants import PASSLEN


class Cryptor:
    def __init__(self):

        # try windows, linux, OSX dll extensions
        for dll_ext in [".dll", ".so", ".dylib"]:
            dll_path = os.path.abspath(os.path.join(os.path.dirname(__file__), '..'))
            dll_name = os.path.join(dll_path, "encrypt_compress_wrapper")
            # dll_name = os.path.join(os.getcwd(), "encrypt_compress_wrapper")
            dll_name += dll_ext
            try:
                self.dll = ctypes.CDLL(dll_name)
            except OSError:
                continue
            else:
                break

        # ctor
        self.create_f = self.dll.create  # func. ptr.
        self.create_f.restype = ctypes.c_void_p  # return type
        self.crypt_p = self.create_f()  # invoke ctor

        # dtor
        self.destroy_f = self.dll.destroy
        self.destroy_f.argtypes = [ctypes.c_void_p]

        # resetkey
        self.resetkey_f = self.dll.resetkey
        self.resetkey_f.argtypes = [ctypes.c_void_p]

        # encrypt
        self.encrypt_buf_f = self.dll.encrypt_buf
        self.encrypt_buf_f.argtypes = [
            ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_int)
        ]
        self.encrypt_buf_f.restype = ctypes.c_int

        # decrypt
        self.decrypt_buf_f = self.dll.decrypt_buf
        self.decrypt_buf_f.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_int]
        self.decrypt_buf_f.restype = ctypes.c_int

    def __enter__(self):
        return self

    # Public methods
    def resetkey(self):
        self.resetkey_f(self.crypt_p)

    def encrypt_buf(self, srce, buflen):
        dest = ctypes.create_string_buffer(b'\000' * (buflen * 2))
        bufsize = ctypes.c_int(buflen)
        result = self.encrypt_buf_f(self.crypt_p, dest, srce, ctypes.byref(bufsize))
        return result, dest, bufsize

    def decrypt_buf(self, srce, buflen):
        bufsize = ctypes.c_int(buflen)
        dest = ctypes.create_string_buffer(b'\000' * buflen)
        result = self.decrypt_buf_f(self.crypt_p, dest, srce, bufsize)
        return result, dest

    def __exit__(self, exc_type, exc_value, traceback):
        self.destroy_f(self.crypt_p)


def encrypt_password(password):
    """
    Public helper to encrypt ASI password

    :param password:
    :return:
    """
    with Cryptor() as cryptor:
        random.seed(time())
        rnd_str = ''.join(random.choice(
            string.ascii_letters + string.digits) for _ in range(len(password), PASSLEN))
        bytes_password = password.encode()
        bytes_password += b'\000'
        bytes_password += rnd_str.encode()
        result, enc_passwd, buflen = cryptor.encrypt_buf(bytes_password, PASSLEN + 1)
        return enc_passwd

# NOTE: For debugging only, user password should NEVER be decrypted in the web application.
# and only be persisted in the database in its encrypted form.

# def decrypt_password(password):
#     """ Public helper to decrypt ASI password """
#     with Cryptor() as cryptor:
#         result, dec_passwd = cryptor.decrypt_buf(password, PASSLEN + 1)
#         return dec_passwd
