from django.contrib.auth import login, authenticate
from django.views.generic import FormView

#from django.contrib.auth.mixins import LoginRequiredMixin
from django.shortcuts import render

from _version import __version__, __git_hash__
from result_manager.forms import LoginForm


class AdminLoginView(FormView):
    template_name = 'common/index.html'
    form_class = LoginForm
    success_url = '../../admin/'

    def get(self, request, *args, **kwargs):
        form = self.form_class()

        return render(
            request,
            self.template_name,
            { 'form': form, 'logo': None, 'version': __version__, 'git_hash': __git_hash__ }
        )

    def form_valid(self, form):

        username = form.cleaned_data['username']
        password = form.cleaned_data['password']
        
        user = authenticate(
            username=username,
            password=password)

         # do not reserved user 'admin' as it is not a windows login authenticated user
        if user is not None and user.is_active and user.is_superuser:
            login(self.request, user)
            #return self.form_valid(form)
            return super(AdminLoginView, self).form_valid(form)
        else:
            form.add_error('username', '')
            form.add_error('password', 'Credentials incorrect! Try again.')
            return self.form_invalid(form)

#class LogoutView(LoginRequiredMixin, FormView):
#
#    def get(self, request, *args, **kwargs):
#        logout(request)
#        return redirect('admin')
