"""connectanywhere URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.9/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.conf.urls import url, include
    2. Add a URL to urlpatterns:  url(r'^blog/', include('blog.urls'))
"""
from django.urls import include, re_path
from django.http import HttpResponseRedirect
from django.contrib import admin
from django.conf import settings
from django.conf.urls.static import static
from django.contrib.staticfiles.storage import staticfiles_storage
from django.views.generic.base import RedirectView

#from result_manager.views import LogoutView  
# TODO where to go after admin logout?
from schedule.views import LogoutView  
from common.views import AdminLoginView

#from common.views import LogoutView

urlpatterns = [
    re_path(r'^$', lambda r: HttpResponseRedirect('result_manager/')),  # TODO landing page to choose which app?
    re_path(r'^admin/', admin.site.urls, name='admin'),
    re_path(r'^admin/logout/$', LogoutView.as_view(), name='admin-logout'),
    re_path(r'^admin/login/$', AdminLoginView.as_view(), name='admin-login'),
    #re_path(r'^jet/', include('jet.urls', 'jet')),  # Django JET URLS
    #re_path(r'^admin/login', admin.site.urls, name='admin-login'),
    re_path(r'^webconnect/', include('schedule.urls')),
    re_path(r'^result_manager/', include('result_manager.urls')),
    re_path('favicon.ico', RedirectView.as_view(url=staticfiles_storage.url('common/favicon.ico')))
] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
