import socket

from ..arbutus_server.constants import (
    REPLY_SUCCESS, RESULT_AUTHOK,
)
from ..arbutus_server.connection import build_asi_packet_1
from ..arbutus_server.network import get_reply
from ..models import ServerProfile


def connect_socket():
    """
    :return:
    """
    # send over the wire via TCP
    server_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)

    try:
        active_server = ServerProfile.objects.get(active_server=True)
        server_socket.connect((active_server.host_name, active_server.port))
    except ServerProfile.DoesNotExist:
        print('At least one server in ServerProfile must be the active server!')  # TODO web page warning?
        server_socket = None

    return server_socket


def arbutus_em_authenticate(username, password):
    """
    Public helper to authenticate with ASI stub/server
    :param username:
    :param password:
    :return:
    """

    server_socket = None
    result = None
    return_result = False

    try:
        server_socket = connect_socket()
        send_packet = build_asi_packet_1(username, password, False)
        server_socket.send(send_packet)
        result = get_reply(server_socket)
    except ConnectionRefusedError:
        pass

    if result is not None and result.get('cmd_type') == REPLY_SUCCESS and result.get('dest_srce') == RESULT_AUTHOK:
        return_result = True

    if server_socket is not None:
        server_socket.close()

    return return_result


def is_auth_ok(cmd_type, dest_srce):
    result = False
    if cmd_type == REPLY_SUCCESS and dest_srce == RESULT_AUTHOK:
        result = True

    return result


def do_server_socket(user_name, enc_password):
    server_socket = connect_socket()
    send_packet = build_asi_packet_1(user_name, enc_password, True)
    server_socket.send(send_packet)
    return server_socket, get_reply(server_socket)
