import bz2
import socket
#from types import NoneType

from ..arbutus_server.constants import (
    AEM_ENUM_ACTIVITY_ACTIVE, AEM_ENUM_ACTIVITY_ALL, AEM_ENUM_ACTIVITY_THREAD,
    AEM_ENUM_ACTIVITY_USER, AEM_ENUM_ACTIVITY, AEM_ENUM_FORM,
    AEM_ENUM_USER_ACTIVE, AEM_ENUM_USER_ALL, AEM_ENUM_USER, AEM_DELETE_USER, AEM_ENUM_USER_GROUPS,
    AEM_ENUM_GROUP_ACTIVE, AEM_ENUM_GROUP_ALL, AEM_ENUM_GROUP, AEM_DELETE_GROUP, AEM_ENUM_GROUP_USERS,
    AEM_ENUM_PROCESS_ACTIVE, AEM_ENUM_PROCESS, AEM_DELETE_PROCESS,
    AEM_ENUM_THREAD_ACTIVE, AEM_ENUM_THREAD_ALL, AEM_ENUM_THREAD_USER,
    AEM_ENUM_THREAD_NOTES, AEM_ENUM_THREAD_ATTACH, AEM_DELETE_THREAD,
    AEM_ENUM_UI, AEM_DEFAULT_UI, AEM_BACKUP, AEM_ENUM_BACKUPS, AEM_GET_ID,
    REPLY_MORE, REPLY_SUCCESS,
)

from ..arbutus_server.network import get_reply
from ..models import ArbutusLogin
from ..views_helper import extract_enum_activity_result

from .send_messages import (
    send_enum_user_login, send_enum_cmd, send_delete_cmd,
    send_add_or_change_user, send_add_or_change_group, send_add_or_change_thread,
    send_enum_close_activity, send_add_thread_note, send_enum_action_cmd,
    send_enum_reassign_activity_cmd, send_change_ui, send_report, send_restore,
    send_enum_log, send_restore_log, send_add_or_change_process, 
)
from .send_ve_messages import send_rollback_process, send_add_answer
from .messages import get_user_id, is_em_admin


def persist_login_details(result, username):
    # to get here arbutus server login auth is ok
    # now persist the em user details so that we can reference
    # them across sessions with the arbutus server.
    # if this is not acceptable, we will have to call
    # send_enum_user_login before almost every other
    # call to get the user name, id and admin status etc.

    # extract name, id and is_admin from result
    buffer = result.get('buffer').decode('utf-8').split('\00')[0].split('\t')
    name = buffer[0]
    user_id = int(buffer[1])
    if buffer[2] == 'T':
        is_admin = True
    else:
        is_admin = False

    # remove previous entry as details like name and login id may have changed.
    try:
        ArbutusLogin.objects.get(login_id=username).delete()
    except ArbutusLogin.DoesNotExist:
        pass
    try:
        ArbutusLogin.objects.get(name=name).delete()
    except ArbutusLogin.DoesNotExist:
        pass
    try:
        ArbutusLogin.objects.get(user_id=user_id).delete()
    except ArbutusLogin.DoesNotExist:
        pass

    try:
        # in either case we create a new entry
        obj, created = ArbutusLogin.objects.update_or_create(
            login_id=username, user_id=user_id, name=name, is_admin=is_admin
        )
        obj.save()
    except Exception as e:
        print("****ArbutusLogin.objects.update_or_create exception as", e)

# do the messages based on type
# TODO error in buffer should be handled, rather than None in tuple.


def do_em_messages(server_socket, user_name, args):
    msg_type = args[0]
    msg_filter = args[1][0]
    msg_filter_id = args[1][1]
    
    extra_result = None, None
    item_id = 0

    if msg_type == 'activities':  # home page
        print("****do_em_messages - activities")
        #return_result = send_enum_user_login(server_socket, user_name), None
        #if return_result[0].get('cmd_type') == 33000:
        #    persist_login_details(return_result[0], user_name)

        # for activities list default to USER
        if msg_filter_id > 0:
            msg_cmd = AEM_ENUM_ACTIVITY_THREAD
            item_id = msg_filter_id
        elif is_em_admin(user_name) and msg_filter == "ACTIVE":
            msg_cmd = AEM_ENUM_ACTIVITY_ACTIVE
        elif is_em_admin(user_name) and msg_filter == "ALL":
            msg_cmd = AEM_ENUM_ACTIVITY_ALL
        else:
            msg_cmd = AEM_ENUM_ACTIVITY_USER
            item_id = get_user_id(user_name)
    elif msg_type == 'users':
        if msg_filter == 'ALL':
            msg_cmd = AEM_ENUM_USER_ALL
        else:
            msg_cmd = AEM_ENUM_USER_ACTIVE
    elif msg_type == 'groups':
        if msg_filter == 'ALL':
            msg_cmd = AEM_ENUM_GROUP_ALL
        else:
            msg_cmd = AEM_ENUM_GROUP_ACTIVE
    elif msg_type == 'processes':
            msg_cmd = AEM_ENUM_PROCESS_ACTIVE
    elif msg_type == 'threads':
        if is_em_admin(user_name):
            if msg_filter == 'ALL':
                msg_cmd = AEM_ENUM_THREAD_ALL
            else:
                msg_cmd = AEM_ENUM_THREAD_ACTIVE
        else:
            msg_cmd = AEM_ENUM_THREAD_USER
            item_id = get_user_id(user_name)
    elif msg_type == 'emlogin':
        return_result = send_enum_user_login(server_socket, user_name), None
        if return_result[0].get('cmd_type') == 33000:
            persist_login_details(return_result[0], user_name)
            # TODO hack extra return results on existing ones.
            return return_result, extra_result
        else:
            # TODO user_login failed!
            print("****send_enum_user_login(server_socket, user_name) - FAILED")
            print("****user_name: ", user_name)
            print("****cmd_type: ", return_result[0].get('cmd_type'))
            print("****buffer: ", return_result[0].get('buffer'))
            return return_result, extra_result
    elif msg_type == 'backup':
        msg_cmd = AEM_BACKUP
        item_id = get_user_id(user_name)
    elif msg_type == 'enum-backups':
        msg_cmd = AEM_ENUM_BACKUPS
        item_id = get_user_id(user_name)
    # NOTE: both AEM_GET_ID & AEM_ENUM_FORM are visual editor specific
    # but have kept in do_messages due to there simple packets and return
    # processing, in essence, same/similar to all other ENUM messages etc.
    elif msg_type == 'request-id':
        # TODO move out of here into ve do messages.
        msg_cmd = AEM_GET_ID
        form_info = []
        form_info.append(get_user_id(user_name))
        form_info.append(msg_filter_id)
        return_result = send_enum_cmd(server_socket, msg_cmd, form_info), None
        return return_result, extra_result
    elif msg_type == 'get-rmforms':
        msg_cmd = AEM_ENUM_FORM
    elif msg_type == 'workflow-rollback':
        admin_id = get_user_id(user_name)
        return_result = send_rollback_process(server_socket, admin_id, msg_filter_id)
        return return_result, extra_result
    else:
        raise NotImplemented

    # TODO better error handling as 'extra_result' not utilized?
    return_result = send_enum_cmd(server_socket, msg_cmd, item_id), None
    return return_result, extra_result


def do_dlg_messages(server_socket, user_name, args):
    # user_name passed from generic process_message but not required.
    dlg_type = args[0] 
    list_id = args[1]
    extra_result = None, None

    if dlg_type == 'activities':
        raise NotImplementedError
    elif dlg_type == 'users':
        # get selected user details
        return_result = send_enum_cmd(server_socket, AEM_ENUM_USER, list_id), None
        if return_result[0].get('cmd_type') == 33000:
            enum_user_groups_result = send_enum_cmd(server_socket, AEM_ENUM_USER_GROUPS, list_id)
            extra_result = enum_user_groups_result, None
    elif dlg_type == 'groups':
        return_result = send_enum_cmd(server_socket, AEM_ENUM_GROUP, list_id), None
        if return_result[0].get('cmd_type') == 33000:
            enum_groups_user_result = send_enum_cmd(server_socket, AEM_ENUM_GROUP_USERS, list_id)
            extra_result = enum_groups_user_result, None
    elif dlg_type == 'processes':
        return_result = send_enum_cmd(server_socket, AEM_ENUM_PROCESS, list_id), None
    elif dlg_type == 'threads':
        raise NotImplementedError # TODO ?
    else:
        raise NotImplementedError

    return return_result, extra_result


def do_dlg_add_or_update_messages(server_socket, user_name, args):
    dlg_type = args[0]
    command = args[1]
    form_data = args[2]
    return_result = None, None

    if dlg_type == 'activities':
        raise NotImplementedError
    elif dlg_type == 'users':
        return_result = send_add_or_change_user(server_socket, get_user_id(user_name), form_data, command), None
    elif dlg_type == 'groups':
        return_result = send_add_or_change_group(server_socket, get_user_id(user_name), form_data, command), None
    elif dlg_type == 'processes':
        return_result = send_add_or_change_process(server_socket, get_user_id(user_name), form_data, command), None
    elif dlg_type == 'threads':
        return_result = send_add_or_change_thread(server_socket, form_data, command), None
    else:
        NotImplementedError

    return return_result


def do_delete_messages(server_socket, user_name, args):
    dlg_type = args[0]
    rows = args[1]
    return_result = None, None

    for list_id in rows:
        if dlg_type == 'activities':
            raise NotImplementedError
        elif dlg_type == 'users':
            return_result = send_delete_cmd(server_socket, AEM_DELETE_USER, get_user_id(user_name), list_id), None
        elif dlg_type == 'groups':
            return_result = send_delete_cmd(server_socket, AEM_DELETE_GROUP, get_user_id(user_name), list_id), None
        elif dlg_type == 'processes':
            
            # AEM_DELETE_PROCESS
            # This is kept as it is, no changes, unless needed
            # Message format: dest_srce: process ID, buffer: text_admin_ID
            # Reply Format  : REPLY_SUCCESS|REPLY_FAILURE (with message in buffer)
            return_result = send_delete_cmd(server_socket, AEM_DELETE_PROCESS, get_user_id(user_name), list_id), None
        elif dlg_type == 'threads':
            raise NotImplementedError
            #return_result = send_delete_cmd(server_socket, AEM_DELETE_THREAD, get_user_id(user_name), list_id), None
        else:
            raise NotImplementedError

        if return_result[0].get('cmd_type') != 33000:
            break

    return return_result


def do_config_messages(server_socket, user_name, args):
    msg_type = args[0]
    grid_config = args[1]

    if msg_type == 'load':
        result = send_enum_cmd(server_socket, AEM_ENUM_UI, get_user_id(user_name))
    elif msg_type == 'save':
        result = send_change_ui(server_socket, get_user_id(user_name), grid_config)
    else:
        result = send_enum_cmd(server_socket, AEM_DEFAULT_UI, get_user_id(user_name))

    return prepare_config_result(result, msg_type)


def prepare_config_result(result_packet, msg_type):
    # process config result
    buffer = result_packet.get('buffer')

    if result_packet.get('cmd_type') == 33000:
        if msg_type == 'load':
            grid_byte = bz2.decompress(buffer)
            config = grid_byte.decode('utf-8')
            return_result = {'result': 'OK', 'grids': config}
        elif msg_type == 'save':
            return_result = {'result': 'OK'}
        else:
            return_result = {'result': 'CLEAR'}
    else:
        if msg_type == 'load':
            return_result = {'grids': None, 'result': 'OK'}
        else:
            return_result = {'grids': None, 'result': 'ERROR', 'message': buffer.decode('utf-8')}

    return return_result, None


def get_thread_attachments(server_socket, thread_id):
    activity_attachments = []
    enum_attachments_result = send_enum_cmd(server_socket, AEM_ENUM_THREAD_ATTACH,  int(thread_id))

    # extract reply from enum_attachment_results
    if enum_attachments_result.get('cmd_type') == 33000:
        attachments = enum_attachments_result.get('buffer').decode('utf-8').split('\00')
        for attachment in attachments[:-2]:  # last 2 are the ending double null
            activity_attachment = {}
            attachment_item = attachment.split('\t')
            # Attachment ID,Attachment name,who added,date created|…||
            activity_attachment['attachment_id'] = attachment_item[0]
            activity_attachment['name'] = attachment_item[1]
            activity_attachment['who'] = attachment_item[2]
            activity_attachment['created'] = attachment_item[3]
            activity_attachments.append(activity_attachment)

    return activity_attachments


def do_close_activity_1(server_socket, _, args):  # activity_id
    activity_details_errors = None
    activity_action_errors = None
    activity_attachment_errors = None
    activity_notes_errors = None
    activity_actions = []
    activity_details = {}
    activity_attachments = []
    activity_notes = []
    activity_id = args[0]

    # TODO process and handle errors at each stage to allow meaningful return results for the view response
    enum_activity_result = send_enum_cmd(server_socket, AEM_ENUM_ACTIVITY, activity_id)

    if enum_activity_result.get('cmd_type') == 33000:
        result_string = enum_activity_result.get('buffer').decode('utf-8').split('\x00\x00\x00\x00')
        # parse enum_activity results
        activity_details = extract_enum_activity_result(result_string)

        # get activity actions (buttons)
        state_id = int(activity_details.get('state_id'))
        enum_action_result = send_enum_action_cmd(server_socket, activity_id, state_id)

        # Next state ID, Button label, button description, to user ID, name, name... |… | |
        # to user ID=1 if choice. Name is a list of names for the user to choose
        # TODO prepare enum_action_result in a way so that we can customize the activity dialog
        # when we respond with the result
        if enum_action_result.get('cmd_type') == 33000:
            actions = enum_action_result.get('buffer').decode('utf-8').split('\00')
            # special case for state description,
            # not an enum_activity_close field per se but can be treated as one
            activity_details['state_description'] = actions[0]
            for action in actions[1:-2]:  # last 2 are the ending double null
                activity_action = {}
                action_item = action.split('\t')
                activity_action['state_id'] = action_item[0]  # action_id
                activity_action['label'] = action_item[1]
                activity_action['description'] = action_item[2]
                activity_action['to_user_id'] = int(action_item[3])
                if activity_action['to_user_id'] == 1:
                    activity_action['names'] = []
                    idx = 4
                    for name in action_item[4:]:
                        activity_action['names'].append(name)
                        idx += 1

                activity_actions.append(activity_action)

        thread_id = int(activity_details.get('thread_id'))
        activity_attachments = get_thread_attachments(server_socket, thread_id)
        # make thread_id arg a list so that it is handled the same regardless of where it is called from
        activity_notes, activity_notes_errors = do_get_notes_message(server_socket, [thread_id])

    return [activity_details, activity_details_errors], \
           [activity_actions, activity_action_errors,
            activity_attachments, activity_attachment_errors,
            activity_notes, activity_notes_errors]


def do_close_activity_2(server_socket, _, args):  # user_id, activity_data
    user_id = args[0]
    activity_data = args[1]
    enum_close_activity_result = send_enum_close_activity(server_socket, user_id, activity_data)
    if enum_close_activity_result.get('cmd_type') == 33000:
        return_result = {"result": "OK"}
    else:
        err_message = enum_close_activity_result.get('buffer').decode('utf-8')[:-1]
        return_result = {"result": "FAIL", "message": err_message}

    return return_result, None


def do_reassign_activities(server_socket, user_name, args):  # new_user_id, activities
    new_user_id = args[0]
    activities = args[1]
    result = send_enum_reassign_activity_cmd(server_socket, get_user_id(user_name), new_user_id, activities)
    if result.get('cmd_type') == 33000:
        return {"result": "OK"}, None
    else:
        return {"result": "FAIL", "message": result.get('buffer').decode('uft-8')}


def do_get_notes_message(server_socket, args):  # thread_id
    thread_id = args[0]
    enum_notes_thread_notes_result = send_enum_cmd(server_socket, AEM_ENUM_THREAD_NOTES, int(thread_id))
    results = []

    # who,date,Note|who,date,Note|…||
    if enum_notes_thread_notes_result.get('cmd_type') == 33000:
        notes = enum_notes_thread_notes_result.get('buffer').decode('utf-8').split('\00\00')
        if len(notes) == 1 and notes[0] == '\00':
            pass
        else:
            # TODO massage notes results more ?
            for item in notes[0].split('\x00'):
                record = {}
                fields = item.split('\t')
                record['who'] = fields[0]
                record['created'] = fields[1]
                note_text = fields[2].rstrip('\r\n')
                record['note'] = note_text
                results.append(record)

    return results, None


def do_save_notes_message(server_socket, user_name, args):  # thread_id, new_note
    thread_id = args[0]
    new_note = args[1]
    add_thread_note_result = send_add_thread_note(server_socket, get_user_id(user_name), thread_id, new_note)
    if add_thread_note_result.get('cmd_type') == 33000:
        _ = add_thread_note_result.get('buffer').decode('utf-8').split('\00\00')
        # make thread_id arg a list so that it is handled the same regardless of where it is called from
        get_thread_notes_result, _ = do_get_notes_message(server_socket, [thread_id])
        # TODO
        result = get_thread_notes_result
    else:
        result = ''

    return result, None


def is_trend_chart(chart_id: int):
    return chart_id == 5 or chart_id == 8


def is_user_period_chart(chart_id: int):
    return chart_id == 3 or chart_id == 4 or chart_id == 6 or chart_id == 7


def first_pass_period_chart(chart_id: int, period: str):
    # no need to send packet to arbutus server on first pass of
    # a period charts as we are just responding with a empty html page with
    # period widget etc. this page in turn calls the web app for
    # chart data via ajax (see api calls).
    if is_trend_chart(chart_id) or is_user_period_chart(chart_id):
        if period == '':
            return True

    return False


def convert_date_for_graph(date: str):
    date_parts = date.split('-')
    # e.g. "1/31/2011" i.e. MM/dd/yyyy
    new_date = date_parts[1].strip() + '/' + date_parts[2].strip() + '/' + date_parts[0].strip()
    return new_date


def do_reports(server_socket: socket, user_name: str, args):    # chart_id, category, period
    # extract send parameters from args
    chart_id = args[0]
    category = args[1]
    period = args[2]
    results = []

    if not first_pass_period_chart(chart_id, period):
        # send the packet and get first reply (typically only one reply)
        report_result = send_report(server_socket, get_user_id(user_name), chart_id, category, period)

        while True:
            if report_result.get('cmd_type') == REPLY_SUCCESS or report_result.get('cmd_type') == REPLY_MORE:
                report = report_result.get('buffer').decode('utf-8').split('\000\000')

                # convert from tab separated results to client side expected JSON format
                for item in report[0].split('\000'):
                    record = {}
                    if len(item) > 0:
                        fields = item.split('\t')
                        try:
                            if is_trend_chart(chart_id):
                                record['symbol'] = fields[0]
                                record['items'] = fields[1]
                                record["date"] = convert_date_for_graph(fields[2])
                            else:
                                record['category'] = fields[0]
                                record['value'] = fields[1]

                        except IndexError:
                            assert "Report data incorrect"

                    results.append(record)

                if report_result.get('cmd_type') == REPLY_MORE:
                    report_result = get_reply(server_socket)
                else:
                    # break out if REPLY_SUCCESS
                    break
            else:
                # break out of loop if any message except REPLY_SUCCESS or REPLY_MORE
                # TODO return error in buffer on REPLY_FAILURE
                break

    return results, None


def do_restore(server_socket, user_name, args):  # backup_point
    restore_stamp = args[0]
    log_stamps = args[1]
    restore_result = send_restore(server_socket, get_user_id(user_name), restore_stamp)
    # no errors so far and we also have a list of log entries to restore.
    restore_log_result = None
    if restore_result.get('cmd_type') == 33000 and len(log_stamps) > 0:
        restore_log_result = do_restore_log(server_socket, user_name, log_stamps)

    return restore_result, restore_log_result


def do_enum_log(server_socket, user_name, restore_point):  # backup_point
    restore_result, buffer = send_enum_log(server_socket, get_user_id(user_name), restore_point[0])
    # return the buffer outside the restore_result as it maybe a concat of REPLY_MORE
    return restore_result, buffer


def do_restore_log(server_socket, user_name, log_stamps):  # start_date, end_date
    # Determine start and end sequences from list of selected logs.
    current_pos = int(log_stamps[0].get('value'))
    first_stamp = log_stamps[0].get('text')
    current = {'start': first_stamp, 'end': None}  # start, end

    for stamp in log_stamps:
        last_pos = current_pos
        current_pos = int(stamp.get('value'))
        if current_pos > (last_pos + 1):
            restore_log_result = send_restore_log(
                server_socket,
                get_user_id(user_name),
                current.get('start'),
                current.get('end')
            )
            if restore_log_result.get('cmd_type') != 33000:
                return restore_log_result

            current = {'start': stamp.get('text')}

        current['end'] = stamp.get('text')

    restore_log_result = send_restore_log(
        server_socket,
        get_user_id(user_name),
        current.get('start'),
        current.get('end')
    )
    return restore_log_result


def do_add_answer(server_socket, user_name, answers_info):

    answers_result = send_add_answer(
        server_socket, 
        get_user_id(user_name),
        answers_info[0])
      
    return answers_result, None