import struct

from common.auth import Password

from ..models import ServerProfile, ArbutusLogin
from ..arbutus_server.network import print_send
# common function used in sends to arbutus server


def build_asi_em_packet(buffer, mesg, dest_src):
    """

    :param dest_src: 
    :return: 
    :param mesg: 
    :param buffer:
    :return:
    """
    pacsize = len(buffer)
    server = 0
    flags = 0
    data_size = len(buffer)
    dest_srce_int = int(dest_src)

    print_send(pacsize, server, flags, mesg, data_size, dest_srce_int, buffer)

    str_fmt = '>HBBHHI%ds' % (pacsize,)
    buf = bytes(buffer)
    return struct.pack(
        str_fmt, pacsize, server, flags, mesg,
        data_size, dest_srce_int, buf)


def get_enc_password(username):
    """

    :param username:
    :return:
    """
    return Password.objects.filter(username__iexact=username).first()


def get_server_name():
    """

    :return: 
    """
    return ServerProfile.objects.get(active_server=True).name


def get_user_id(login_id):
    """

    :param login_id:
    :return: 
    """
    return ArbutusLogin.objects.get(login_id=login_id).user_id


def is_em_admin(login_id):
    """
    TODO review if using login_id is ok.
    :param login_id:
    :return: 
    """
    try:
        return ArbutusLogin.objects.get(login_id=login_id).is_admin
    except ArbutusLogin.DoesNotExist:
        return False


def get_name(login_id):
    """

    :param login_id:
    :return:
    """
    try:
        return ArbutusLogin.objects.get(login_id=login_id).name
    except ArbutusLogin.DoesNotExist:
        return login_id


def build_thread_with_form_buf(rm_form):

    # general form payload part
    buf = b'\t'
    buf += rm_form.get('form_id').encode()
    buf += b'\t'
    buf += rm_form.get('process_id').encode()
    buf += b'\t'
    buf += rm_form.get('state_id').encode()
    buf += b'\000'
    
    # for questions payload
    questions = rm_form.get('questions', '')
    for question in questions:
        x = 1
        # 'fieldname'
        buf += question.get('id').encode()
        buf += b'\t'
        buf += question.get('answer').encode()
        buf += b'\000'

    return buf