import json

from ..arbutus_server.connection import full_server_connect
from ..views_helper import VE_FORM_FIELD_NAMES
from ..arbutus.messages import get_enc_password

from .connection import do_server_socket, is_auth_ok
from .process_messages import check_result, extract_extra_result
from .messages import get_server_name
from .do_ve_messages import (
    do_em_ve_messages,
    do_dlg_add_or_update_ve_messages, do_dlg_ve_messages, do_delete_ve_messages
)


###
def process_em_ve_messages(login_username, enc_password, command, process_id, first_state_id, label, description, message_json):
    server_socket, result = do_server_socket(login_username, enc_password)
    return_result = None
    if is_auth_ok(result.get('cmd_type'), result.get('dest_srce')):
        connected, error = full_server_connect(server_socket, login_username, get_server_name())
        if not connected:
            return_result = None, error
        else:
            return_result = do_em_ve_messages(
                server_socket, login_username, command, process_id, label, description, message_json)

    server_socket.close()
    return return_result

###


# Generic dispatch to do*_ve_messages
def process_ve_messages(login_username, enc_password, do_ve_message, *args):
    server_socket, result = do_server_socket(login_username, enc_password)
    return_result = None
    if is_auth_ok(result.get('cmd_type'), result.get('dest_srce')):
        connected, error = full_server_connect(server_socket, login_username, get_server_name())
        if not connected:
            return_result = None, error
        else:
            return_result = do_ve_message(server_socket, login_username, *args)

    server_socket.close()
    return return_result


def process_dlg_ve_messages(dlg_type, user_name, enc_password, list_id):
    return process_ve_messages(user_name, enc_password, do_dlg_ve_messages, [dlg_type, list_id])


def process_dlg_add_or_update_ve_messages(command, dlg_type, user_name, enc_password, user_data):
    return process_ve_messages(user_name, enc_password, do_dlg_add_or_update_ve_messages, [dlg_type, command, user_data])


def process_delete_ve_messages(dlg_type, user_name, enc_password, items):
    return process_ve_messages(user_name, enc_password, do_delete_ve_messages, [dlg_type, items])


def process_dlg_ve_details(username, request_method, request_params):

    dialog_type = request_params.get('dialog_type')
    error = None

    if request_method == 'GET':
        list_id = request_params.get('list_id')
        result, _ = process_dlg_ve_messages(dialog_type, username, get_enc_password(username), list_id)

        record = {}
        # handle errors on result
        if result[0].get('cmd_type') != 33000:
            error = result[0].get('buffer').decode('utf-8')
        else:
            record['questions'] = []
            all_buf_list = result[0].get('buffer').decode('utf-8').rstrip('\x00').split('\x00')
            for outer_index in range(len(all_buf_list)):
                buf_list = (all_buf_list[outer_index]).split('\t') 
                if outer_index == 0:
                    inner_idx = 0
                    for form_field_name in VE_FORM_FIELD_NAMES.get(dialog_type):
                        try:
                            # form_field_name = "rmf-node-" + ffn
                            record[form_field_name] = buf_list[inner_idx]
                        except IndexError:
                            # allows us to skip less buffer field values than page field names,
                            # assuming order matches what is returned in buffer
                            # with the order specified in VE_FORM_FIELD_NAMES
                            pass

                        inner_idx += 1
                else:
                    record_question = {}
                    buf_list = (all_buf_list[outer_index]).split('\t') 
                    index = 0
                    for question_field_name in VE_FORM_FIELD_NAMES.get(dialog_type)[inner_idx - 1]:
                        record_question[question_field_name] = buf_list[index]
                        index += 1

                    record['questions'].append(record_question)

        output_result = {'error': error, 'result': record}
        json_data = json.dumps(output_result)

    else:   # 'POST'
        command = request_params.get("command")
        dlg_data = json.loads(request_params.get("form_data"))
    
        if command == 'Delete':
            result, _ = process_delete_ve_messages(dialog_type, username, get_enc_password(username), dlg_data)
        else:
            result, _ = process_dlg_add_or_update_ve_messages(
                command, dialog_type, username, get_enc_password(username), dlg_data)

        status, message, data = check_result(result, command, dialog_type, dlg_data)
        output_result = {'result': status, 'message': message, 'data': data}
        json_data = json.dumps(output_result)

    return json_data