import bz2
import socket
#from unittest import result

from ..arbutus_server.network import get_reply
from ..arbutus_server.constants import (
    REPLY_MORE, AEM_ENUM_USER_LOGIN,
    AEM_ADD_USER, AEM_CHANGE_USER, AEM_ADD_GROUP, AEM_CHANGE_GROUP,
    AEM_ADD_THREAD, AEM_ADD_THREAD_FORM, AEM_ADD_THREAD_NOTE,
    AEM_CLOSE_ACTIVITY, AEM_ENUM_ACTION, AEM_REASSIGN_ACTIVITY, AEM_CHANGE_UI,
    AEM_REPORT, AEM_RESTORE, AEM_ENUM_LOG, AEM_RESTORE_LOG,
    AEM_ADD_PROCESS, AEM_CHANGE_PROCESS, AEM_GET_ID
)

from .messages import build_asi_em_packet, build_thread_with_form_buf

# send the messages to arbutus server and get reply


# -- general send commands --

# AEM_ENUM_CMD

def send_enum_cmd(server_socket, message_command, item_id):
    buf = b''
    # TODO move to its own ve send message function
    if message_command == AEM_GET_ID:
        buf = str(item_id[0]).encode()
        item_id = int(item_id[1])
        
    send_packet = build_asi_em_packet(buf, message_command, item_id)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


# AEM_DELETE_CMD

def send_delete_cmd(server_socket, message_command, admin_id, list_id):
    buf = str(admin_id).encode()
    buf += b'\000'

    send_packet = build_asi_em_packet(buf, message_command, int(list_id))
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result

# ---users---


# AEM_ENUM_USER_LOGIN

def send_enum_user_login(server_socket, user_name):
    buf = user_name.encode()
    buf += b'\000'

    send_packet = build_asi_em_packet(buf, AEM_ENUM_USER_LOGIN, 0)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


# AEM_ADD_USER / AEM_CHANGE_USER

def send_add_or_change_user(server_socket, admin_id, user_info, command):
    buf = str(admin_id).encode()
    buf += b'\000'
    buf += user_info.get('name').encode()
    buf += b'\t'
    buf += user_info.get('login').encode()
    buf += b'\t'
    buf += user_info.get('email').encode()
    buf += b'\t'
    buf += user_info.get('initials').encode()
    buf += b'\t'
    buf += user_info.get('type').encode()
    buf += b'\t'
    buf += user_info.get('admin').encode()
    buf += b'\t'
    buf += user_info.get('notify').encode()
    buf += b'\t'
    buf += user_info.get('begins').encode()
    buf += b'\t'
    buf += user_info.get('ends').encode()
    buf += b'\000'
    # iterate over the user id's if any
    for group in user_info.get('groups'):
        buf += group.get('id').encode()
        buf += b'\000'

    buf += b'\000'

    if 'Create' in command:
        arbutus_server_msg = AEM_ADD_USER
        user_id = 0
    else:
        arbutus_server_msg = AEM_CHANGE_USER
        user_id = int(user_info.get('form_id'))

    send_packet = build_asi_em_packet(buf, arbutus_server_msg, user_id)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


# AEM_ADD_GROUP / AEM_CHANGE_GROUP

def send_add_or_change_group(server_socket, admin_id, group_info, command):
    # Group ID	Admin ID|name,desc|
    buf = str(admin_id).encode()
    buf += b'\000'
    buf += group_info.get('name').encode()
    buf += b'\t'
    buf += group_info.get('description').encode()
    buf += b'\t'
    buf += group_info.get('method').encode()
    buf += b'\000'
    # iterate over the user id's if any
    for user in group_info.get('users'):
        buf += user.get('id').encode()
        buf += b'\000'

    buf += b'\000'

    if 'Create' in command:
        arbutus_server_msg = AEM_ADD_GROUP
        group_id = 0
    else:
        arbutus_server_msg = AEM_CHANGE_GROUP
        group_id = int(group_info.get('form_id'))

    send_packet = build_asi_em_packet(buf, arbutus_server_msg, group_id)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result

# --- threads ----


# AEM_ADD_THREAD

def send_add_or_change_thread(server_socket, thread_info, command):
    # TODO only create (add) command, may add change later
    # NOTE unlike other adds or change commands, admin is not required for threads.

    # FYI. The client is still responsible for firing the AEM_ADD_THREAD_NOTE and AEM_ENUM_THREAD_ATTACH etc. ... 
    # as required as part of the handling of add_thread from the client side, this part just takes care of the 
    # original thread details as well as the rm form (if there is one, if not, standard AEM_ADD_THREAD called as before.)

    # type, desc, ref, process_name, priority, creator(submitter), attachment |
    buf = thread_info.get('type').encode()
    buf += b'\t'
    buf += thread_info.get('description').encode()
    buf += b'\t'
    buf += thread_info.get('ref').encode()
    buf += b'\t'
    buf += thread_info.get('nref').encode()
    buf += b'\t'
    buf += thread_info.get('process').encode()
    buf += b'\t'
    buf += thread_info.get('priority').encode()
    buf += b'\t'
    buf += thread_info.get('creator').encode()
    buf += b'\t'
    # buf += b''  # attachment field not currently used by web app, only server command
    buf += b'\000'

    msg = AEM_ADD_THREAD
    rm_form = thread_info.get('rmform')
    if (rm_form): 
        msg = AEM_ADD_THREAD_FORM
        buf += build_thread_with_form_buf(rm_form)

    buf += b'\000'    
    
    send_packet = build_asi_em_packet(buf, msg, 0)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


# AEM_CLOSE_ACTIVITY

def send_enum_close_activity(server_socket, user_id, activity_info):
    # User ID,next_state ID,cost,hrs,New user ID,*name/empty|
    buf = str(user_id).encode()
    buf += b'\t'
    buf += activity_info.get('next_state_id').encode()  # next_action_id
    buf += b'\t'
    buf += activity_info.get('cost').encode()
    buf += b'\t'
    buf += activity_info.get('hours').encode()
    buf += b'\t'
    buf += activity_info.get('nresult').encode()
    buf += b'\t'
    next_name = activity_info.get('new_user')
    if next_name != '0':
        buf += next_name.encode()

    buf += b'\000'

    activity_id = int(activity_info.get('form_id'))
    send_packet = build_asi_em_packet(buf, AEM_CLOSE_ACTIVITY, activity_id)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


# AEM_ENUM_ACTION

def send_enum_action_cmd(server_socket, activity_id, state_id):
    buf = str(activity_id).encode()
    # buf += b'\t'
    buf += b'\000'
    send_packet = build_asi_em_packet(buf, AEM_ENUM_ACTION, state_id)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


# AEM_REASSIGN_ACTIVITY

def send_enum_reassign_activity_cmd(server_socket, admin_id, new_user_id, activities):
    # Admin ID | activityID |… | |
    buf = str(admin_id).encode()
    buf += b'\000'
    for activity in activities:
        buf += str(activity).encode()
        buf += b'\000'

    buf += b'\000'

    send_packet = build_asi_em_packet(buf, AEM_REASSIGN_ACTIVITY, int(new_user_id))
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


# AEM_ADD_THREAD_NOTE

def send_add_thread_note(server_socket, user_id, thread_id, new_note):
    buf = str(user_id).encode()
    buf += b'\t'
    buf += new_note.encode()
    buf += b'\000'

    send_packet = build_asi_em_packet(buf, AEM_ADD_THREAD_NOTE, int(thread_id))
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


# AEM_CHANGE_UI

def send_change_ui(server_socket, user_id, config):
    buf = bz2.compress(config.encode())
    send_packet = build_asi_em_packet(buf, AEM_CHANGE_UI, int(user_id))
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


# AEM_REPORT

def send_report(server_socket: socket, user_id, chart_id, category, period):
    # share client side chart_ids with arbutus server, must agree on what they represent
    buf = str(chart_id).encode()
    buf += b'\t'
    # can be blank, used for drill downs on primary chart selection
    buf += str(category).encode()
    buf += b'\t'
    # we send two dates (from, to), passed here in form 'MM/dd/yyyy|MM/dd/yyyy'
    # with '|' separating from and to dates.
    buf += str(period).encode()
    buf += b'\000'

    send_packet = build_asi_em_packet(buf, AEM_REPORT, int(user_id))
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


# AEM_RESTORE

def send_restore(server_socket, user_id, backup_point):
    buf = backup_point.encode()
    buf += b'\000'

    send_packet = build_asi_em_packet(buf, AEM_RESTORE, int(user_id))
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


# AEM_ENUM_LOG      # enumerate the log (from a point)

def send_enum_log(server_socket, user_id, backup_point):
    buf = backup_point.encode()
    buf += b'\000'

    send_packet = build_asi_em_packet(buf, AEM_ENUM_LOG, int(user_id))
    server_socket.send(send_packet)

    buffer = b''
    while True:
        result = get_reply(server_socket)
        buffer += result.get('buffer', b'')
        if result.get('cmd_type') != REPLY_MORE:
            break

    return result, buffer


# AEM_RESTORE_LOG   # reprocess saved transactions

def send_restore_log(server_socket, user_id, start_date, end_date):
    # Message format: YYYY-MM-DD HH:MM:SS.nnn\YYYY-MM-DD HH:MM:SS.nnn\
    buf = start_date.encode()
    buf += b'\000'
    buf += end_date.encode()
    buf += b'\000'

    send_packet = build_asi_em_packet(buf, AEM_RESTORE_LOG, int(user_id))
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


# AEM_ADD_PROCESS / AEM_CHANGE_PROCESS

def send_add_or_change_process(server_socket, admin_id, process_info, command):
    # NO need to send mesg. to Analyzer Server
    # when we are updating a process, just fake the results
    # so that down stream client can carry on as per ususal.
    if command == 'Update':
        return {
            'buffer': b'\x00',
            'data_size': 1,
            'pacsize': 1,
            'server': 0,
            'flags': 0,
            'cmd_type': 33000,
            'dest_srce': 33000
        }

    # we should not be talking to the Arbutus hub server
    buf = str(admin_id).encode()
    buf += b'\t'
    buf += str(process_info.get('process_id')).encode()
    buf += b'\t'
    # NOTE: although this packet expects a first_state_id
    # as we do not have any states when adding a new process
    # we set this to 0 on browser side if ADD and keep if CHANGE
    buf += str(process_info.get('first_state_id')).encode()
    buf += b'\t'
    buf += process_info.get('label').encode()
    buf += b'\t'
    buf += process_info.get('description').encode()
    #serialno = process_info.get('serialno')
    #if len(serialno) > 0:
    #    buf += b'\t'
    #    buf += serialno.encode()

    buf += b'\000'
    buf += b'\000'

    if 'Create' in command:
        arbutus_server_msg = AEM_ADD_PROCESS
    else:
        arbutus_server_msg = AEM_CHANGE_PROCESS

    send_packet = build_asi_em_packet(buf, arbutus_server_msg, 0)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result
