import json

from ..arbutus_server.network import get_reply
from ..arbutus_server.constants import (
    AEM_ADD_FLOW, AEM_CHANGE_FLOW,
    AEM_ADD_FORM, AEM_DELETE_FORM, AEM_UPDATE_FORM,
    AEM_ADD_ACTION, AEM_CHANGE_ACTION,
    AEM_ADD_STATE, AEM_CHANGE_STATE,
    AEM_ROLLBACK_WORKFLOW, AEM_DELETE_STATE,
    AEM_ADD_ANSWER
)

from .messages import build_asi_em_packet

# send the messages to arbutus server and get reply


# AEM_ADD_FLOW / AEM_CHANGE_FLOW

def send_add_or_change_flow(server_socket, admin_id, flow_info, command):
    buf = str(admin_id).encode()
    buf += b'\t'
    process_id = str(flow_info.get('process_id'))
    process_id = process_id.replace("^", "") 
    buf += process_id.encode()
    buf += b'\t'
    first_state_id = str(flow_info.get('first_state_id'))
    first_state_id = first_state_id.replace("^", "") 
    buf += first_state_id.encode()
    buf += b'\t'
    buf += flow_info.get('process_label').encode()
    buf += b'\t'
    buf += flow_info.get('process_description').encode()
    serialno = flow_info.get('process_serialno')
    if (serialno == None):  # not sure how we get a None here, but just in case
        serialno = ''   
              
    if len(serialno) > 0:
         buf += b'\t'
         buf += serialno.encode()

    buf += b'\000'

    
    json_objects = json.loads(flow_info.get('savedModel'))
    json_dump = json.dumps(json_objects, separators=(',', ':')) # todo, we can order keys as before as well if required.
    buf += json_dump.encode()
    buf += b'\000'
    buf += b'\000'

    if command == 'Create':
        msg_process_cmd = AEM_ADD_FLOW
    else:
        msg_process_cmd = AEM_CHANGE_FLOW

    send_packet = build_asi_em_packet(buf, msg_process_cmd, 0)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


#   AEM_GET_FORM

def send_get_rmform_cmd(server_socket, message_command, all_ids):
    buf = b''
    # "form_id*processId*stateId"
    buf_id = all_ids.split('*')
    
    form_id = buf_id[2]
    form_id = form_id.replace("^", "") 
    buf += form_id.encode()
    buf += b'\t'
    process_id = buf_id[0]
    process_id = process_id.replace("^", "") 
    buf += process_id.encode()
    buf += b'\t'
    state_id = buf_id[1]
    state_id = state_id.replace("^", "") 
    buf += state_id.encode()
    buf += b'\000'
    buf += b'\000'

    send_packet = build_asi_em_packet(buf, message_command, 0)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result     


#   AEM_ADD_FORM / AEM_UPDATE_FORM

def send_add_or_change_form(server_socket, admin_id, rmf_info, command):
    # format "adminid\tform_id\tprocess_id\tstate_id\tlabel\tdescription"
    buf = str(admin_id).encode()
    buf += b'\t'
    form_id = str(rmf_info.get('form_id') )
    form_id = form_id.replace("^", "")
    buf += form_id.encode()
    buf += b'\t'
    process_id = str(rmf_info.get('process_id'))
    process_id = process_id.replace("^", "") 
    buf += process_id.encode()
    buf += b'\t'
    state_id = str(rmf_info.get('node_id'))
    state_id = state_id.replace("^", "") 
    buf += state_id.encode()     # state
    buf += b'\t'
    buf += rmf_info.get('label').encode()
    buf += b'\t'
    buf += rmf_info.get('description').encode()
    buf += b'\000'
    
    # iterate over the questions
    for question in rmf_info.get('questions'):
        question_id = str(question.get('question-rmid', 0))
        question_id = question_id.replace("^", "") 
        buf += question_id.encode()
        buf += b'\t'
        buf += question.get('type').encode()
        buf += b'\t'
        buf += question.get('thequestion').encode()
        buf += b'\t'
        buf += str(0).encode()  # question.get('columns').encode() 
        buf += b'\t'
        buf += question.get('choices').encode() # NOTE: multi-purpose holder of values based on type for context.
        buf += b'\t'
        buf += question.get('mandatory').encode()
        buf += b'\t'
        buf += question.get('fieldlength').encode()
        buf += b'\t'
        buf += question.get('fieldname').encode()
        buf += b'\000'

    # Note: require double null to mark end of unknown number of questions
    # Will also apply to other ve messages that send JSON, except *_FLOW.
    buf += b'\000'
    json_objects = json.loads(rmf_info.get('flow'))
    json_dump = json.dumps(json_objects, separators=(',', ':'))
    buf += json_dump.encode()
    buf += b'\000'
    buf += b'\000'

    if 'Create' in command:
        arbutus_server_msg = AEM_ADD_FORM
    else:
        arbutus_server_msg = AEM_UPDATE_FORM
        
    send_packet = build_asi_em_packet(buf, arbutus_server_msg, 0)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result
    

# Visual Editor object deletes FORM/ACTION/STATE

def send_ve_delete_cmd(server_socket, message_command, admin_id, rows):
    # user_id
    buf = str(admin_id).encode()
    buf += b'\t'
    # primary obj(state/action/form)_id
    row_id = str(rows[0])
    row_id = row_id.replace("^", "") 
    buf += row_id.encode()
    # //  "user_id\t form_id\t process id\t state_id'\0'\'0'"
    if (message_command == AEM_DELETE_STATE or message_command == AEM_DELETE_FORM) and len(rows) > 1:
        # process_id
        buf += b'\t'
        row_id = str(rows[1])
        row_id = row_id.replace("^", "") 
        buf += row_id.encode()
    if message_command == message_command == AEM_DELETE_FORM and len(rows) > 2:
        # state_id of rm-form
        buf += b'\t'
        row_id = str(rows[2])
        row_id = row_id.replace("^", "") 
        buf += row_id.encode()

    buf += b'\000'
    buf += b'\000'
    json_objects = json.loads(rows[3])
    json_dump = json.dumps(json_objects, separators=(',', ':'))
    buf += json_dump.encode()
    buf += b'\000'
    buf += b'\000'

    send_packet = build_asi_em_packet(buf, message_command, 0)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


# AEM_ADD_ACTION / AEM_CHANGE_ACTION

def send_add_or_change_action(server_socket, admin_id, action_data, command):
    buf = str(admin_id).encode()
    buf += b'\t'
    action_id = str(action_data.get('action_id'))
    action_id = action_id.replace("^", "") 
    buf += action_id.encode()
    buf += b'\t'
    process_id = str(action_data.get('process_id'))
    process_id = process_id.replace("^", "") 
    buf += process_id.encode()
    buf += b'\t'
    buf += str(action_data.get('to')).encode() 
    buf += b'\t'
    buf += str(action_data.get('from')).encode()
    buf += b'\t'
    buf += action_data.get('label').encode() 
    buf += b'\t'
    buf += action_data.get('choose').encode() 
    buf += b'\t'
    buf += action_data.get('description').encode() 
    buf += b'\000'
    buf += b'\000'
    json_objects = json.loads(action_data.get('flow'))
    json_dump = json.dumps(json_objects, separators=(',', ':'))
    buf += json_dump.encode()
    buf += b'\000'
    buf += b'\000'

    if 'Create' in command:
        arbutus_server_msg = AEM_ADD_ACTION
    else:
        arbutus_server_msg = AEM_CHANGE_ACTION

    send_packet = build_asi_em_packet(buf, arbutus_server_msg, 0)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


#   AEM_ADD_STATE / AEM_CHANGE_STATE

def send_add_or_change_state(server_socket, admin_id, state_data, command):
    buf = str(admin_id).encode()
    buf += b'\t'
    state_id = str(state_data.get('node_id'))
    state_id = state_id.replace("^", "") 
    buf += state_id.encode()
    buf += b'\t'
    process_id = str(state_data.get('process_id'))
    process_id = process_id.replace("^", "") 
    buf += process_id.encode()
    buf += b'\t'
    buf += state_data.get('label').encode() 
    buf += b'\t'
    buf += state_data.get('description').encode()
    buf += b'\t'
    buf += str(state_data.get('duration')).encode() 
    buf += b'\t'
    buf += state_data.get('method').encode() 
    buf += b'\t'
    buf += state_data.get('overdue').encode()
    buf += b'\t'
    buf += state_data.get('owner').encode() 
    buf += b'\t'
    buf += str(state_data.get('reminder')).encode() 
    buf += b'\t'
    buf += state_data.get('return').encode() 
    buf += b'\t'
    buf += state_data.get('type').encode() 
    buf += b'\t'
    buf += state_data.get('emergency').encode() 
    buf += b'\t'
    buf += state_data.get('subject').encode()
    buf += b'\t'
    buf += state_data.get('body').encode() 
    buf += b'\000'
    buf += b'\000' 
    json_objects = json.loads(state_data.get('flow'))
    json_dump = json.dumps(json_objects, separators=(',', ':'))
    buf += json_dump.encode()
    buf += b'\000'
    buf += b'\000'

    if 'Create' in command:
        arbutus_server_msg = AEM_ADD_STATE
    else:
        arbutus_server_msg = AEM_CHANGE_STATE

    send_packet = build_asi_em_packet(buf, arbutus_server_msg, 0)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result


#   AEM_ROLLBACK_WORKFLOW

def send_rollback_process(server_socket, admin_id, passed_process_id):
    buf = str(admin_id).encode()
    buf += b'\t'
    process_id = str(passed_process_id)
    process_id = process_id.replace("^", "") 
    buf += process_id.encode()
    buf += b'\000'
    buf += b'\000'

    send_packet = build_asi_em_packet(buf, AEM_ROLLBACK_WORKFLOW, 0)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result

# asipac->buffer:
#
#  "user_id\t form_id\t process id\t state_id\t thread_id\t activity_id'\0'"->first record
#   question_id\t answer_id\t answer_txt'\0'   //Note: answer_id ? who add it?
#   question_id\t answer_id\t answer_txt'\0'
#   *    ...........................................
#   * question_id\t answer_id\t answer_txt'\0'
#   '\0'"
#

#   AEM_ADD_ANSWER

def send_add_answer(server_socket, user_id, answer_info):
    buf = str(user_id).encode()                             # user
    buf += b'\t'
    form_id = str( answer_info.get('form_id') )             # form
    form_id = form_id.replace("^", "")
    buf += form_id.encode()
    buf += b'\t'
    process_id = str(answer_info.get('process_id'))         # process
    process_id = process_id.replace("^", "") 
    buf += process_id.encode()
    buf += b'\t'
    state_id = str(answer_info.get('state_id'))
    state_id = state_id.replace("^", "") 
    buf += state_id.encode()                                # state
    buf += b'\t'
    thread_id = str(answer_info.get('thread_id'))
    thread_id = thread_id.replace("^", "") 
    buf += thread_id.encode()                               # thread
    buf += b'\t'
    activity_id = str(answer_info.get('activity_id'))
    activity_id = activity_id.replace("^", "") 
    buf += activity_id.encode()                             # activity
    buf += b'\000'

    # iterate over the activity-close current form questions with answers
    for question in answer_info.get('questions'):
        question_id = str(question.get('id', 0))
        question_id = question_id.replace("^", "") 
        buf += question_id.encode()                         # question
        buf += b'\t'
        answer_text= str(question.get('answer', ' '))
        buf += answer_text.encode()                        # answer text   
        buf += b'\000'

    buf += b'\000'

    send_packet = build_asi_em_packet(buf, AEM_ADD_ANSWER, 0)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    return result
