import struct

from common.cryptor import Cryptor, encrypt_password
from common.constants import PASSLEN

from .constants import (
    REPLY_SUCCESS,
    DEFAULT_TIMEOUT, MINIMUM_COMPATIBLE, GUI_BLD, ASI_MAJOR, ASI_MINOR,
    CONNECT_MSG_1, CONNECT_MSG_3, CONNECT_MSG_5,
    LOGON_SUCCESS, RESULT_STATUS, REPLY_FAILURE
)
from .network import get_reply
from .set_cmds import send_vars, send_set_arrays, send_set_strings


def full_server_connect(server_socket, username, server_name):
    """
    TODO: to be diligent, this should be checked in all places it is called.
    currently only catch the successful login view when it gets user files
    which is the first time it is called.
    
    :param server_socket:
    :param username:
    :param server_name:  TODO, will need to change webconnect calling code
    when we switch it over to this common code.
    :return:
    """
    # packet info from server - 'NT logon in progress, build xxxx'
    print('LOGON SUCCESS')
    asipacket = get_reply(server_socket, LOGON_SUCCESS)

    # connect msg 3
    try:
        print('connect msg 3')
        send_packet = build_asi_packet_3(username, server_name)
        server_socket.send(send_packet)
        asipacket = get_reply(server_socket)
    except:
        buf = asipacket.get('buffer').decode('utf-8')
        buf += f'This RM Web application requires a Arbutus Hub server build >= {ASI_MAJOR}.{ASI_MINOR}.{MINIMUM_COMPATIBLE}'
        return False,  {'buffer': buf, 'cmd_type': REPLY_FAILURE}
    
    if asipacket.get('cmd_type') == REPLY_FAILURE:
        buf = asipacket.get('buffer').decode('utf-8')
        return False,  {'buffer': buf, 'cmd_type': REPLY_FAILURE}

    # connect msg 5
    print('connect msg 5')
    send_packet = build_asi_packet_5()
    server_socket.send(send_packet)
    asipacket = get_reply(server_socket, RESULT_STATUS)
    if asipacket.get('cmd_type') == RESULT_STATUS:
        return False, asipacket.get('buffer').decode('utf-8')

    # process recv packet - Session Initialized X.YY.ZZZZ
    get_reply(server_socket, REPLY_SUCCESS)  # 0

    # initialize server
    # print('initialize server')
    # initialize_server(server_socket)
    return True, ''


def initialize_server(server_socket):
    """

    :param server_socket:
    :return:
    """
    print('send_vars')
    send_vars(server_socket)
    print('send_set_arrays')
    send_set_arrays(server_socket)
    print('send_set_strings')
    send_set_strings(server_socket)


def build_connect_msg_3(username, server_name):
    """

    :param username:
    :param server_name:
    :return:
    """

    tot_len = 0
    buf_raw = b'\0\0'                    # compression level
    buf_raw += b'\0\0'                   # encryption
    buf_raw += b'\0'
    buf_raw += str(0).encode()           # server_id (profile ?) TODO
    buf_raw += b'\000'
    buf_raw += b'*'                      # special case for EM, not user prefix required.
    buf_raw += b'\000'
    buf_raw += server_name.encode()      # server name
    buf_raw += b'\000'
    buf_raw += str(DEFAULT_TIMEOUT).encode()        # timeout
    buf_raw += b'\000'
    buf_raw += str(MINIMUM_COMPATIBLE).encode()
    buf_raw += b'\000'
    buf_raw += str(GUI_BLD).encode()
    buf_raw += b'\000'
    buf_raw += str(ASI_MAJOR).encode()
    buf_raw += b'\000'
    buf_raw += str(ASI_MINOR).encode()
    buf_raw += b'\000'
    buf_raw += b'0'                      # scheduled_job
    buf_raw += b'\000'
    tot_len += len(buf_raw)
    return buf_raw, tot_len


def build_connect_msg_1(username, password, is_encrypted):
    """

    :param username:
    :param password:
    :param is_encrypted:
    :return:
    """
    buf_raw = str(0).encode()         # sets[290]=0000
    buf_raw += b'\000'
    buf_raw += b'EM_CLIENT/'  # client name #
    buf_raw += username.encode()      # user name logged in
    buf_raw += b'/E'                  # client type - /E = Exception Management
    buf_raw += b'\000'
    buf_raw += username.encode()      # b'luke_duguid' 	# User id
    buf_raw += b'\000'
    tot_len = len(buf_raw)
    if is_encrypted:
        # accommodate differences in how SQLite3 and PostreSQL store a BinaryField
        try:
            enc_passwd = password.password.tobytes()    # postgreSQL
        except AttributeError:
            enc_passwd = password.password              # SQLite3
    else:
        enc_passwd = encrypt_password(password)

    pass_len = PASSLEN + 1
    buf_raw += enc_passwd[:pass_len]
    tot_len += pass_len
    buf_rawx = str(1).encode()      # PROFILE_ENCRYPT - password HAS to be encrypted buffer!
    buf_rawx += b'\000'
    buf_rawx += b'IMS:OFF'          # PROFILE_IMS   TODO
    buf_rawx += b'\000'
    buf_rawx += b'SET281:OFF'       # SETS281   TODO
    buf_rawx += b'\000'
    tot_len += len(buf_rawx)
    buf_raw += buf_rawx
    return buf_raw, tot_len


def build_asi_packet_1(username, password, is_encrypted):
    """

    :param username:
    :param password:
    :param is_encrypted:
    :return:
    """

    with Cryptor() as cryptor:
        cryptor.resetkey()
        buffer, bufferlen = build_connect_msg_1(username, password, is_encrypted)
        result, enc_buffer, enc_buflen = cryptor.encrypt_buf(buffer, bufferlen)

    pacsize = enc_buflen.value              # socket.htons(buflen.value)
    server = 0
    flags = 0
    cmd_type = CONNECT_MSG_1                # socket.htons(CONNECT_MSG_1)
    data_size = enc_buflen.value            # socket.htons(buflen.value)
    dest_srce = MINIMUM_COMPATIBLE          # socket.htonl(MINIMUM_COMPATIBLE)
    str_fmt = '>HBBHHI%ds' % (enc_buflen.value, )
    return struct.pack(
        str_fmt, pacsize, server, flags, cmd_type,
        data_size, dest_srce, enc_buffer.raw)


def build_asi_packet_3(username, server_name):
    """

    :return:
    """
    buffer, buflen = build_connect_msg_3(username, server_name)
    pacsize = buflen
    server = 0
    flags = 0
    cmd_type = CONNECT_MSG_3
    data_size = buflen
    dest_srce = 0
    str_fmt = '>HBBHHI%ds' % (buflen, )
    return struct.pack(
        str_fmt, pacsize, server, flags, cmd_type,
        data_size, dest_srce, buffer)


def build_asi_packet_5():
    """

    :return:
    """
    pacsize = 0
    server = 0
    flags = 0
    cmd_type = CONNECT_MSG_5
    data_size = 0
    dest_srce = 0
    return struct.pack(
        '>HBBHHI', pacsize, server, flags, cmd_type, data_size, dest_srce
    )
