# various referenced constants that have meaning when referenced in
# appropriate context. see csdefine.h
#PASSLEN = 31
PACBUFSIZE = 65520
PACHEADERSIZE = 12
PACKETSIZE = PACBUFSIZE + PACHEADERSIZE
#MINIMUM_COMPATIBLE = 1016
WRITE_BUFFER_SIZE = 65520  # 'H' format requires 0 <= number <= 65535

LOGON_SUCCESS = 0

# CONNECT_MSG constants
EM_VERSION = 2
GUI_BLD = 9999
ASI_MAJOR = 9
ASI_MINOR = 0
MINIMUM_COMPATIBLE = 2400
DEFAULT_TIMEOUT = 3600

# results
RESULT_AUTHOK = 8000
RESULT_BADTSOID = 8001
RESULT_BADPASSWORD = 8002
RESULT_EXPPASSWORD = 8003
RESULT_INVPASSWORD = 8004
RESULT_REVOKEDTSOID = 8005
RESULT_AUTHFAIL = 8006
RESULT_SEATFAIL = 8007
RESULT_CONNREFUSED = 8008
RESULT_RACROUTEFAIL = 8009

# file commands
FILE_FWRITE = 10000
FILE_AFWRITE = 10001
FILE_READ_BINARY = 10014
FILE_READ_SERVEROBJ = 10015

# connection messages
CONNECT_MSG_1 = 12100
CONNECT_MSG_2 = 12200
CONNECT_MSG_3 = 12300
CONNECT_MSG_4 = 12400
CONNECT_MSG_5 = 12500

# CLU commands and constants
VIEW_SET = 1
VIEW_GET = 2
VIEW_REC = 3
VIEW_NEXT = 4
VIEW_SUGGEST_ROW = 5
VIEW_ONE_ROW = 6
VIEW_RAW_RECORDS = 7
VIEW_GET_REVERSE = 8

CLU_FILESIZE = 401
CLU_INITIALIZE = 15000
CLU_OPENFILE = 15004
CLU_CLOSEFILE = 15005
# CLU_CMD_GET_INX_FILE = 15017
CLU_CMD_DONE = 20000
CLU_CMD_OPEN = 20002
# CLU_CMD_PROGRESS = 20007
CLU_CMD_SETS = 20011
CLU_CMD_VIEW_SET = 20024
CLU_CMD_VIEW_GET = 20025
CLU_CMD_VIEW_REC = 20026
CLU_CMD_VIEW_NEXT = 20027
CLU_CMD_VIEW_SUGGEST_ROW = 20028
CLU_CMD_VIEW = 20056
CLU_CMD_SHARED_DIR = 20058
CLU_SET_COMPRESSION = 20078
CLU_CMD_COMMAND = 29999

# PACKET_COMPRESSED = 1
# PACKET_ENCRYPTED = 2

# reply's
RESULT_ERROR = 500
RESULT_LOG = 502
RESULT_PROGRESS = 505
RESULT_STATUS_TIMEOUT = 507
RESULT_STATUS = 510

REPLY_ANY = 0x8000
REPLY_SUCCESS = 0x80e8  # 33000
REPLY_FAILURE = 0x80e9  # 33001
REPLY_MORE = 0x80ea  # 33002
REPLY_EOF = 0x80eb  # 33003
REPLY_TIMEOUT = 0x80ec  # 33004
REPLY_ABORTED = 0x80ed  # 33005
REPLY_APPEND = 0x80ee  # 33006
REPLY_COMM_ERROR = -1

# stub schedule specific commands and constants
STUB_ANY = 0x9C00

SCHED_ONETIME = 1
SCHED_DAILY = 2
SCHED_WEEKLY = 3
SCHED_MONTHLY = 4
SCHED_FREQUENTLY = 5
SCHED_NOW = 6

ASIADMIN_CONNECT1 = 40000
ASIADMIN_SCHEDLIST = 40001
ASIADMIN_SCHEDLOGS = 40002  # ADMIN_TOOL
CLU_SCHEDULE_JOB = 40003
CLU_CAN_SCHEDULE = 40004
CLU_SCHEDULE_INFO = 40005
CLU_IS_SCHEDULED = 40006
CLU_SCHEDULE_DELETE = 40007
CLU_SCHEDULE_LIST = 40008
CLU_IS_SCHEDANY = 40009
CLU_KILL_PROCESS = 40010
CLU_GET_SERVERINFO = 40011
ASIADMIN_USERLIST = 40012
ASIADMIN_STOPSCHED = 40013

# Event Manager
AEM_START = 21000  # used to easily ID AEM messages
AEM_ENUM_USER = 21000
AEM_ADD_USER = 21001
AEM_CHANGE_USER = 21002
AEM_DELETE_USER = 21003
AEM_ENUM_USER_ACTIVE = 21004
AEM_ENUM_USER_ALL = 21005
AEM_ENUM_USER_GROUPS = 21006
AEM_ENUM_USER_LOGIN = 21007
AEM_CHANGE_UI = 21008
AEM_ENUM_UI = 21009
AEM_DEFAULT_UI = 21020
AEM_ENUM_GROUP = 21010
AEM_ADD_GROUP = 21011
AEM_CHANGE_GROUP = 21012
AEM_DELETE_GROUP = 21013
AEM_ENUM_GROUP_ACTIVE = 21014
AEM_ENUM_GROUP_ALL = 21015
AEM_ENUM_GROUP_USERS = 21026    # enumerate all groups that contain a particular user
AEM_ADD_MEMBER = 21021
AEM_DELETE_MEMBER = 21023
AEM_ENUM_PROCESS = 21030
AEM_ADD_PROCESS = 21031
AEM_CHANGE_PROCESS = 21032
AEM_DELETE_PROCESS = 21033
AEM_ENUM_PROCESS_ACTIVE = 21034
AEM_ENUM_PROCESS_ENTRY = 21035
AEM_ADD_FLOW = 21036
AEM_CHANGE_FLOW = 21037
AEM_ROLLBACK_WORKFLOW = 21038
AEM_ADD_STATE = 21039
AEM_CHANGE_STATE = 21040
AEM_DELETE_STATE = 21041
AEM_ADD_ACTION = 21042
AEM_CHANGE_ACTION = 21043
AEM_DELETE_ACTION = 21044
AEM_ENUM_ACTION = 21045
AEM_ENUM_THREAD = 21050
AEM_ADD_THREAD = 21051
AEM_ADD_THREAD_NOTE = 21052
AEM_DELETE_THREAD = 21053
AEM_ENUM_THREAD_ACTIVE = 21054
AEM_ENUM_THREAD_ALL = 21055
AEM_ENUM_THREAD_USER = 21056
AEM_ENUM_THREAD_ATTACH = 21057
AEM_ENUM_THREAD_NOTES = 21058
AEM_ENUM_ACTIVITY = 21060
AEM_REASSIGN_ACTIVITY = 21063
AEM_CLOSE_ACTIVITY = 21064
AEM_ENUM_ACTIVITY_ACTIVE = 21065
AEM_ENUM_ACTIVITY_ALL = 21066
AEM_ENUM_ACTIVITY_THREAD = 21067
AEM_ENUM_ACTIVITY_USER = 21068
AEM_ADD_ATTACH_OPEN = 21070
AEM_ADD_ATTACH_WRITE = 21071
AEM_ADD_ATTACH_CLOSE = 21072
AEM_GET_ATTACH_OPEN = 21075
AEM_GET_ATTACH_READ = 21076
AEM_GET_ATTACH_CLOSE = 21077
AEM_BACKUP = 21080          # backup the system
AEM_RESTORE = 21081         # restore a backup specified in the buffer
AEM_ENUM_BACKUPS = 21082    # enumerate available backups
AEM_ENUM_LOG = 21083        # enumerate the log (from a point)
AEM_RESTORE_LOG = 21084     # reprocess saved transactions
AEM_REPORT = 21090
AEM_FORM_START = 21100            # messages used by RM forms
AEM_GET_ID = 21101                # returns the next available ID from the id file
AEM_ENUM_FORM = 21102             # enumerates all forms
AEM_GET_FORM = 21103              # returns the form for requested process, state from FORM file using form id
AEM_ADD_FORM = 21104              # adds a new form to the form file
AEM_UPDATE_FORM = 21105           # updates the form in the form file
AEM_DELETE_FORM = 21106           # deletes ( negates form id )
AEM_GET_ANSWER = 21107            # returns all questions and answers available for the form
AEM_ADD_ANSWER = 21108            # adds the answer for the question in the answer file
AEM_UPDATE_ANSWER = 21109         # updates all answers in the answer file
AEM_ADD_THREAD_FORM = 21110       # add a thread and form (used with results command)
AEM_FORM_END = 21198
AEM_END = 21199                   # used to easily ID AEM message
