import struct

from .constants import (
    AEM_ADD_ATTACH_OPEN, AEM_ADD_ATTACH_WRITE, AEM_ADD_ATTACH_CLOSE,
    AEM_GET_ATTACH_OPEN, AEM_GET_ATTACH_READ, AEM_GET_ATTACH_CLOSE,
    WRITE_BUFFER_SIZE, REPLY_MORE, REPLY_SUCCESS
)
from .network import get_reply
from ..arbutus.messages import get_name


def split_chunk(byte_buffer, chunk_size):
    """

    :param byte_buffer:
    :param chunk_size:
    :return:
    """
    for i in range(0, len(byte_buffer), chunk_size):
        yield byte_buffer[i:i+chunk_size]


def handle_uploaded_file(server_socket, f, login_id, thread_id):
    """

    :param server_socket:
    :param f:
    :param login_id:
    :param thread_id:
    :return:
    """

    # it seems file write expects uncompressed
    # compress_packet = build_asi_packet_set_compress(0)
    # server_socket.send(compress_packet)
    # get_reply(server_socket)

    # open the server side file
    name = get_name(login_id)
    open_packet = build_asi_packet_open_file(thread_id, name, f.name)
    server_socket.send(open_packet)
    result = get_reply(server_socket)
    server_id = result.get('server', 0)

    current_chunk_size = WRITE_BUFFER_SIZE  # - 1
    # NOTE chunk_size= for infile does not come into effect for in memory (smaller files)
    for infile_chunk in f.chunks(chunk_size=current_chunk_size):

        # break up infile to network appropriate chunk sizes in case infile chunks are larger.
        for network_chunk in split_chunk(infile_chunk, current_chunk_size):
            network_chunk_len = len(network_chunk)
            file_packet = build_asi_packet_file_write(network_chunk, network_chunk_len, server_id)
            server_socket.send(file_packet)
            get_reply(server_socket)

    # close the server side file
    close_packet = build_asi_packet_close_file(server_id, AEM_ADD_ATTACH_CLOSE)
    server_socket.send(close_packet)
    result = get_reply(server_socket)
    attach_id = result.get('dest_srce', 0)
    buffer = result.get('buffer', '').decode('utf-8')
    if buffer:
        attach_fields = buffer.split('\t')

    who = ''
    if attach_fields[1]:
        who = attach_fields[1]

    created = ''
    if attach_fields[2]:
        created = attach_fields[2].strip('\x00')

    return attach_id, who, created

    # compress_packet = build_asi_packet_set_compress(1)
    # server_socket.send(compress_packet)
    # get_reply(server_socket)


def handle_download_file(server_socket, attach_id):
    open_packet = build_asi_packet_open_file_dl(attach_id)
    server_socket.send(open_packet)
    result = get_reply(server_socket)
    server_id = result.get('server', 0)
    filename = result.get('buffer', '')[:-1]
    return server_socket, server_id, filename


def get_file_download(server_socket, server_id, read_packet):
    while True:
        server_socket.send(read_packet)
        result = get_reply(server_socket, AEM_GET_ATTACH_READ)
        if result.get('cmd_type') == REPLY_MORE:
            yield result.get('buffer', b'')
        elif result.get('cmd_type') == REPLY_SUCCESS:
            yield result.get('buffer', b'')
            close_packet = build_asi_packet_close_file(server_id, AEM_GET_ATTACH_CLOSE)
            server_socket.send(close_packet)
            get_reply(server_socket)
            break
        else:
            break     # TODO handle arbutus server error

# def build_asi_packet_set_compress(toggle):
#     buf = b''
#     pacsize = 0
#     server = 0
#     flags = 0
#     cmd_type = CLU_SET_COMPRESSION
#     data_size = 0
#     dest_srce = toggle
#     str_fmt = '>HBBHHI%ds' % pacsize
#     return struct.pack(
#         str_fmt, pacsize, server, flags, cmd_type,
#         data_size, dest_srce, buf)


def build_asi_packet_open_file_dl(attach_id):
    """

    :param attach_id:
    :return:
    """

    buf = b''

    # build packet header
    buflen = 0
    pacsize = buflen
    server = 0
    flags = 0
    cmd_type = AEM_GET_ATTACH_OPEN
    data_size = buflen
    dest_srce = int(attach_id)
    str_fmt = '>HBBHHi%ds' % buflen
    return struct.pack(
        str_fmt, pacsize, server, flags, cmd_type,
        data_size, dest_srce, buf)


def build_asi_packet_file_read(server_id):
    """

    :param server_id:
    :return:
    """

    buf = b''

    # build packet header
    buflen = len(buf)
    pacsize = buflen
    server = server_id
    flags = 0
    cmd_type = AEM_GET_ATTACH_READ
    data_size = buflen
    dest_srce = 0
    str_fmt = '>HBBHHi%ds' % buflen
    return struct.pack(
        str_fmt, pacsize, server, flags, cmd_type,
        data_size, dest_srce, buf)


def build_asi_packet_open_file(thread_id, name, file_name):
    """

    :param thread_id:
    :param name:
    :param file_name:
    :return:
    """

    # build buffer
    buf = str(name).encode()
    buf += b'\t'
    buf += file_name.encode()
    buf += b'\000'

    # build packet header
    buflen = len(buf)
    pacsize = buflen
    server = 0
    flags = 0
    cmd_type = AEM_ADD_ATTACH_OPEN
    data_size = buflen
    dest_srce = int(thread_id)
    str_fmt = '>HBBHHi%ds' % buflen
    return struct.pack(
        str_fmt, pacsize, server, flags, cmd_type,
        data_size, dest_srce, buf)


def build_asi_packet_file_write(chunk, chunk_size, server_id):
    # build buffer
    buf = chunk

    # build ASI packet header
    pacsize = chunk_size
    server = server_id
    flags = 0
    cmd_type = AEM_ADD_ATTACH_WRITE
    data_size = pacsize
    dest_srce = chunk_size
    str_fmt = '>HBBHHi%ds' % pacsize
    return struct.pack(
        str_fmt, pacsize, server, flags, cmd_type,
        data_size, dest_srce, buf)


def build_asi_packet_close_file(server_id, msg):
    """

    :return:
    """

    buf = b''
    pacsize = 0
    server = server_id
    flags = 0
    cmd_type = msg
    data_size = 0
    dest_srce = 0
    str_fmt = '>HBBHHi%ds' % pacsize
    return struct.pack(
        str_fmt, pacsize, server, flags, cmd_type,
        data_size, dest_srce, buf)


# def build_asi_packet_read_file(result_packet):
#     """
#
#     :param result_packet:
#     :return:
#     """
#     buffer = str(WRITE_BUFFER_SIZE).encode()
#     buffer += b'\000'
#     buffer += result_packet.get('buffer', (b'',))
#     pacsize = result_packet.get('pacsize', 0)
#     server = result_packet.get('server', 0)   # TODO
#     flags = result_packet.get('flags', 0)
#     cmd_type = FILE_READ_BINARY
#     data_size = result_packet.get('data_size', 0)
#     dest_srce = result_packet.get('dest_srce', 0)
#     str_fmt = '>HBBHHI%ds' % pacsize
#     return struct.pack(
#         str_fmt, pacsize, server, flags, cmd_type,
#         data_size, dest_srce, buffer)

