import struct

from .constants import PACHEADERSIZE, CLU_CMD_DONE, REPLY_ANY, REPLY_MORE, AEM_GET_ATTACH_READ, RESULT_ERROR


def recv_packet(a_socket):
    """

    :param a_socket:
    :return:
    """
    asi_packet = {
        'pacsize': 0, 'server': '', 'flags': '', 'cmd_type': 0, 'data_size': 0, 'dest_srce': 0, 'buffer': b''
    }

    # get the packet header, which contains the buffer size.
    arecv_packet = a_socket.recv(PACHEADERSIZE)
    pacsize, server, flags, cmd_type, data_size, dest_srce = struct.unpack('>HBBHHi', arecv_packet)
    asi_packet['pacsize'] = pacsize
    asi_packet['server'] = server
    asi_packet['flags'] = flags
    asi_packet['cmd_type'] = cmd_type
    asi_packet['data_size'] = data_size
    asi_packet['dest_srce'] = dest_srce

    # get the packet buffer
    buffer = b''
    # rp_total = 0
    rp_left = pacsize
    # NOTE: do we need a safety on this to break
    # out of loop if something goes awry etc. ?
    while True:
        arecv_packet = a_socket.recv(rp_left)
        rp_length = len(arecv_packet)
        # rp_total += rp_length
        rp_left -= rp_length
        str_fmt = '>%ds' % (rp_length,)
        buf = struct.unpack(str_fmt, arecv_packet)
        buffer += buf[0]
        if rp_left <= 0:
            break

    asi_packet['buffer'] = buffer
    return asi_packet


def get_reply(a_socket, additional_cmdtype=None):
    """
    TODO : may need better way to ensure all packets are
    received, as when we break out of loop, there could
    in theory be more the be sent by server.
    :param a_socket:
    :param additional_cmdtype:
    :return:
    """
    count = 1
    asi_packets = {'buffer': b'', 'data_size': 0}

    while True:
        asipacket = recv_packet(a_socket)

        # TODO: diagnostics - comment out when ready
        print('get_reply count: ', count)
        # TODO if the count is > 1 we may need to modify so that we
        # TODO can pass back up the stack the results of all the received packets
        print_asipacket(asipacket)

        cmd = asipacket.get('cmd_type', None)
        if cmd == CLU_CMD_DONE or (cmd & REPLY_ANY) or cmd == additional_cmdtype:
            asi_packets['pacsize'] = asipacket['pacsize']
            asi_packets['server'] = asipacket['server']
            asi_packets['flags'] = asipacket['flags'] 
            asi_packets['cmd_type'] = asipacket['cmd_type'] 
            asi_packets['data_size'] += asipacket['data_size']
            asi_packets['dest_srce'] = asipacket['dest_srce'] 
            asi_packets['buffer'] += asipacket['buffer'] 
            if cmd != REPLY_MORE or additional_cmdtype == AEM_GET_ATTACH_READ:
                return asi_packets
            
        count += 1

    return None


def print_asipacket(asipacket):
    """

    :param asipacket:
    :return:
    """
    print('pacsize: ', asipacket.get('pacsize'))
    print('server: ', asipacket.get('server'))
    print('flags: ', asipacket.get('flags'))
    print('cmd_type: ', asipacket.get('cmd_type'))
    print('data_size: ', asipacket.get('data_size'))
    print('dest_srce: ', asipacket.get('dest_srce'))
    print('buffer: ', asipacket.get('buffer'))
    print('buffer length:', len(asipacket.get('buffer')))
    print()


def print_send(pacsize, server, flags, cmd_type, data_size, dest_srce, buffer):
    print("send->")
    print('pacsize: ', pacsize)
    print('server: ', server)
    print('flags: ', flags)
    print('cmd_type: ', cmd_type)
    print('data_size: ', data_size)
    print('dest_srce: ', dest_srce)
    print('buffer: ', buffer)
    print()
