import struct

from .constants import (
    CLU_CMD_SETS, CLU_CMD_COMMAND
)
from .network import get_reply


def build_asi_cmd_type_packet(buffer, cmd_type):
    """

    :param buffer:
    :param cmd_type:
    :return:
    """
    pacsize = len(buffer)
    server = 0
    flags = 0
    data_size = len(buffer)
    dest_srce = 0
    str_fmt = '>HBBHHI%ds' % (pacsize,)
    buf = bytes(buffer)
    return struct.pack(
        str_fmt, pacsize, server, flags, cmd_type,
        data_size, dest_srce, buf)


def build_asi_set_arrays_packet(buffer):
    """

    :param buffer:
    :return:
    """
    pacsize = 300
    server = 0
    flags = 0
    cmd_type = CLU_CMD_SETS
    data_size = 300
    dest_srce = 58
    str_fmt = '>HBBHHI300s'
    buf = bytes(buffer)
    return struct.pack(
        str_fmt, pacsize, server, flags, cmd_type,
        data_size, dest_srce, buf)


def send_vars(server_socket):
    """

    :param server_socket:
    :return:
    """
    print('------- No send/recv --------')


def send_set_arrays(server_socket):
    """

    :param server_socket:
    :return:
    """
    # TODO template of values for all users in database?
    # sets_str = [0] * 300
    sets_str = (
        1, 0, 2, 1, 0, 1, 12, 0, 0, 3, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 10, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 46, 44,
        44,
        0, 1, 0, 1, 20, 20, 32, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 50, 0, 50, 0, 50, 0, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0,
        141, 68, 77, 89, 146, 40, 1, 1, 223, 0, 1, 8, 0, 0, 0, 0, 188, 0, 2, 0, 0, 230, 227, 138, 138, 202, 217, 61, 0,
        0,
        0, 5, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 10, 0, 0, 0, 0, 0, 1, 255, 3, 0, 0, 0,
        0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0,
        0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0,
        10,
        0, 0, 0, 0, 50, 25, 0)
    send_packet = build_asi_set_arrays_packet(sets_str)
    server_socket.send(send_packet)
    get_reply(server_socket)


def send_set_strings(server_socket):
    """

    :param server_socket:
    :return:
    """
    buf = b"SET DATE 'mm/dd/yyyy'"
    send_packet = build_asi_cmd_type_packet(buf, CLU_CMD_COMMAND)
    server_socket.send(send_packet)
    get_reply(server_socket)

    buf = b"SET PICTURE '-999999.99'"
    send_packet = build_asi_cmd_type_packet(buf, CLU_CMD_COMMAND)
    server_socket.send(send_packet)
    get_reply(server_socket)

    buf = b"SET DESIGNATION 'Produced with Arbutus Analyzer by: Arbutus, luke'"
    send_packet = build_asi_cmd_type_packet(buf, CLU_CMD_COMMAND)
    server_socket.send(send_packet)
    get_reply(server_socket)

    buf = b"SET PERIODS '0 31 61 91 121 151 181 10000'"
    send_packet = build_asi_cmd_type_packet(buf, CLU_CMD_COMMAND)
    server_socket.send(send_packet)
    get_reply(server_socket)

    buf = b"SET MONTHS 'Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec '"
    send_packet = build_asi_cmd_type_packet(buf, CLU_CMD_COMMAND)
    server_socket.send(send_packet)
    get_reply(server_socket)

    buf = b"SET LOOP 10000"
    send_packet = build_asi_cmd_type_packet(buf, CLU_CMD_COMMAND)
    server_socket.send(send_packet)
    get_reply(server_socket)
