from django import forms

from crispy_forms.helper import FormHelper
from crispy_forms.layout import Submit, Layout, Field, HTML


class LoginForm(forms.Form):
    username = forms.CharField(label="Username", required=True)
    password = forms.CharField(
        label="Password",
        required=True,
        widget=forms.PasswordInput)
    # remember = forms.BooleanField(label="Remember Me?")

    helper = FormHelper()
    helper.form_method = 'POST'
    helper.form_class = 'form-signin'
    helper.layout = Layout(
        HTML('<div class="form-signin-heading">Welcome!</div>'),
        Field('username', id="username-field", css_class="form-control login-input", title="Username"),
        Field('password', id="password-field", css_class="form-control login-input", title="Password")
    )
    helper.add_input(Submit('login', 'Log in', css_class='btn login-btn'))


class SuccessForm(forms.Form):
    pass
    
    #helper = FormHelper()
    #helper.form_method = 'POST'
    #helper.add_input(Submit('logout', 'Log out', css_class='btn btn-lg btn-warning'))
