# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-04-18 20:42
#from __future__ import unicode_literals

from django.db import migrations, models
import django.utils.timezone
import result_manager.fields
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Password',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('password', models.BinaryField()),
                ('username', models.CharField(max_length=128, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServerProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(help_text='Name of Arbutus server', max_length=256)),
                ('host_name', models.CharField(help_text='Network hostname or IP', max_length=256)),
                ('port', models.IntegerField(help_text='Port Arbutus server is listening on')),
                ('timeout', models.IntegerField(default=60)),
                ('encryption', models.IntegerField(default=0)),
                ('compression', models.IntegerField(default=0)),
                ('active_server', result_manager.fields.OneTrueBooleanField(default=False, help_text='Arbutus server used by Event Manager.')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
