from django.db import models

from model_utils.models import TimeStampedModel

from .fields import OneTrueBooleanField


class ServerProfile(TimeStampedModel):
    # MVS = 0
    # NT = 1
    # NIX = 2
    # AS400 = 3
    # LOCAL = 4
    # SERVER_TYPE_CHOICES = (
    #     (MVS, 'MVS'),
    #     (NT, 'Windows'),
    #     (NIX, 'Linux'),
    #     (AS400, 'AS400'),
    #     (LOCAL, 'Local'),
    # )
    #
    # server_type = models.IntegerField(choices=SERVER_TYPE_CHOICES, default=NT, help_text='Arbutus server platform type')

    name = models.CharField(max_length=256, help_text='Name of Arbutus hub server')
    host_name = models.CharField(max_length=256, help_text='Network hostname or IP')
    port = models.IntegerField(help_text='Port Arbutus hub server is listening on')
    timeout = models.IntegerField(default=60)
    encryption = models.IntegerField(default=0)
    compression = models.IntegerField(default=0)
    active_server = OneTrueBooleanField(default=False, help_text='Arbutus hub server used by Result Manager.')

    def __str__(self):
        return self.name

# working tables to persist state across views/sessions etc.
# Should probably _NOT_ be exposed to admin


class ArbutusLogin(TimeStampedModel):
    login_id = models.CharField(max_length=128, unique=True)
    name = models.CharField(max_length=128, unique=True)
    user_id = models.IntegerField(unique=True)
    is_admin = models.BooleanField(default=False)

    def __str__(self):
        return self.name
