/**
 * Created by Ay on 2017-06-02.
 */

// dependant on activity_result_common.js

// activity close functions

function build_activity_dialog(
  activity,
  actions, actions_error,
  attachments,
  notes, notes_error
) 
{
  // populate the activity part of dialog
  // NOTE if here, we have already checked for activity error and would not have called here if there
  // was any

  $("#panel-details-container").html("");
  $("#panel-details-container").append(
    kendo.template($("#close-activity-panel-template").html())({
      activity: activity,
    })
  );
   
  $("#tabstrip").html("");
  // tabstrip for the activity dialog
  let tabstrip = $("#tabstrip")
    .kendoTabStrip({
      dataTextField: "text",
      dataContentField: "content",
      show: function (e) {
        $(".notes-list-item__content").each(function () {
          if (this.clientHeight > 48) {
            $(this).closest(".notes-list-item").addClass("hide-mode");
          }
        });
      },
      dataSource: [
        {
          text: "Forms",
          encoded: false,
          content: kendo.template(
            $("#close-activity-forms-panel-template").html()
          )({ activity: activity, showFormSave: true }),
        },
        {
          text: "Notes",
          encoded: false,
          content: kendo.template(
            $("#close-activity-notes-panel-template").html()
          )({ notes: notes, showAddNote: true }),
        },
        {
          text: "Attachments",
          encoded: false,
          content: kendo.template(
            $("#close-activity-attachments-panel-template").html()
          )({ activity: activity, attachments: attachments, showUploads: true }),
        },
      ],
    })
    .data("kendoTabStrip");

  $("#panelbar-details").kendoPanelBar({});
  $("#panelbar-forms").kendoPanelBar({});

  tabstrip.select(0);

  // init form components
  selectControlInit();
  datePickerInit();
  rangeSliderSet(activity);   //rangeSliderInit();
  dropZoneInit();
  
  // init module globals
  if (activity) {
    ArbutusFormCloseActivity.activity_id = activity.id;
    ArbutusFormCloseActivity.thread_id = activity.thread_id;
    if (activity.forms && activity.forms.length > 0) ArbutusFormCloseActivity.current_form_details = activity.forms[0];
  }

  // iterate over all activity data, extracting name and value
  $.each(activity, function (name, value) {
    // update the acitivites dialog with values.
    const form_elem_id = "#form_activities_" + name;
    $(form_elem_id).val(value);
    if (name == "state_description") {
      $("#dialog_state_description_id").attr("title", value);
    }

    /*
    // update attachments form with thread_id
    if (name == "thread_id") {
      // make sure hidden elem is populated, required for notes at the least.
      let form_elem_id = "#form_activities_" + name;
      $(form_elem_id).val(value);
    } else if (name == "state_description") {
      $("#dialog_state_description_id").attr("title", value);
    }
    */

  });

  // populate and display the actions part of dialog
  if (actions_error && actions_error.length > 0) {
    console.log(actions_error);
    $("#errors").html(actions_error);
    $("#messageModal").modal("show");
  } else {
    $("#action_buttons").html("");
    $.each(actions, function (idx, object) {
      let button_html =
        "<button " +
        'type="button" ' +
        'class="main-button activity-action-btn dialog_activities_save" ' +
        'id="' +
        object["state_id"] +
        '" ' +
        'data-label="' +
        object["label"] +
        '" ' +
        'data-description="' +
        object["description"] +
        '" ' +
        'title="' +
        object["description"] +
        '" ' +
        'data-to_user_id="' +
        object["to_user_id"] +
        '" ' +
        'data-names="' +
        object["names"] +
        '">' +
        object["label"] +
        "</button>";

      $("#action_buttons").append(button_html);
    });
  }

   // notes
   build_activity_notes(notes);

  /*
  // make attachments button blue if there is attachments with this thread
  if (attachments.length > 0) {
    $("#dialog_threads_attachment_id")
      .removeClass("btn-no-color")
      .addClass("btn-color");
  } else {
    $("#dialog_threads_attachment_id")
      .removeClass("btn-color")
      .addClass("btn-no-color");
  }
  */
}


function get_form_activity_data() 
{
  return {
    form_id: $("#form_activities_id").val(),
    type: $("#form_activities_type").val(),
    description: $("#form_activities_description").val(),
    ref: $("#form_activities_ref").val(),
    nref: $("#form_activities_nref").val(),
    priority: $("#form_activities_priority").val(),
    assignee: $("#form_activities_assignee").val(),
    creator: $("#form_activities_creator").val(),
    due: $("#form_activities_due").val(),
    closed: $("#form_activities_closed").val(),
    cost: $("#form_activities_cost").val(),
    hours: $("#form_activities_hours").val(),
    nresult: $("#form_activities_nresult").val(),
    process: $("#form_activities_process").val(),
    state: $("#form_activities_state").val(),
    new_user: $("#modal_activity_close_names").data("new_user"),
    next_state_id: $("#modal_activity_close_names").data("next_state_id"),
  };
}


function close_activity_add_answer(form_data) 
{
  if ( form_data === null || $.isEmptyObject(form_data) ) return;

  // No validation of mandatory fields when saving questions
  // as the user is able to save partial fields and come back
  // at a later time to complete the form. However, it should
  // be noted that when closing the activity, we validate all 
  // client side input including mandatory fields have an answer.

  $.ajax({
    url: "/result_manager/api/data/close-activity-add-answers",
    type: "POST",
    data: {
      form_data: JSON.stringify(form_data),
    },
    cache: false,
    dataType: "json",
    success: function (resp) {
      if (resp.error && resp.error.length > 0) {
        console.log(resp.error);
        $("#errors").html(resp.error);
        $("#messageModal").modal("show");
      }

      //ArbutusFormCloseActivity.current_form_details = null; // do NOT empty(null) form data model when saving.
    },
  });
}

function is_current_note_saved() 
{
  // warn user if this note has not been added.
  if ($("#form_node_new_notes").val().length > 0) {
    let err_msg = "There is an outstanding note that has not been added, click the Notes tab to Add or delete.";
    jQuery("#errors").html(err_msg);
    jQuery("#messageModal").modal("show");
    return false;
  }

  return true;
}

function process_activity_close() {

  if (!is_current_note_saved()) return;
  
  const form_details = get_form_activity_data();
  const current_rmform_data = get_current_rmform_values(true);
  
  // validation has failed when null, so we would not even attempt to close
  if ( current_rmform_data !== null ) {
    $.ajax({
      url: "/result_manager/api/data/close-activity",
      type: "POST",
      data: {
        activity_id: 0,
        form_data: JSON.stringify(form_details),
      },
      cache: false,
      dataType: "json",
      success: function (resp) {
        $("#grid").data("kendoGrid").dataSource.read();
        $("#modal_activities").modal("hide");
        if (resp.result == "OK") {
          close_activity_add_answer(current_rmform_data);
        } else {
          $("#errors").html(resp.message);
          $("#messageModal").modal("show");
        }

        ArbutusFormCloseActivity.current_form_details = null;
      },
      error: function (e) {
        console.log(e.message);
      },
    });
  }

}

// activity notes functions

function build_activity_notes(notes) {
  $("#form_node_new_notes").val(""); // clear previous new notes
  $("#form_node_all_notes").empty(); // clear all notes table before repopulating

  // populate notes table
  $.each(notes, function (idx, note) {
    // let note_text = note["note"].replace(/\\n/g, "</p><p>");
    // note_text = "<p>" + note_text;
    // note_text = note_text + "</p>";

    const noteListItem = `<li class="notes-list-item">
        <div class="notes-list-item__date">${note["created"]}</div> 
        <div class="notes-list-item__author">${note["who"]}</div>
        <div class="notes-list-item__content">${note["note"]}</div>
        <div class="note-list-cta-container">
            <button  class="contourless-button open-mode-hidden cta-show-note-content">Show more</button>
            <button  class="contourless-button open-mode-visible cta-hide-note-content">Show less</button>
        </div>
      </li>
      `;

    $("#form_node_all_notes").append(noteListItem);
  });

  $(".notes-list-item__content").each(function () {
    if (this.clientHeight > 48) $(this).closest(".notes-list-item").addClass("hide-mode");
  });

  jQuery(".cta-show-note-content").on("click", handleShowNoteContent);
  jQuery(".cta-hide-note-content").on("click", handleHideNoteContent);

  /*
  if (notes.length > 0) {
    $("#dialog_threads_notes_id")
      .removeClass("btn-no-color")
      .addClass("btn-color");
  } else {
    $("#dialog_threads_notes_id")
      .removeClass("btn-color")
      .addClass("btn-no-color");
  }
  */
}





// event handlers for activity close buttons and notes button

$(document).on("click", "#action_buttons .dialog_activities_save", function () {

  $("#modal_activity_close_names").data("next_state_id", this.id);

  // e.g. this.dataset , this.dataset['to_user_id'] & this.dataset['names']
  // if names then popup another dialog to select name
  if (this.dataset["to_user_id"] == "1") {
    // populate dialog select widiget
    let list_items = "";
    const names_list = this.dataset["names"].split(",");
    $("#form_activity_close_names option").remove();        // remove all previous appended names
    $.each(names_list, function (key, value) {
      list_items += "<option value=" + key + ">" + value + "</option>";
    });

    $("#form_activity_close_names").append(list_items);
    $("#modal_activity_close_names").modal("show");        // show the activity action names dialog
  } else {
    $("#modal_activity_close_names").data("new_user", this.dataset["to_user_id"]);
    process_activity_close();
  }

});

$(document).on("click", ".modal-footer .dialog_activities_names_save", function () {
    
  $("#modal_activity_close_names").modal("hide");

  // should only be one
  let names_array = [];
  $("#form_activity_close_names  option:selected").each(function () {
    names_array.push({ id: $(this).val(), name: $(this).text() });
  });

  // server side expects chosen group name to be prepended with '*'
  const new_user = "*" + names_array[0].name;
  $("#modal_activity_close_names").data("new_user", new_user);
  process_activity_close();

});

/*
// show attachments dialog (threads and activities page)
$(document).on("click", "#dialog_threads_attachment_id", function () {

  $("#modal_attachments").on("hide.bs.modal", function () {
    // files uploaded according to client side
    // to be sure, i guess we should actually get
    // attachment count from the server.
    if ($("div.template-download").length > 0) {
      // make attachments button green if there is attachments with this thread
      $("#dialog_threads_attachment_id")
        .removeClass("btn-no-color")
        .addClass("btn-color");
    } else {
      $("#dialog_threads_attachment_id")
        .removeClass("btn-color")
        .addClass("btn-no-color");
    }
  })
  .modal("show");

});

// show notes dialog (activities page)
$(document).on("click", "#dialog_threads_notes_id", function () {
  $("#modal_notes").modal("show");
});
*/

// handle 'save' of notes
$(document).on("click", "#dialog_activities_notes_save", function () {

  // check contents of writable text box, if len > 0, send to server;
  const new_note = $("#form_node_new_notes").val();
  const thread_id = $("#form_activities_thread_id").val();
  if (new_note.length > 0) process_activity_note_save(new_note, thread_id, true); // send to server

});

// show instructions modal
$(document).on("click", "#dialog_state_description_id", function () {
  const value = $("#dialog_state_description_id").attr("title");
  $("#instructions-msg").html(value);
  $("#instructionsModal").modal("show");
});
