$(window).on("resize", function () {
  kendo.resize($(".widget"));
});

var waitForFinalEvent = (function () {
  var timers = {};
  return function (callback, ms, uniqueId) {
    if (!uniqueId) {
      uniqueId = "Don't call this twice without a uniqueId";
    }
    if (timers[uniqueId]) {
      clearTimeout(timers[uniqueId]);
    }
    timers[uniqueId] = setTimeout(callback, ms);
  };
})();

// page loaded and document ready
$(document).ready(function () {
  // TODO only stores one chart width and height,
  // TODO will need array of values when allowing multiple chart resizing.
  // NOTE : see end callback for why...
  var chart_width = 420;
  var chart_height = 440;
  var chart_period = null; // TODO is the require to be global?
  var chart_params = [];

  // create DatePicker from input HTML element
  var start = $("#frompicker")
    .kendoDatePicker({
      //value: get_dbchart_initial_start_date(chart_id),
      dateInput: true, // specifies that DateInput is used for masking the input element
      change: startChange,
    })
    .data("kendoDatePicker");

  var end = $("#topicker")
    .kendoDatePicker({
      //value: get_dbchart_initial_end_date(chart_id),
      dateInput: true, // specifies that DateInput is used for masking the input element
      change: endChange,
    })
    .data("kendoDatePicker");

  // hide the drill down and tools chart windows children widgets on page load.

  $("#drill-down-window").children().hide();
  $("#chart-window").children().hide();

  // date helper functions

  function startChange() {
    //var start = $("#frompicker").data("kendoDatePicker");
    //var end = $("#topicker").data("kendoDatePicker");

    var startDate = start.value(),
      endDate = end.value();

    if (startDate) {
      startDate = new Date(startDate);
      startDate.setDate(startDate.getDate());
      end.min(startDate);
    } else if (endDate) {
      start.max(new Date(endDate));
    } else {
      endDate = new Date();
      start.max(endDate);
      end.min(endDate);
    }

    chart_period = format_period(start.value(), end.value());
  }

  function endChange() {
    //var start = $("#frompicker").data("kendoDatePicker");
    //var end = $("#topicker").data("kendoDatePicker");

    var endDate = end.value(),
      startDate = start.value();

    if (endDate) {
      endDate = new Date(endDate);
      endDate.setDate(endDate.getDate());
      start.max(endDate);
    } else if (startDate) {
      end.min(new Date(startDate));
    } else {
      endDate = new Date();
      start.max(endDate);
      end.min(endDate);
    }

    chart_period = format_period(start.value(), end.value());
  }

  function convert_date(stored_date) {
    var date_parts = stored_date.split("-");
    var year = parseInt(date_parts[0]);
    var month = parseInt(date_parts[1]);
    var day = parseInt(date_parts[2]);
    return month.toString() + "/" + day.toString() + "/" + year.toString();
  }

  function get_dbchart_initial_start_date(chart_id) {
    var date_key = "dbchart" + chart_id + "_initial_start_date";
    var stored_date = localStorage.getItem(date_key);
    if (stored_date != null) {
      return new Date(convert_date(stored_date));
    } else {
      var start_date = new Date(Date.now());
      start_date.setDate(start_date.getDate() - 7); // 7 days (1 week) before now
      return start_date;
    }
  }

  function get_dbchart_initial_end_date(chart_id) {
    var date_key = "dbchart" + chart_id + "_initial_end_date";
    var stored_date = localStorage.getItem(date_key);
    if (stored_date != null) {
      return new Date(convert_date(stored_date));
    } else {
      return new Date(Date.now());
    }
  }

  function format_period(start_value, end_value) {
    var date_format = "yyyy-MM-dd"; // "MM/dd/yyyy";
    var start_format = kendo.toString(start_value, date_format);
    var end_format = kendo.toString(end_value, date_format);
    return start_format + "|" + end_format;
  }

  function do_date(chart_id) {
    if (is_trend_chart(parseInt(chart_id))) {
      // 13 month trend charts, now() - 12 months but 1st day of that month.
      var start_date = new Date(Date.now());
      start_date.setMonth(start_date.getMonth() - 12); // (last 13 months)
      start_date.setDate(1);
      var end_date = new Date(Date.now());
      chart_period = format_period(start_date, end_date);
    } else if (is_period_chart(parseInt(chart_id))) {
      start.value(get_dbchart_initial_start_date(chart_id));
      start.max(end.value());

      end.value(get_dbchart_initial_end_date(chart_id));
      end.min(start.value());
      chart_period = format_period(start.value(), end.value());
      //persist_period(chart_id, chart_period)
    }

    // DISABLE inputs
    //make it readonly
    //$("#frompicker").attr("readonly", true);
    //$("#topicker").attr("readonly", true);
  }

  function persist_period(dbchart_id, period) {
    var date_key = "dbchart" + dbchart_id + "_initial_start_date";
    var start_date = period.split("|")[0];

    if (start_date != null) localStorage.setItem(date_key, start_date);

    date_key = "dbchart" + dbchart_id + "_initial_end_date";
    var end_date = period.split("|")[1];
    if (end_date != null) localStorage.setItem(date_key, end_date);
  }

  // create MultiSelect from select HTML element with checkbox
  var checkInputs = function (elements) {
    elements.each(function () {
      var element = $(this);
      var input = element.children("input");
      input.prop("checked", element.hasClass("k-state-selected"));
    });
  };
  // create MultiSelect from select HTML element
  var chart_menu = $("#chart-menu")
    .kendoMultiSelect({
      itemTemplate: "#:data.text#",

      autoClose: false,
      autoWidth: true,
      height: 500,
      dataBound: function () {
        var items = this.ul.find("li");
        setTimeout(function () {
          checkInputs(items);
        });
      },
      change: function () {
        // manage checkbox
        let items = this.ul.find("li");
        checkInputs(items);
      },
      select: function (e) {
        //let item = e.item;
        //let text = item.text();
        let value = e.dataItem.value;
        let div_id = "#" + "head-" + value;

        $(div_id).appendTo($("#main-content"));
        let chart_DOM_id = get_chart_DOM_id(div_id);
        let chart_button_DOM_id = "#" + "tools-" + chart_DOM_id;
        chart_DOM_id = "#" + chart_DOM_id;
        sidebar_chart_label(chart_DOM_id, true);
        $(chart_button_DOM_id).show();
        create_chart(chart_DOM_id, "0", get_period(chart_DOM_id));

        save_dashboard("main-content", main_content.items());
        save_dashboard("chart-sidebar", sidebar.items());
      },
      deselect: function (e) {
        //var dataItem = e.dataItem;
        //var item = e.item;
        let value = e.dataItem.value;
        let div_id = "#" + "head-" + value;
        let chart_DOM_id = get_chart_DOM_id(div_id);
        let chart_button_DOM_id = "#" + "tools-" + chart_DOM_id;
        chart_DOM_id = "#" + chart_DOM_id;
        if ($(chart_DOM_id).data("kendoChart"))
          $(chart_DOM_id).data("kendoChart").destroy();

        if (parseInt(chart_DOM_id.split("-")[1]) > 100) {
          // if drill-down chart, also display:none (visibiltiy: hidden will use space) the div
          $(chart_DOM_id).hide();
        }

        jQuery(div_id).appendTo("#chart-sidebar");

        sidebar_chart_label(chart_DOM_id, false);
        $(chart_DOM_id).removeClass("k-chart");
        $(chart_DOM_id).removeAttr("data-role");
        $(chart_DOM_id).removeAttr("style");
        $(chart_button_DOM_id).hide();

        save_dashboard("chart-sidebar", sidebar.items());
        save_dashboard("main-content", main_content.items());
      },
    })
    .data("kendoMultiSelect");

  var chart_input = chart_menu.input;
  chart_input.attr("readonly", "readonly");
  
  // tool button for charts - click event handler
  
  function onToolClick(e) {
    // get DOM id and chart number id
    var chart_DOM_id = '#' + get_chart_DOM_id(e.event.currentTarget.parentElement.id);
    var chart_id = chart_DOM_id.split('-')[1];
    var title = get_chart_title(chart_id, "0", null, false);  //"Chart " + chart_id + " details";
    var windows_exists = $("#chart-window").data("kendoWindow");

    if (!windows_exists) {
      // does not exist, create it
      $("#chart-window").kendoWindow({
        width: "440px",
        title: title,
        modal: true,
        visible: false,
        actions: ["Close"],
        open: function () {
          var chart_id = $("#chart-window").data("kendoWindow").options.chart_id;

          // fill chart type drop down with appropriate options
          var ddl = $("#chart-type-1").data("kendoDropDownList");
          var oldData = ddl.dataSource.data();    

          // Iterate over the dataItems and search for a value.
          var bIsPieFound = false;
          for (var x = 0; x < oldData.length; x++) {
            if (oldData[x].value == "pie") {
              if (is_trend_chart(parseInt(chart_id))) {
                // removes item
                ddl.dataSource.remove(oldData[x]);
                bIsPieFound = true;
                break;
              }

              bIsPieFound = true;
            }
          }

          if (!bIsPieFound && !is_trend_chart(parseInt(chart_id))) {
            // looped over all dataItem and did not find "pie" and
            // is NOT trend chart, add 'Pie' back
            ddl.dataSource.add({ text: "Pie", value: "pie" });
          }

          // select last saved choice
          var chart_type_key = "dbchart" + chart_id + "_type";
          var chart_type_value = localStorage.getItem(chart_type_key);
          if (chart_type_value) {
            ddl.value(chart_type_value);
          } else {
            if (is_trend_chart(parseInt(chart_id))) ddl.value("bar");
            else ddl.value("pie");
          }

          // is drill down chart
          var ddl2 = $("#chart-type-2").data("kendoDropDownList");
          if (has_drilldown(parseInt(chart_id))) {
            ddl2.enable(true);
            // select last saved choice
            var drilldown_chart_id = (parseInt(chart_id) + 100).toString();
            var chart_type_key = "dbchart" + drilldown_chart_id + "_type";
            var chart_type_value = localStorage.getItem(chart_type_key);
            if (chart_type_value) {
              ddl2.value(chart_type_value);
            } else {
              // NOTE: for now all drill down can use 'pie'
              ddl2.value("pie");
            }
          } else {
            ddl2.enable(false);
          }
        },
        close: function (e) {
          var chart_id = $("#chart-window").data("kendoWindow").options
            .chart_id;
          if (is_period_chart(parseInt(chart_id))) {
            persist_period(chart_id, chart_period);
            create_chart("#chart-" + chart_id, "0", chart_period);
          }
        },
      });

      windows_exists = $("#chart-window").data("kendoWindow");
    }

    windows_exists.options.chart_id = chart_id;
    windows_exists.title(title);
    windows_exists.center();
    windows_exists.open();

    // determine which chart tool widgets to show based chart type
    $("#chart-window").children().show();  // show all initially
    if (is_period_chart(parseInt(chart_id))) {
        // show calendars
        $("#datetime").children().show();
    }
    else {
        $("#datetime").children().hide();
    }
  }

  // initialize buttons
  $(".tools-chart").each(function (index) {
    $("#" + this.id).kendoButton({
      icon: "more-vertical",
      click: onToolClick,
    });

    // initialize hidden
    $("#" + this.id).hide();
  });

  // initialize chart type widgets

  function change_chart_type(chart_id, chart_type) {
    var chart = $("#chart-" + chart_id).data("kendoChart");
    if (chart) {
      // iterate over all series elements
      $.each(chart.options.series, function (index, value) {
        chart.options.series[index].type = chart_type.toLowerCase();
      });

      // store chart type for restoring charts
      var chart_type_key = "dbchart" + chart_id + "_type";
      localStorage.setItem(chart_type_key, chart_type.toLowerCase());

      // this allow refresh of chart on dropdown selection
      // but note will refresha gain when closing dialog.
      chart.refresh();
    }
  }

  $("#chart-type-1").kendoDropDownList({
    change: function (e) {
      change_chart_type(
        e.sender.element.parents().find("#chart-window").data("kendoWindow")
          .options.chart_id,
        this.value().toLowerCase()
      );
    },
  });

  $("#chart-type-2").kendoDropDownList({
    change: function (e) {
      var chart_id = e.sender.element
        .parents()
        .find("#chart-window")
        .data("kendoWindow").options.chart_id;
      var drilldown_chart_id = (parseInt(chart_id) + 100).toString();
      change_chart_type(drilldown_chart_id, this.value().toLowerCase());
    },
  });

  // Helper functions

  function get_chart_DOM_id(parent_id) {
    return parent_id.split("-")[1] + "-" + parent_id.split("-")[2];
  }

  function get_chart_title(chart_id, category, show_period, empty_title) {
    // TODO internationalization of strings?

    if (empty_title)
      return "";

    var period_output = "";
    if (is_period_chart(parseInt(chart_id))) {
      if (show_period) {
        var date_range = format_period(
          get_dbchart_initial_start_date(chart_id),
          get_dbchart_initial_end_date(chart_id)
        );
        period_output =
          "from " +
          date_range.split("|")[0] +
          " to " +
          date_range.split("|")[1];
      } else {
        period_output = "within period";
      }
    }

    if (chart_id === "1") return "Open items by workflow";
    else if (chart_id === "101")
      return "Open items for workflow " + category + " by state";
    else if (chart_id === "2") return "Open items by user";
    else if (chart_id === "102")
      return "Open items for user " + category + " by workflow";
    else if (chart_id === "3")
      return "Closed items by workflow " + period_output;
    else if (chart_id === "103")
      return "Closed items by user, for workflow " + category;
    else if (chart_id === "4") return "Closed items by user " + period_output;
    else if (chart_id === "104")
      return "Closed items by workflow, for user " + category;
    else if (chart_id === "5") return "Closed items trend, by workflow";
    else if (chart_id === "6")
      return "Opened items by workflow " + period_output;
    else if (chart_id === "7") return "Opened items by user " + period_output;
    else if (chart_id === "8") return "Opened items trend, by user";
    else if (chart_id === "9") return "Average time to close, by workflow";
    else if (chart_id === "109")
      return "Average time for workflow " + category + " by state";
    else if (chart_id === "10") return "Overdue items by workflow";
    else if (chart_id === "110")
      return "Overdue items for workflow " + category + " by state";
    else if (chart_id === "11") return "Overdue items by user";
    else if (chart_id === "111")
      return "Overdue items for workflow " + category + " by user";
    else alert("Chart not yet implemented!");
  }

  function sidebar_chart_label(chart_DOM_id, is_delete) {
    var chart_id = chart_DOM_id.split("-")[1];

    if (is_delete) {
      $(chart_DOM_id).text("");
    } else {
      $(chart_DOM_id).text(get_chart_title(chart_id, "", false, false));
    }
  }

  function get_title_period(chart_id) {
    var date_range = format_period(
      get_dbchart_initial_start_date(chart_id),
      get_dbchart_initial_end_date(chart_id)
    );
  }

  function get_period(chart_DOM_id) {
    //if (chart_period === null) {
    var chart_id = chart_DOM_id.split("-")[1];
    do_date(chart_id);
    //}

    return chart_period;
  }

  function has_drilldown(chart_id) {
    return (
      chart_id === 1  ||
      chart_id === 2  ||
      chart_id === 3  ||
      chart_id === 4  ||
      chart_id === 9  ||
      chart_id === 10 ||
      chart_id === 11
    );
  }

  function is_period_chart(chart_id) {
    return chart_id === 3 || chart_id === 4 || chart_id === 6 || chart_id === 7;
  }

  function is_trend_chart(chart_id) {
    return chart_id === 5 || chart_id === 8;
  }

  function is_drilldown_chart(chart_id) {
    return chart_id > 99;
  }

  // init. dashboard selection
  function load_dashboard_select(name, value) {
    let res = chart_menu.value().slice();
    res.push(value);
    chart_menu.dataSource.filter({});
    chart_menu.value(res);
  }

  // localStorage management
  function save_dashboard(container, items) {
    // extract div_id from items and make comma seperated string
    var div_ids = "";
    items.each(function (idx, item) {
      if (idx > 0) div_ids += ",";

      div_ids += item.id;
    });

    localStorage.setItem("dbchart_" + container, div_ids);
  }

  function load_dashboard() {
    // load sidebar
    $(["dbchart_chart-sidebar", "dbchart_main-content"]).each(function(idx, name) {
      const dbchart_sortables = localStorage.getItem(name);
      let sortable_div_ids = [];
      if (dbchart_sortables && dbchart_sortables.length > 0) {
        sortable_div_ids = dbchart_sortables.split(",");
        const parent_id = "#" + name.split("dbchart_")[1];
        // populate container with saved divs
        //let delay = 500; // 1/2 second delay on calling arbutus server
        
        
        $(sortable_div_ids).each(function (idx, name) {
          let div_id = "#" + name;
          $(div_id).appendTo($(parent_id));
          if (parent_id === "#main-content") {
            let chart_DOM_id = get_chart_DOM_id(div_id);
            let chart_id = chart_DOM_id.split("-")[1];
            load_dashboard_select(
              get_chart_title(chart_id, "", false, false),
              chart_DOM_id
            );

            let chart_button_DOM_id = "#" + "tools-" + chart_DOM_id;
            chart_DOM_id = "#" + chart_DOM_id;
            sidebar_chart_label(chart_DOM_id, true);
            $(chart_button_DOM_id).show();
            let chart_param = {'id': chart_DOM_id, 'period': get_period(chart_DOM_id) };
            chart_params.push(chart_param);
            //setTimeout(function () {
            //  create_chart(chart_DOM_id, "0", get_period(chart_DOM_id));
            //}, delay);
            //delay += 500; // to ensure that delay is introduced for every call
          }
        });
      }
    });

    if (chart_params.length > 0) {
      let chart_DOM_id = chart_params[0].id;
      let period = chart_params[0].period;
      create_chart(chart_DOM_id, "0", period);
    }
  }
  
  function clear_dashboard() {}
  
  // create windows and charts etc.
  var lastParentChartId = '0';
  function create_drilldown_window(parent_chart_id, chart_id, category) {
    var windows_exists = $("#drill-down-window").data("kendoWindow");
    var title = get_chart_title(chart_id, category, null); //"Chart " + chart_id + " details";
    var isParentChild = (parseInt(parent_chart_id) === parseInt(lastParentChartId));
    lastParentChartId = parent_chart_id;
    
    if (!windows_exists) {
      var windows_exists = $("#drill-down-window").kendoWindow({
        width: "600px",
        title: title, //"DrillDown",
        visible: false,
        actions: [
          "Close"
        ],
        close: function (e) {
          ; // console.log("drilldown close");
        }
      });
      
      windows_exists.data("kendoWindow").title(title);
      windows_exists.data("kendoWindow").center();
      windows_exists.data("kendoWindow").open();
    }
    else {
      windows_exists.title(title);
      if (!isParentChild)
        windows_exists.center();
      windows_exists.open();
    }
  }

  function create_dbchart_drilldown(chart_DOM_id, category, period) {
    var parent_chart_id = chart_DOM_id.split("-")[1];
    var drill_down_chart_id = (parseInt(parent_chart_id) + 100).toString();
    var url =
      "/result_manager/api/data/dbcharts/" +
      drill_down_chart_id +
      "/" +
      category;
    var drill_down_DOM_id = "#chart-" + drill_down_chart_id;

    // hide all drilldown divs

    $("#drill-down-window").children().hide();

    create_drilldown_window(parent_chart_id, drill_down_chart_id, category);

    create_chart(drill_down_DOM_id, category, period);

    $(drill_down_DOM_id).show();
  }

  function create_chart(chart_DOM_id, category, period) {
    var chart_id = chart_DOM_id.split("-")[1];
    var url =
      "/result_manager/api/data/dbcharts/" + chart_id + "/" + category;

    // get selected chart-type before destorying;
    // Not sure if this is the best aproach but seems fast enough to just destroy and
    // recreate on and
    if ($(chart_DOM_id).data("kendoChart")) {
      $(chart_DOM_id).data("kendoChart").destroy();
    }

    // store chart type for restoring charts
    var chart_type_key = "dbchart" + chart_id + "_type";
    var chart_type = localStorage.getItem(chart_type_key);

    if (is_trend_chart(parseInt(chart_id))) {
      // default to bar chart type for trend charts
      if (!chart_type) chart_type = "bar";

      $(chart_DOM_id).kendoChart({
        chartArea: {
          background: "#ffffff",
          width: 500,
        },
        dataSource: {
          transport: {
            read: {
              url: url,
              method: "get",
              dataType: "json",
              data: {
                period: period,
              },
            },
          },
          requestEnd: function(e) {
            chart_params.shift();
            if (chart_params.length > 0) {
              let chart_DOM_id = chart_params[0].id;
              let period = chart_params[0].period;
              create_chart(chart_DOM_id, "0", period);
            }
          },
          group: {
            field: "symbol",
          },

          sort: {
            field: "date",
            dir: "asc",
          },
          schema: {
            model: {
              fields: {
                date: {
                  type: "date",
                },
              },
            },
          },
        },
        title: {
          text: get_chart_title(chart_id, category, true, is_drilldown_chart(parseInt(chart_id))),
          font: "500 13px Rubik, Arial, Helvetica, sans-serif",
        },
        series: [
          {
            type: chart_type,
            field: "items",
            categoryField: "date",
            name: "#= group.value #",
          },
        ],
        seriesOver: function(e) {
          if (has_drilldown(parseInt(chart_id)) && !is_drilldown_chart(chart_id))
            $(chart_DOM_id).css("cursor", "zoom-in");
        },
        seriesLeave: function(e) {
          if (has_drilldown(parseInt(chart_id)) && !is_drilldown_chart(chart_id))
            $(chart_DOM_id).css("cursor", "grab");
        },
        legend: {
          position: "bottom",
          visible: true,
        },
        valueAxis: {
          labels: {
            format: "{0}",
            skip: 2,
            step: 2,
          },
        },
        categoryAxis: {
          labels: {
            format: "MMM yyyy",
          },
        },
        tooltip: {
          visible: true,
          template: "#= series.name #: #= value #",
        },
        plotArea: {
          margin: {
            top: 20,
            left: 1,
            right: 1,
            bottom: 1
          }
        },
        theme: "silver",
      });
    } else {
      // default to pie chart type for non-trend charts
      if (!chart_type) chart_type = "pie"; 
      $(chart_DOM_id).kendoChart({
        chartArea: {
          background: "#ffffff",
          width: 500,
        },
        dataSource: {
          transport: {
            read: {
              url: url,
              dataType: "json",
              method: "get",
              data: {
                period: period,
              },
            },
          },
          requestEnd: function(e) {
            chart_params.shift();
            if (chart_params.length > 0) {
              let chart_DOM_id = chart_params[0].id;
              let period = chart_params[0].period;
              create_chart(chart_DOM_id, "0", period);
            }
          },
          schema: {
            data: "data",
            type: "json",
            model: {
              fields: {
                category: { type: "string" },
                value: { type: "number" },
              },
            },
          },
        },
        title: {
          text: get_chart_title(chart_id, category, true, is_drilldown_chart(parseInt(chart_id))),
          font: "500 13px Rubik, Arial, Helvetica, sans-serif",
        },
        legend: {
          position: "bottom",
          visible: true,
        },
        seriesDefaults: {
          type: chart_type,
          labels: {
            visible: true,
            template: "${category}\n${value}",
            //format: "{0}"
          },
        },
        //seriesColors: ["red", "green"],
        series: [
          {
            field: "value",
            categoryField: "category",
            labels: {
              visible: true,
              template: "${category}\n${value}",
              //format: "{0}"
            },
          },
        ],
        seriesOver: function(e) {
          if (has_drilldown(parseInt(chart_id)) && !is_drilldown_chart(chart_id))
            $(chart_DOM_id).css("cursor", "zoom-in");
        },
        seriesLeave: function(e) {
          if (has_drilldown(parseInt(chart_id)) && !is_drilldown_chart(chart_id))
            $(chart_DOM_id).css("cursor", "grab");
        },
        tooltip: {
          visible: true,
          template: "${category} : ${value}",
        },
        plotArea: {
          margin: {
            top: 20,
            left: 1,
            right: 1,
            bottom: 1
          }
        },
        theme: "silver",
      });

      // iterate over all series elements
      var chart = $(chart_DOM_id).data("kendoChart");
      if (chart) {
        $.each(chart.options.series, function (index, value) {
          chart.options.series[index].type = chart_type.toLowerCase();
        });
      }
    }

    if (has_drilldown(parseInt(chart_id))) {
      // create drill-down event handler
      $(chart_DOM_id)
        .data("kendoChart")
        .bind("seriesClick", function (e) {
          // where is the drill down chart?
          create_dbchart_drilldown(chart_DOM_id, e.category, period);
        });
    }

    if (parseInt(chart_id) > 100) {
      // cannot drag drilldown charts to sidebar
      $(chart_DOM_id).addClass("disabled");
    }
  }

  $("#main-content .widget")
    .resizable()
    .resize(function (e) {
      // JQUERY SHOULD ONLY ADD CLASS ONCE EVEN IF EVENT FIRES MANY TIMES
      $(e.target).addClass("disabled");

      // only do this stuff once resizing is done
      waitForFinalEvent(
        function () {
          // Once we are done resizing allow widget to be drag/drop again
          $(e.target).removeClass("disabled");

          // refresh chart when resizing is done
          if ($("#chart").data("kendoChart")) {
            $("#chart").data("kendoChart").refresh();
          } else {
            // console.log("No chart reference while resizing!")
          }
        },
        500,
        "some unique string 1"
      );
    });

  var sidebar = $("#chart-sidebar")
    .kendoSortable({
      filter: ">div",
      cursor: "move",
      connectWith: "#main-content",
      placeholder: placeholder,
      //hint: hint,
      change: function (e) {
        console.log(
          "#chart-sidebar - change from " + e.oldIndex + " to " + e.newIndex
        );

        //var chart_DOM_id = '#' + e.item[0].id;
        var chart_DOM_id = get_chart_DOM_id(e.item[0].id);
        var chart_button_DOM_id = "#" + "tools-" + chart_DOM_id;
        chart_DOM_id = "#" + chart_DOM_id;

        if (e.oldIndex < 0 && e.newIndex >= 0) {
          // moved object from main-content -> sidebar,
          // create object labels to identify chart type
          sidebar_chart_label(chart_DOM_id, false);
          $(chart_DOM_id).removeClass("k-chart");
          $(chart_DOM_id).removeAttr("data-role");
          $(chart_DOM_id).removeAttr("style");
          $(chart_button_DOM_id).hide();
        } else if (e.oldIndex >= 0 && e.newIndex < 0) {
          // moved object from sidebar -> main-content
          sidebar_chart_label(chart_DOM_id, true);
          $(chart_button_DOM_id).show();
        }

        save_dashboard("chart-sidebar", sidebar.items());
      },
      cancel: function (e) {
        console.log("#chart-sidebar - cancel");
      },
      start: function (e) {
        console.log("#chart-sidebar - start");
      },
      end: function (e) {
        console.log("#chart-sidebar - end");
        //if (e.item && e.item.data("kendoChart")) {
        //    e.item.data("kendoChart").refresh();
        //}
      },
      move: function (e) {
        console.log("#chart-sidebar - move");
      },
    })
    .data("kendoSortable");

  var main_content = $("#main-content")
    .kendoSortable({
      filter: ">div",
      cursor: "move",
      connectWith: "#chart-sidebar",
      disabled: ".disabled",
      placeholder: placeholder,
      //hint: hint,
      change: function (e) {
        console.log(
          "#main-content - change from " + e.oldIndex + " to " + e.newIndex
        );
        //var parent_chart_DOM_id = '#' + e.item[0].id;
        var chart_DOM_id = "#" + get_chart_DOM_id(e.item[0].id);

        if (e.oldIndex < 0 && e.newIndex >= 0) {
          // moved object from sidebar -> main-content,
          // destroy existing chart if one and create chart
          create_chart(chart_DOM_id, "0", get_period(chart_DOM_id));
        } else if (e.oldIndex >= 0 && e.newIndex < 0) {
          // moved object from main-content -> sidebar, destroy chart
          if ($(chart_DOM_id).data("kendoChart"))
            $(chart_DOM_id).data("kendoChart").destroy();

          if (parseInt(chart_DOM_id.split("-")[1]) > 100) {
            // if drill-down chart, also display:none (visibiltiy: hidden will use space) the div
            $(chart_DOM_id).hide();
          }
        }

        save_dashboard("main-content", main_content.items());
        //$("#chart").data("kendoChart").refresh();
      },
      cancel: function (e) {
        console.log("#main-content - cancel");
      },
      start: function (e) {
        // NOTE : see end callback for why...
        var chart = $(e.item).children()[1]; // TODO  iterate over children to find chart_DOM_id
        chart_width = $(chart).data("kendoChart").getSize().width;
        chart_height = $(chart).data("kendoChart").getSize().height;
        console.log("#main-content - start");
      },
      end: function (e) {
        console.log("#main-content - end");

        if (e.item) {
          var chart = $(e.item).children()[1]; // TODO  iterate over children to find chart_DOM_id
          if ($(chart).data("kendoChart") && e.oldIndex === e.newIndex) {
            // NOTE: why is this necessary? Not sure but it seems that the chart has no size on the 'end'
            // callback but it had a size on the start callback.  So I grab the width and height on start so
            // that I can restore the values here.  It seems it is only necessary when you move a chart on
            // the main div but do not change its position.  The chart will render but it has lost styling etc.
            // and is flat. if you just redraw, its gets size and position wrong that is why I restore it.
            var size = $(chart).data("kendoChart").getSize();
            if (size.width === 0 && size.height === 0) {
              $(chart)
                .css("width", chart_width)
                .css("height", chart_height)
                .data("kendoChart")
                .resize();
              $(chart).data("kendoChart").redraw();
            }
          }
        }
      },
      move: function (e) {
        console.log("#main-content - move");
      },
    })
    .data("kendoSortable");

  load_dashboard();

  $("#chart-sidebar").hide();

  // expand
  // $(".panel-wrap").on("click", "span.k-i-sort-desc-sm", function(e) {
  //     var contentElement = $(e.target).closest(".widget").find(">div");
  //     $(e.target)
  //         .removeClass("k-i-sort-desc-sm")
  //         .addClass("k-i-sort-asc-sm");
  //
  //     kendo.fx(contentElement).expand("vertical").stop().play();
  // });
  //
  // // collapse
  // $(".panel-wrap").on("click", "span.k-i-sort-asc-sm", function(e) {
  //     var contentElement = $(e.target).closest(".widget").find(">div");
  //     $(e.target)
  //         .removeClass("k-i-sort-asc-sm")
  //         .addClass("k-i-sort-desc-sm");
  //
  //     kendo.fx(contentElement).expand("vertical").stop().reverse();
  // });
});

function placeholder(element) {
  return element.clone().addClass("placeholder");
}

/*
function hint(element) {
  // var height_factor = 1;
  // var width_factor = 1;
  // if ($(element).parent()[0].id === 'main-content') {
  //     height_factor = 3;
  //     width_factor = 2;
  // }

  return element.clone().addClass("hint"); //.height(40).width(220);
}
*/