$(document).ready(function () {
  ExceptionManagerGrid.loadGridStatesFromServer([deleteGroup]);
  sessionStorage.setItem("msg_filter", "ACTIVE");
  let searchPhrase = null;

  let grid = $("#grid")
    .kendoGrid({
      columns: [
        {
          field: "edit-delete-group",
          width: "90",
          title: " ",
          template:
            "<div class='buttons-holder'>" +
            "<button type='button' title='Edit' class='btn btn-xs command-btn command-edit'><span class='fa fa-pencil'></span></button>" +
            "<button type='button' title='Delete' class='btn btn-xs command-btn command-delete'><span class='fa fa-trash-o'></span></button>" +
            "</div>",
        },
        { field: "name", width: "150", title: "Name" },
        { field: "description", width: "250", title: "Description" },
        { field: "who", width: "150", title: "Who" },
        { field: "date", width: "150", title: "Date" },
        { field: "method", width: "90", title: "Method", hidden: true },
        {
          field: "id",
          width: "120",
          title: "ID",
          type: "number",
          hidden: true,
        },
      ],
      dataSource: {
        transport: {
          read: {
            url: "/result_manager/api/data/basic",
            type: "post",
            dataType: "json",
            data: {
              pathname: "groups",
              msg_filter: "ACTIVE",
              thread_activities_id: null,
              searchPhrase: null
            },
            dataType: "json",
          },
        },
        requestStart: function (e) {
          this.options.transport.read.data.msg_filter = sessionStorage.getItem(
            "msg_filter"
          );
          this.options.transport.read.data.searchPhrase = searchPhrase;
        },
        schema: {
          data: "rows",
          skip: "skip",
          take: "take",
          total: "total",
          pageSize: "pageSize",
          page: "page",
          id: "id",
        },
        pageSize: 250,
        serverPaging: true,
        serverSorting: true,
      },
      scrollable: {
        virtual: true,
      },
      /*
        pageable: {
            pageSizes: [10, 25, 50, "all"],
            pageSize: 25,
            numeric: false
        }, */
      selectable: "row",
      resizable: true,
      columnMenu: false,
      //filterable: true,
      reorderable: true,
      sortable: true,
      sort: function (e) {
        $("#grid .k-scrollbar-vertical").scrollTop(0);
        // manipulate the stlying of the grid column header
        styleColumnHeader(e.sort["field"], e.sort["dir"]);
      },
      toolbar: kendo.template($("#template").html()),
    }).data("kendoGrid");

  // load the page grid state if it has some
  ExceptionManagerGrid.setGridOptions("groups", [deleteGroup]);

  $("#grid")
    .kendoTooltip({
      filter: "button",
      position: "top",
      content: function (e) {
        let target = e.target; // the element for which the tooltip is shown
        return target.data("title") + " " + target.text(); // set the element text as content of the tooltip
      },
    })
    .data("kendoTooltip");

  // add column menu to toolbar
  let ds = [];
  for (let i = 0, max = grid.columns.length; i < max; i++) {
    let title = grid.columns[i].title;
    if (title.trim().length === 0)
      title = grid.columns[i].field;

    ds.push({
      encoded: false,
      text:
        "<input type='checkbox' checked='checked' class='check k-checkbox' data-field='" +
        grid.columns[i].field +
        "' id='" +
        grid.columns[i].field +
        "'/>" +
        "<label class='k-checkbox-label' for='" +
        grid.columns[i].field +
        "'>" +
        title +
        "</label>",
    });
  }

  // toolbar status dropdown creation.
  $("#status").kendoDropDownList({
    change: function (e) {
      let name = e.sender.value();
      if (name.length === 0) name = "active";

      // filter status by selected option value
      let msgFilter = name.toUpperCase();
      sessionStorage.setItem("msg_filter", msgFilter);
      $("#grid").data("kendoGrid").dataSource.read({
        msg_filter: msgFilter,
        searchPhrase: searchPhrase
      });
    },
  });

  // column menu on toolbar handler
  $("#column-menu").kendoMenu({
    dataSource: [
      {
        text: "Columns",
        imageUrl: "/static/result_manager/arbutus-img/columns12x12.png",
        items: ds,
      },
    ],
    openOnClick: true,
    closeOnClick: false,
    open: function () {
      // deselect hidden columns
      $.each(grid.columns, function () {
        if (this.hidden) {
          let selector = "input[data-field='" + this.field + "']";
          $(selector).prop("checked", false);
        }
      });
    },
    select: function (e) {
      // ignore click on top-level menu button
      if ($(e.item).parent().filter("div").length) return;

      let input = $(e.item).find("input.check");
      let field = $(input).data("field");
      if ($(input).is(":checked")) {
        grid.showColumn(field);
      } else {
        grid.hideColumn(field);
      }
    },
  });

  $("#btnDelete").prop("disabled", true);

  $("#grid").on("click", "tbody tr", function (e) {
    let isDeleteBtn =
      ($(e.target).hasClass("command-delete") &&
        $(e.target).prop("disabled") == false) ||
      ($(e.target).parent().hasClass("command-delete") &&
        $(e.target).parent().prop("disabled") == false);

    // open grid item if not delete button
    if (!isDeleteBtn) {
      // open user edit dialog
      let grid = $("#grid").data("kendoGrid");
      let selected = $(e.currentTarget).closest("tr");
      let row_data = grid.dataItem(selected);
      if (row_data == null) return;

      ExceptionManagerServer.setCurrentID(row_data.id);
      ExceptionManagerServer.setCurrentCommand("Update");
      ExceptionManagerServer.api_data_details_get("groups");
    }
  });

  $(document).on("click", ".command-delete", function (e) {
    deleteGroup(e);
  });

  function deleteGroup(e) {
    e.preventDefault();
    ExceptionManagerServer.setCurrentID(
      $("#grid").data("kendoGrid").dataItem($(e.currentTarget).closest("tr")).id
    );
    $("#deleteConfirmModal").modal("show");
  }

  /* toolbar buttons */

  // show the users empty form dialog
  $(".toolbar-top").on("click", "button#btnAdd", function () {
    ExceptionManagerServer.setCurrentCommand("Create");
    $("#form_groups_id").hide();
    $("#modal_groups")
      .on("hide.bs.modal", function (e) {
        $(this).find("form").trigger("reset");
        $("select").scrollTop(0);
        $(".dual-select").bootstrapDualListbox("refresh", true);
      })
      .on("shown.bs.modal", function (e) {
        $("input:text:visible:enabled", this)
          .not('[readonly="readonly"]')
          .first()
          .focus();
      })
      .modal("show");
  });

  $(".toolbar-top").on("click", "button#btnDelete", function () {
    $("#deleteConfirmModal").modal("show");
  });

  // handle save of users dialog form data
  $("#dialog_groups_save_id").click(function () {
    let users_array = [];
    $("#form_groups_users  option:selected").each(function () {
      users_array.push({ id: $(this).val(), name: $(this).text() });
    });

    let form_data = {
      form_id: $("#form_groups_id").val(),
      name: $("#form_groups_name").val(),
      description: $("#form_groups_description").val(),
      method: $("#form_groups_method option:selected").val(),
      users: users_array,
    };

    // send data to server
    ExceptionManagerServer.api_data_details("groups", form_data);
  });
   
  // event handler for search widget
  $("#search").keyup(function () {
    searchPhrase = $(this).val();
    // NOTE: pulling grid data from webserver maybe too 
    // expensive/slow for each key up???
    ExceptionManagerGrid.refreshGrid();
  });

});
