var ArbutusVisualEditor = {
  currentCommand: null,
  isVisualEdit: false,
  dialogCancelled: true,
  editRMFormIDs: null, // used for persisting the edited, selected RM Form ID's required for get-a-rmform, for restoring on all form dropddown blank.
  previousFormListSelection: null, // required for form lis search clearing prev. selection
};


go.licenseKey =
  "2bf843e7b36f58c511895a25406c7efb0bab2d67ce864df35e0017f2ed587a04249eb82a50d1d8c585ff4cab1a2a90dcd8c661219319023ce630d58e40b6d6f1b63124b71601418aac5774c59caa7ef6f82f70a6c7bd65b2dc2ddcf4ebfa939d4ef8f0d548c211bb367b0e";


/*
  This global bound event handler for onbeforeunload will warn a user
  when they try to move away from the workflow after a change has been made
  it will provide the choice of indeed navigating away and losing any changes
  or stay on the page so that the workflow can be saved.
*/
window.onbeforeunload = confirmExit;
var wf_timeout;
function confirmExit(event)
{
  if ( sessionStorage.getItem("process_entry") && 
  (JSON.stringify(JSON.parse(myDiagram.model.toJson())) !== JSON.stringify(JSON.parse(sessionStorage.getItem("process_entry")))) ) {

    wf_timeout = setTimeout(function() {

      // user stayed, remove all class='active' on nav menu list items, 
      // the only current active should be what item the user clicked on the navbar.
      jQuery('ul#menu.nav').find(".active").removeClass("active");

      // set back to 'Workflow' list item.
      // NOTE: if nav bar list items reshuffled, added, deleted etc. the position 7 might change.
      jQuery('ul#menu.nav').children().eq(7).addClass('active');
    
    }, 1000);
    
    event.returnValue = true;
    return true;
  }
}


$(document).ready(function () {
  jQuery.noConflict();

  let tabstrip = jQuery("#tabstrip")
    .kendoTabStrip({
      /*
      animation: {
        close: {
          duration: 250,
          effects: "fadeOut"
         },
        // fade-in new tab over 125 milliseconds
        open: {
            duration: 125,
            effects: "fadeIn"
        }
      },
      */
      dataTextField: "text",
      dataContentField: "content",
      show: function (e) {
        // default is too not show these 2 divs but
        // TODO will need to consider loading existing choices.
        //jQuery('.rmf-question-choices-container').show();    // show choices
        //jQuery('.rmf-question-numeric-container').hide();    // hide numeric
      },
      /*
      dataSource: [
        {
            text: "<b>Question 1</b>",
            encoded: false,
            content: kendo.template(jQuery("#template1").html())({})
        },
      ]*/
    })
    .data("kendoTabStrip");

  // tabstrip change support function

  function UpdateTabStripData(tabstrip) {
    function UpdateTabStripContentDOMIds(outer_index) {
      // only modify parents matching children DOM IDs.
      let parent =
        "#tabstrip .k-content#tabstrip-" +
        outer_index +
        ' *[id^="rmf-question-id-"]';
      jQuery(parent).each(function (_inner_index, elem) {
        let old_id = elem.id;
        let i = old_id.lastIndexOf("-");
        let new_id = old_id;
        if (i > 0) {
          i++;
          new_id = old_id.substring(0, i) + outer_index;
        }

        // update both the id and name
        elem.id = new_id;
        elem.name = new_id;

        // if the elem has a prev/next sibling label, change its label for= to match elem's new_id.
        let sib_id_hash = "#" + new_id;
        let prev_label = jQuery(sib_id_hash).prev("label");
        if (prev_label.length > 0) prev_label.attr("for", new_id);
        let next_label = jQuery(sib_id_hash).next("label");
        if (next_label.length > 0) next_label.attr("for", new_id);
      });
    }

    tabstrip.tabGroup.children().each(function (index, item) {
      index++;

      // update all question text with newIndexes.
      jQuery(item)
        .find(".k-link")
        .text(`Question ${index}`)
        .prepend(
          '<img class="k-image" alt="" src="/static/result_manager/img/drag-icon.svg"></img>'
        );

      UpdateTabStripContentDOMIds(index);
    });
  }

  jQuery("#tabstrip ul.k-tabstrip-items").kendoSortable({
    filter: "li.k-item",
    axis: "x",
    container: "ul.k-tabstrip-items",
    hint: function (element) {
      return jQuery(
        "<div id='hint' class='k-widget k-tabstrip'><ul class='k-tabstrip-items k-reset'><li class='k-item k-state-active k-tab-on-top'>" +
          element.html() +
          "</li></ul></div>"
      );
    },
    start: function (e) {
      let tabstrip = jQuery("#tabstrip").data("kendoTabStrip");
      tabstrip.activateTab(e.item);
    },
    change: function (e) {
      let tabstrip = jQuery("#tabstrip").data("kendoTabStrip");
      let reference = tabstrip.tabGroup.children().eq(e.newIndex);

      if (e.oldIndex < e.newIndex) {
        tabstrip.insertAfter(e.item, reference);
      } else {
        tabstrip.insertBefore(e.item, reference);
      }

      let swapArrayElements = function (a, o, n) {
        if (a && a.length === 1) return a; // bail if only 1 element.
        let removed = a.splice(o, 1)[0];
        if (n > o) a.splice(n, 1, removed);
        else a.splice(n, 0, removed);
      };

      // update node model which contains question array (in question order)
      swapArrayElements(
        myDiagram.selection.first().data.rmf_questions,
        e.oldIndex,
        e.newIndex
      );

      UpdateTabStripData(tabstrip);
    },
  });

  //jQuery('.selectpicker').tooltip('disable');

  tabstrip.wrapper.on("click", "[data-type='remove']", function (e) {
    e.preventDefault();
    e.stopPropagation();

    jQuery("#confirm")
      .kendoConfirm({
        title: "Remove Question",
        content:
          "Are you sure you want to <strong>Remove</strong> this Question?",
        messages: {
          okText: "Yes",
          cancel: "No",
        },
      })
      .data("kendoConfirm")
      .result.done(function () {
        jQuery("body").append(jQuery('<div id="confirm">'));

        // remove clicked item
        let idAttribute = jQuery(e.target).closest(".k-content").attr("id");
        let elem = jQuery(`[aria-controls=${idAttribute}]`);
        const index = elem.index();
        tabstrip.remove(elem.index());

        // delete data and form question-rmid
        myDiagram.selection.first()?.data.rmf_questions.splice(index, 1);
        let domId = "#rmf-question-id-question-rmid-" + (index + 1);
        jQuery(domId).val(-1);

        UpdateTabStripData(tabstrip);

        let item_count = tabstrip.tabGroup.children("li").length;

        // select last tab item
        tabstrip.select(item_count - 1);

        // disable close button if item_count is 1, as
        // a form with no questions does not seem valid.
        if (item_count <= 1) {
          let item = jQuery("[data-type='remove']");
          item.prop("disabled", true).addClass("k-state-disabled");
        }

        /////////////////////////////////////////////////////////////
      })
      .fail(function () {
        jQuery("body").append(jQuery('<div id="confirm">'));
      });
  });

  jQuery("#add-question").click(function (e) {
    e.preventDefault(); // prevent click posting

    let item_count = tabstrip.tabGroup.children("li").length;

    tabstrip.append([
      {
        text: `Question ${item_count + 1}`,
        imageUrl: "/static/result_manager/img/drag-icon.svg",
        encoded: false, // Allows use of HTML for item text
        content: kendo.template(jQuery("#question-template").html())({
          qid: item_count + 1,
          quest: null
        })
      }
    ]);

    create_type_dropdown(item_count + 1, 5);  // default is 5:'Short Answer'

    // check count of items and if it was one, enable the disabled state original
    if (item_count <= 1) {
      let item = jQuery("[data-type='remove']");
      item.first().prop("disabled", false).removeClass("k-state-disabled");
    }

    tabstrip.select(tabstrip.tabGroup.children("li").length - 1);

    show_hide_form_containers(5, item_count + 1); // default is 5:'Short Answer'
    datePickerInit();
    numericInputInit();
    selectControlInit();

    // form question-rmid
    if (
      typeof myDiagram.selection.first()?.data.rmf_questions === "undefined" ||
      !Array.isArray(myDiagram.selection.first().data.rmf_questions)
    ) {
      myDiagram.selection.first().data.rmf_questions = [];
    }

    myDiagram.selection
      .first()
      .data.rmf_questions.push({ "question-rmid": -1 });
    const domId = "#rmf-question-id-question-rmid-" + (item_count + 1);
    jQuery(domId).val(-1);

    default_analyzer_fieldname();

    // default to question type 5:'Short Answer'
    const domID = "select#rmf-question-id-type-" + (item_count + 1);
    jQuery(domID).trigger("change");

  });

  jQuery("#tabstrip").on("change", "select.rmf-question-type", function () {
    const ctype = jQuery(this).val();
    const qid = (this.id).split('-').pop();
    show_hide_form_containers(ctype, qid);
    const len = default_analyzer_fieldlength(ctype);
    // clear previous value  
    const fnid = `#rmf-question-id-fieldlength-${qid}`;
    jQuery(fnid).val(len);
    jQuery("div.choice-container > div.choice-input-container > input.input-control").trigger("keyup"); 
    //if (len > -1) update_analyzer_fieldlength(len, qid);
  });

  // dialog widget event handlers
  jQuery("#form_node_owner").on("changed.bs.select", function (e) {
    const current_option = jQuery(this).val();
    const owner_type = current_option.charAt(current_option.length - 1);
    if (owner_type == "g") {
      jQuery("#form_node_method").prop("disabled", false);
    } else {
      jQuery("#form_node_method").prop("disabled", true);
    }

    jQuery("#form_node_method").selectpicker("val", " ");
    jQuery("#form_node_method").selectpicker("refresh");
  });

  //
  // Edit state: comment out or hide the controls related to overdue action and reminder.
  // These won't make phase 1, as they are so easy to set up in analyzer.
  //

  /*
    jQuery('#form_node_duration').on('change', function (e) {
        var duration_value = jQuery(this).val();
        if (duration_value > 0) {
            ; // TODO enable
        }
    });
    */

  jQuery(document).on("keyup", ".rmf-question-a-choice", function (e) {
    e.preventDefault();

    let full_qid = jQuery(e.target)[0].id;
    //let i = full_qid.lastIndexOf("-") + 1;
    //let qid = full_qid.substring(i);
    let qid = full_qid.split('-').pop();
    let domChoice = "#" + full_qid;
    let currentChoice = jQuery(domChoice).val();
    let domAllChoices = "#rmf-question-id-choices-" + qid;
    let currentAllChoices = jQuery(domAllChoices).val();

    // strip a ',' if last char of currentChoice
    if (currentChoice.charAt(currentChoice.length - 1) == ",") {
      currentChoice = currentChoice.slice(0, -1);
      jQuery(domChoice).val(currentChoice); // update input after ',' removed.
    }

    // check choice is unqiue
    let arr_choices = currentAllChoices.split(",");
    for (let x = 0; x < arr_choices.length; x++) {
      if (arr_choices[x] === currentChoice) return; // TODO msg 'only unqiue choices allowed...'
    }

    // determine if this is the checked or unchecked
    let arrDomChoice = full_qid.split("-");
    let whichChoice = arrDomChoice[arrDomChoice.length - 2];
    let updatedAllChoices = currentChoice + "," + arr_choices[1];
    if (whichChoice == "checked")
      updatedAllChoices = arr_choices[0] + "," + currentChoice;

    jQuery(domAllChoices).val(updatedAllChoices);
  });

  jQuery(document).on(
    "click",
    "#rmf-node-forms-list .list-group-item",
    function (e) {
      e.preventDefault();

      // change selected color
      jQuery("button.list-group-item").removeClass("selected");
      jQuery(this).addClass("selected");

      jQuery("#rmf-node-label").val("");
      jQuery("#rmf-node-description").val("");
      
      process_state_form_ids = this.dataset.value.split("*");
      if (process_state_form_ids && process_state_form_ids.length == 3) {
        ExceptionManagerServer.setCurrentID(this.dataset.value);
        ArbutusVisualEditor.previousFormListSelection = process_state_form_ids[2];
      }
      else if (parseInt(this.dataset.value) > 0) {
        ExceptionManagerServer.setCurrentID(this.dataset.value);
        ArbutusVisualEditor.previousFormListSelection = this.dataset.value;
      } 
      else {
        let value = ArbutusVisualEditor.editRMFormIDs;
        if (value) ExceptionManagerServer.setCurrentID(value);
        else return;
      }

      ExceptionManagerServer.setCurrentCommand("Update");
      ExceptionManagerServer.api_data_ve_details_get("get-a-rmform");
    }
  );

  // save rm form node dialog data to nodes data object.
  jQuery("#veditor_dialog_rmf_node_save_id").click(function () {
    let required_elements = document
      .getElementById("rmf-workflow")
      .querySelectorAll("[required]");

    //required_elements.forEach(function (elem) {
    //  if (jQuery(elem).val().length === 0)
    //    console.log(jQuery(elem).attr("name"));

      // assume that if elem is hidden it is not required.
      //if ( jQuery(elem).is(':hidden') ) {
      //document.getElementById(elem.id).required = false;
      //} else {
      //document.getElementById(elem.id).required = true;
      //}
    //});

    let form_name = jQuery("#rmf-node-label").val();

    // check that form name have a valid value.
    if (form_name.trim().length === 0) {
      display_form_name_error(form_name);
      return;
    }

    // ensure unique form name
    isExistingRmfFormName(form_name);

    function isExistingRmfFormName(form_name) {
      // Like getRmfForms(...), requests all existing saved
      // forms from the hub server, to determine if the form name
      // is already used, as they must be unqiue.
      //
      // It should be noted that we also check the current forms
      // in the workflow diagram, as they may not have been saved yet.
      // this is done first, as if we find a duplicate in the current
      // workflow, we stop and let the user know to use a unique form name
      // so there is no need to invoke the hub server to get all the form
      // names in the system at this stage.
      
      // iterate over all current diagram forms, as they may not have been saved yet.
      // iterate over diagram nodes and if it has a form, make node form panel visible.
      for (let it = myDiagram.nodes; it.next(); ) {
        const n = it.value;   // n is now a Node or a Group (we are not using groups to data...)
        if (n && n.category === "Node") {
          if (!n.isSelected &&
            n.data.hasOwnProperty("rmf_text") &&
            n.data.rmf_text.length > 0 &&
            n.data.hasOwnProperty("rmf_id") &&
            n.data.rmf_id.length > 0) {
            if (n.data.rmf_text == form_name) {
              display_form_name_error(form_name);
              return;   // if found in current diagram, no need to check saved forms
            }
          }
        }
      }
      
      // invoke hub server.
      jQuery.ajax({
        url: "/result_manager/api/data/get-rmforms",
        type: "POST",
        data: {
          search_phrase: JSON.stringify(null),
        },
        cache: false,
        dataType: "json",
        success: function (resp) {
          if (resp.error.length === 0) {
            for (let x = 0; x < resp.forms.length; x++) {
              //     0          1             2         3         4         5           6         7
              // "process_id\process_label\state_id\state_label\form_id\form_label\description\questions"
              const fields = resp.forms[x].split("\t");
              if (fields.length < 6) break;
              const form_label = fields[5]; // form_label is the 5th item in fields.
              const form_id = fields[4];
              if (myDiagram.selection.first().data.rmf_id != form_id && form_label == form_name) {
                display_form_name_error(form_name);
                return;
              }
            }

            // request a id from the arbutus server.
            request_rm_id(
              save_rmf_node_details,
              myDiagram.selection.first(),
              true
            );
          }
        },
        error: function (e) {
          console.log(e.message);
        }
      });

      function save_rmf_node_details(form_rm_id) {
        let previous_command = ExceptionManagerServer.getCurrentCommand();
        let obj = myDiagram.selection.first();
        if (obj && obj.data) {
          myDiagram.startTransaction("saveRmFormNode");

          // extract form data from dialog in place in state node data model
          // TODO - do we still want to keep this client side persisted in the
          // goJS data graphObject, if we do, perhaps strip this from process
          myDiagram.model.setDataProperty(
            obj.data,
            "rmf_text",
            jQuery("#rmf-node-label").val()
          );

          obj.data.rmf_desc = jQuery("#rmf-node-description").val();
          myDiagram.model.setDataProperty(obj.data, "rmf_id", form_rm_id);

          // iterate over questions list
          rmf_questions = [];
          //question_details = {};
          tabstrip.tabGroup.children().each(function (outer_index) {
            // request a id from the arbutus server.
            let question =
              obj.data.rmf_questions === undefined
                ? null
                : obj.data.rmf_questions[outer_index];
            let fake_obj = { data: { id: -1 } };
            if (question)
              fake_obj.data.id =
                obj.data.rmf_questions[outer_index]["question-rmid"];

            // TODO pass the number of question ids you want upfront
            request_rm_id(save_rmform_questions_details, fake_obj, false);

            function save_rmform_questions_details(question_rm_id) {
              question_details = {};
              outer_index++;
              let parent =
                "#tabstrip .k-content#tabstrip-" +
                outer_index +
                ' *[id^="rmf-question-id-"]';
              
              jQuery(parent).each(function (_inner_index, elem) {
                //  0             1               2           3         4         5               6                         7
                // questionid\tcontrol_type\tquestion_text\tcolumns\tchoices\tmandatory_flag\tAnalyzerFieldLength\tAnalyzerFieldName'\0'"
                let pre_key = elem.id.substring("rmf-question-id-".length);
                let end = pre_key.lastIndexOf("-");
                let key = pre_key.substring(0, end);
                let value = jQuery(elem).val();
                if (key === "mandatory") {
                  if (jQuery(elem).prop("checked")) value = "Y";
                  else value = "N";
                }

                if (!ignored_question_id(key)) question_details[key] = value;
              });

              // radio/dropdown extract choices and put in appropiate format for RM server.
              if (question_details['type'] === '1' || question_details['type'] === '2') {
                let ctype = (question_details['type'] === '1' ? 'radio' : 'dropdown');
                // set radio button layout
                if (ctype === 'radio' && isLayoutVertical(outer_index)) {
                  question_details['position-vertical'] = 'on';
                  question_details['position-horizontal'] = 'off'
                }
                else {
                  question_details['position-vertical'] = 'off';
                  question_details['position-horizontal'] = 'on'
                }

                let choice_ctrls = jQuery(
                  `#rmf-question-${ctype}-choices-container-${outer_index} .choices-list input.input-control`);
                let choices_arr = [];
                choice_ctrls.each(function (_, elem) {
                  let value = jQuery(elem).val();
                  if (value.length > 0)
                    choices_arr.push(value);
                });

                question_details['choices'] = choices_arr.join();
              }
              else if (question_details['type'] === '9' )  { // numeric scale - consume min and max.
                let min = jQuery(`#rmf-question-id-numeric-min-${outer_index}`).val();
                let max = jQuery(`#rmf-question-id-numeric-max-${outer_index}`).val();
                if (min.length > 0 && max.length > 0)
                  question_details['choices'] = min + ',' + max;
              }
              else {
                question_details['choices'] = '';
              }

              question_details["question-rmid"] = question_rm_id;
              rmf_questions.push(question_details);
            }

            function isLayoutVertical(question_no) 
            {
              const checked_radiobuttons = jQuery('.radio-button-control:checked');
              for(let i = 0; i < checked_radiobuttons.length; i++) {
                const rid = 'rmf-question-id-position-vertical-' + question_no;
                if (jQuery(checked_radiobuttons)[i].id === rid) return true;
              }

              return false;
            }
          });

          obj.data.rmf_questions = [];
          obj.data.rmf_questions = rmf_questions;

          myDiagram.commitTransaction("saveRmFormNode");

          // call server with the data so it can be persisted on the hub server.
          // handle save of users dialog form data

          let form_data = {
            process_id: jQuery("#process_id").text(),
            form_id: form_rm_id,
            node_id: obj.data.id,
            label: obj.data.rmf_text,
            description: obj.data.rmf_desc,
            questions: obj.data.rmf_questions,
            flow: myDiagram.model.toJson()
          };

          // send data to server
          ExceptionManagerServer.setCurrentCommand(previous_command);
          ExceptionManagerServer.api_data_ve_details("visual-forms", form_data);
        }

        ArbutusVisualEditor.dialogCancelled = false;
        myDiagram.clearSelection();
        myPalette.clearSelection();
        jQuery("#rmFormNodeModal").modal("hide");
      }
    }

    function ignored_question_id(key) {
      // These are additional helper widgets that will utlimately be packed into choices.
      // Also, note that the 'columns' field is not used and set to 0 on hub server side.
      const rmf_ignored_ids = [
        "a-choice",
        "choice-button",
        "a-choice-unchecked",
        "a-choice-checked",
        "choice-button-clear",
        "numeric-min",
        "numeric-max",
      ];

      for (let x = 0; x < rmf_ignored_ids.length; x++) {
        if (rmf_ignored_ids[x] == key) return true;
      }

      return false;
    }

    function display_form_name_error(form_name) {
      let err_msg = "";
      if (form_name.trim().length === 0)
        err_msg = "Please enter a RM Form label.";
      else 
        err_msg = `Please enter a unqiue RM Form label as '${form_name}' is already being used.`;

      jQuery("#errors").html(err_msg);
      jQuery("#messageModal").modal("show");
    }

  });

  // save node dialog data to nodes data object.
  jQuery("#veditor_dialog_node_save_id").click(function () {
    // check that mandatory fields have a value.
    if (jQuery("#form_node_label").val().length === 0) {
      jQuery("#errors").html("Please enter a node label.");
      jQuery("#messageModal").modal("show");
      return;
    }
    if (jQuery("#form_node_owner  option:selected").val().length === 0) {
      jQuery("#errors").html("You must select an Activity Owner, if none are available for selection, please create a Group.");
      jQuery("#messageModal").modal("show");
      return;
    }

    // request a id from the arbutus server.
    request_rm_id(save_node_details, myDiagram.selection.first(), false);

    // helper functions

    function save_node_details(new_rm_id) {
      let obj = myDiagram.selection.first();
      if (obj && obj.data) {
        myDiagram.startTransaction("saveNode");

        // extract form data from dialog in place in state node data model
        myDiagram.model.setDataProperty(
          obj.data,
          "text",
          jQuery("#form_node_label").val()
        );
        myDiagram.model.setKeyForNodeData(obj.data, new_rm_id);
        obj.data.desc = jQuery("#form_node_description").val();
        // This will be either a group or individual
        let selected_value = jQuery("#form_node_owner  option:selected").val();
        obj.data.owner = selected_value.slice(0, selected_value.length - 2); // remove '_u" or '_g" from val.

        // and will be chosen from a list when editing the state.
        // If the owner is a group, this is a 1 char
        // Manual choice=C, next (even)=E, random=R, least busy=L, weighted=W, …
        obj.data.method = jQuery("#form_node_method  option:selected").val();

        // drop down of methods to choose the group member to allocate to.
        if (jQuery("#form_node_return").prop("checked"))
          obj.data.return = "T"; // // This is a checkbox (I used to call it bounce), to indicate if an activity can be
        else 
          obj.data.return = "F"; // // sent back to the previous assignee. If this is true, then we would add a "Return" button
        
        // to the dialog to close/edit an activity.
        
        // Optional time this state is expected to take.
        if (jQuery("#form_node_emergency").prop("checked"))
          obj.data.emergency = "T";
        else 
          obj.data.emergency = "F";

        obj.data.subject = jQuery("#form_node_subject").val();
        obj.data.body = jQuery("#form_node_body").val();

        if (jQuery("#form_node_duration").val().length == 0)
          obj.data.duration = 0;
        else obj.data.duration = jQuery("#form_node_duration").val();

        // Drop down indicating if the duration, days/hours/minutes (value D, H, M).
        obj.data.type = jQuery("#form_node_type option:selected").val();

        /*
          //
          // Edit state: comment out or hide the controls related to overdue action and reminder.
          // These won't make phase 1, as they are so easy to set up in analyzer.
          //

          // Action to be taken if activity is overdue, (R=return to sender, E=email).
          obj.data.overdue = jQuery('#form_node_overdue  option:selected').val();

          // Check box: send a reminder every n days if email.
          if (jQuery("#form_node_reminder").val().length == 0)
            obj.data.reminder = 0;
          else
            obj.data.reminder = jQuery("#form_node_reminder").val();
          */

        // see above. until reinstated just send back defaults to server sides.
        obj.data.overdue = "N";
        obj.data.reminder = 0;

        myDiagram.commitTransaction("saveNode");

        // call server with the data so it can be persisted on the hub server.
        // handle save of users dialog form data
        // TODO, should handle edit as well.
        let form_data = {
          process_id: jQuery("#process_id").text(),
          node_id: obj.data.id,
          label: obj.data.text,
          description: obj.data.desc,
          owner: obj.data.owner,
          method: obj.data.method,
          return: obj.data.return,
          emergency: obj.data.emergency,
          subject: obj.data.subject,
          body: obj.data.body,
          duration: obj.data.duration,
          type: obj.data.type,
          overdue: obj.data.overdue,
          reminder: obj.data.reminder,
          flow: myDiagram.model.toJson()
        };

        // send data to server
        ExceptionManagerServer.api_data_ve_details("visual-states", form_data);
      }

      ArbutusVisualEditor.dialogCancelled = false;
      myDiagram.clearSelection();
      jQuery("#nodeModal").modal("hide");
    }
  });

  // save edge dialog data to edges data object.
  jQuery("#veditor_dialog_edge_save_id").click(function () {
    // check that mandatory fields have a value.
    if (jQuery("#form_edge_label").val().length === 0) {
      jQuery("#errors").html("Please enter an edge label.");
      jQuery("#messageModal").modal("show");
      return;
    }

    // request a id from the arbutus server.
    request_rm_id(save_edge_details, myDiagram.selection.first(), false);

    function save_edge_details(new_rm_id) {
      let obj = myDiagram.selection.first();
      if (obj && obj.data) {
        myDiagram.startTransaction("saveEdge");

        // extract form data from dialog in place in state node data model
        myDiagram.model.setDataProperty(
          obj.data,
          "text",
          jQuery("#form_edge_label").val()
        );
        myDiagram.model.setKeyForLinkData(obj.data, new_rm_id);
        //obj.data.id = rm_id;
        obj.data.desc = jQuery("#form_edge_description").val();
        obj.data.choose = jQuery("input[name='assignee']:checked").val();

        myDiagram.commitTransaction("saveEdge");

        let form_data = {
          action_id: obj.data.id,
          process_id: jQuery("#process_id").text(),
          to: obj.data.to,
          from: obj.data.from,
          label: obj.data.text,
          description: obj.data.desc,
          choose: obj.data.choose,
          flow: myDiagram.model.toJson()
        };

        // send data to server
        ExceptionManagerServer.api_data_ve_details("visual-actions", form_data);
      }

      ArbutusVisualEditor.dialogCancelled = false;
      jQuery("#edgeModal").modal("hide");
    }
  });

  // new form
  jQuery("#rmf-node-forms-list-create").click(function (e) {
    init_rmf_dialog(null, true);
    // clear form name & instructions
    jQuery("#rmf-node-label").val("");
    jQuery("#rmf-node-description").val("");
    //clear_rmf_node_fields(null);
    create_type_dropdown(null);
    // remove any selected forms
    jQuery("button.list-group-item").removeClass("selected");
    ArbutusVisualEditor.previousFormListSelection = null;
  });

  jQuery("#rmf-node-forms-list-search").keyup(function (e) {
    let searchPhrase = jQuery(this).val();
    getRmfForms(searchPhrase);
  });

  //jQuery("#rmf-node-label").keyup(function (e) {
    // only update if NOT editing
  //  if (!ArbutusVisualEditor.editRMFormIDs) default_analyzer_fieldname();
  //});

  jQuery("#rmf-node-label").blur(function(e) {
    if (!ArbutusVisualEditor.editRMFormIDs) default_analyzer_fieldname();  
  });

  function default_analyzer_fieldname()
  {
    let form_name = jQuery("#rmf-node-label").val();
    let fieldname = form_name.trim();
    let tabstrip = jQuery("#tabstrip").data("kendoTabStrip");
    let selectedStrip = tabstrip.select().index() + 1;
    let current_analyzer_field_id= `#rmf-question-id-fieldname-${selectedStrip}`;
    current_analyzer_field = jQuery(current_analyzer_field_id).val();
    if (fieldname.length > 0 && current_analyzer_field.length === 0) {
      fieldname = fieldname.split(' ')[0];    // only use form name label before first space if any.
      fieldname = fieldname.substring(0, 28); // limit to 32 characters., 4 reserved for '__Q2
      fieldname = `${fieldname}__Q${selectedStrip}`
      jQuery(current_analyzer_field_id).val(fieldname);
    }
  }

  // init to ensure correct state page and dialogs
  jQuery("#process_id").hide();
  jQuery("#form_node_owner").selectpicker();
  jQuery("form_node_method").selectpicker();

  
  /// GoJS configuration and handling etc. //////////////////////////////////////////////

  var $ = go.GraphObject.make; // for conciseness in defining templates

  myDiagram = $(
    go.Diagram,
    "myDiagramDiv", // must name or refer to the DIV HTML element
    {
      initialContentAlignment: go.Spot.Center,
      draggingTool: new GuidedDraggingTool(), // defined in GuidedDraggingTool.js
      "draggingTool.horizontalGuidelineColor": "black",
      "draggingTool.verticalGuidelineColor": "black",
      "draggingTool.centerGuidelineColor": "black",
      "draggingTool.guidelineWidth": 1,
      "draggingTool.isGridSnapEnabled": true,
      "grid.visible": true, // display a background grid for the whole diagram
      "grid.gridCellSize": new go.Size(10, 10),
      allowDrop: true, // must be true to accept drops from the Palette
      LinkDrawn: LinkDrawn, // this DiagramEvent listener is defined below
      LinkRelinked: LinkRelinked,
      "animationManager.duration": 800, // slightly longer than default (600ms) animation
      "undoManager.isEnabled": true, // enable undo & redo - disable for now.
      "commandHandler.doKeyDown": function () {}, // disable keypresses in canvas, it messes with hub server comms' etc.
    }
  );

  // the node template

  // To simplify this code we define a function for creating a context menu button:
  function makeButton(text, action, visiblePredicate) {
    return $(
      "ContextMenuButton",
      $(go.TextBlock, text),
      { click: action },
      // don't bother with binding GraphObject.visible if there's no predicate
      visiblePredicate
        ? new go.Binding("visible", "", function (o, e) {
            return o.diagram ? visiblePredicate(o, e) : false;
          }).ofObject()
        : {}
    );
  }

  /*
    var nodeMenu =  // context menu for each Node
        $(go.Adornment, "Vertical",
            //makeButton("Copy",
            //    function (e, obj) {
            //        e.diagram.commandHandler.copySelection();
            //    }),
            makeButton("Edit",
                function (e, obj) {
                    editNode(obj);
                }),
            makeButton("Remove",
                function (e, obj) {
                    e.diagram.commandHandler.deleteSelection();
                }) 
        );
                */

  var nodeSize = new go.Size(84, 84);
  var portSize = new go.Size(8, 8);
  var portSizeTB = new go.Size(12, 10);
  var portSizeLR = new go.Size(10, 12);
  var portMarginLR = new go.Margin(3, 0);
  var portMarginTB = new go.Margin(0, 3);

  // var portMenu =  // context menu for each port
  //     $(go.Adornment, "Vertical",
  //         makeButton("Remove port",
  //             // in the click event handler, the obj.part is the Adornment;
  //             // its adornedObject is the port
  //             function (e, obj) {
  //                 removePort(obj.part.adornedObject);
  //             }),
  //         makeButton("Change color",
  //             function (e, obj) {
  //                 changeColor(obj.part.adornedObject);
  //             }),
  //         makeButton("Remove side ports",
  //             function (e, obj) {
  //                 removeAll(obj.part.adornedObject);
  //             })
  //     );

  function leftPortPanel(
    isFromLinkable,
    isToLinkable,
    isFromLinkableSelfNode,
    isToLinkableSelfNode,
    isFromLinkableDuplicates,
    isToLinkableDuplicates
  ) {
    // the Panel holding the left port elements, which are themselves Panels,
    // created for each item in the itemArray, bound to data.leftArray
    return $(go.Panel, "Vertical", new go.Binding("itemArray", "leftArray"), {
      row: 1,
      column: 0,
      itemTemplate: $(
        go.Panel,
        {
          _side: "left", // internal property to make it easier to tell which side it's on
          fromSpot: go.Spot.Left,
          toSpot: go.Spot.Left,
          fromLinkable: isFromLinkable,
          toLinkable: isToLinkable,
          cursor: "pointer",
          fromLinkableSelfNode: isFromLinkableSelfNode,
          toLinkableSelfNode: isToLinkableSelfNode, // draw a link from a node to itself
          fromLinkableDuplicates: isFromLinkableDuplicates,
          toLinkableDuplicates: isToLinkableDuplicates, // draw a second link between the same pair of nodes in the same direction
          fromMaxLinks: 1,
          toMaxLinks: 1,
          //contextMenu: portMenu
        },
        new go.Binding("portId", "portId"),
        $(go.Shape, "Circle", {
          stroke: null,
          strokeWidth: 0,
          desiredSize: portSizeLR,
          margin: portMarginLR,
          fill: "transparent",
          mouseEnter: mouseEnter,
          mouseLeave: mouseLeave,
        }) //,
        //new go.Binding("fill", "portColor"))
      ), // end itemTemplate
    }); // end Vertical Panel
  }

  function topPortPanel(
    isFromLinkable,
    isToLinkable,
    isFromLinkableSelfNode,
    isToLinkableSelfNode,
    isFromLinkableDuplicates,
    isToLinkableDuplicates
  ) {
    // the Panel holding the top port elements, which are themselves Panels,
    // created for each item in the itemArray, bound to data.topArray
    return $(go.Panel, "Horizontal", new go.Binding("itemArray", "topArray"), {
      row: 0,
      column: 1,
      itemTemplate: $(
        go.Panel,
        {
          _side: "top",
          fromSpot: go.Spot.Top,
          toSpot: go.Spot.Top,
          fromLinkable: isFromLinkable,
          toLinkable: isToLinkable,
          cursor: "pointer",
          fromLinkableSelfNode: isFromLinkableSelfNode,
          toLinkableSelfNode: isToLinkableSelfNode, // draw a link from a node to itself
          fromLinkableDuplicates: isFromLinkableDuplicates,
          toLinkableDuplicates: isToLinkableDuplicates, // draw a second link between the same pair of nodes in the same direction
          fromMaxLinks: 1,
          toMaxLinks: 1,
          //contextMenu: portMenu
        },
        new go.Binding("portId", "portId"),
        $(go.Shape, "Circle", {
          stroke: null,
          strokeWidth: 0,
          desiredSize: portSizeTB,
          margin: portMarginTB,
          fill: "transparent",
          mouseEnter: mouseEnter,
          mouseLeave: mouseLeave,
        }) //,
        //new go.Binding("fill", "portColor"))
      ), // end itemTemplate
    }); // end Horizontal Panel
  }

  function rightPortPanel(
    isFromLinkable,
    isToLinkable,
    isFromLinkableSelfNode,
    isToLinkableSelfNode,
    isFromLinkableDuplicates,
    isToLinkableDuplicates
  ) {
    // the Panel holding the right port elements, which are themselves Panels,
    // created for each item in the itemArray, bound to data.rightArray
    return $(go.Panel, "Vertical", new go.Binding("itemArray", "rightArray"), {
      row: 1,
      column: 2,
      itemTemplate: $(
        go.Panel,
        {
          _side: "right",
          fromSpot: go.Spot.Right,
          toSpot: go.Spot.Right,
          fromLinkable: isFromLinkable,
          toLinkable: isToLinkable,
          cursor: "pointer",
          fromLinkableSelfNode: isFromLinkableSelfNode,
          toLinkableSelfNode: isToLinkableSelfNode, // draw a link from a node to itself
          fromLinkableDuplicates: isFromLinkableDuplicates,
          toLinkableDuplicates: isToLinkableDuplicates, // draw a second link between the same pair of nodes in the same direction
          fromMaxLinks: 1,
          toMaxLinks: 1,
          //contextMenu: portMenu
        },
        new go.Binding("portId", "portId"),
        $(go.Shape, "Circle", {
          stroke: null,
          strokeWidth: 0,
          desiredSize: portSizeLR,
          margin: portMarginLR,
          fill: "transparent",
          mouseEnter: mouseEnter,
          mouseLeave: mouseLeave,
        }) //,
        //new go.Binding("fill", "portColor"))
      ), // end itemTemplate
    }); // end Vertical Panel
  }

  function bottomPortPanel(
    isFromLinkable,
    isToLinkable,
    isFromLinkableSelfNode,
    isToLinkableSelfNode,
    isFromLinkableDuplicates,
    isToLinkableDuplicates
  ) {
    // the Panel holding the bottom port elements, which are themselves Panels,
    // created for each item in the itemArray, bound to data.bottomArray
    return $(
      go.Panel,
      "Horizontal",
      new go.Binding("itemArray", "bottomArray"),
      {
        row: 2,
        column: 1,
        itemTemplate: $(
          go.Panel,
          {
            _side: "bottom",
            fromSpot: go.Spot.Bottom,
            toSpot: go.Spot.Bottom,
            fromLinkable: isFromLinkable,
            toLinkable: isToLinkable,
            cursor: "pointer",
            fromLinkableSelfNode: isFromLinkableSelfNode,
            toLinkableSelfNode: isToLinkableSelfNode, // draw a link from a node to itself
            fromLinkableDuplicates: isFromLinkableDuplicates,
            toLinkableDuplicates: isToLinkableDuplicates, // draw a second link between the same pair of nodes in the same direction
            fromMaxLinks: 1,
            toMaxLinks: 1,
            // contextMenu: portMenu
          },
          new go.Binding("portId", "portId"),
          $(go.Shape, "Circle", {
            stroke: null,
            strokeWidth: 0,
            desiredSize: portSizeTB,
            margin: portMarginTB,
            fill: "transparent",
            mouseEnter: mouseEnter,
            mouseLeave: mouseLeave,
          }) //,
          //new go.Binding("fill", "portColor"))
        ), // end itemTemplate
      }
    ); // end Horizontal Panel
  }

  function mouseEnter(e, obj) {
    //console.log("Node mouseEnter");
    obj.fill = "#003068";
  }

  function mouseLeave(e, obj) {
    //console.log("Node mouseLeave");
    obj.fill = "transparent";
  }

  function portMouseOverZoneEnter(e, obj) {
    obj.panel.findObject("leftPorts").itemArray.forEach(function (element) {
      myDiagram.model.setDataProperty(element, "portColor", "darkgrey");
    });
  }

  /*
    function doFormOnNode(node, pt, gridpt)
    {
      //if (!(node.diagram instanceof go.Palette)) return gridpt;
        // this assumes each node is fully rectangular
        var bnds = node.actualBounds;
        var loc = node.location;

        // use PT instead of GRIDPT if you want to ignore any grid snapping behavior
        // see if the area at the proposed location is unoccupied
        var r = new go.Rect(gridpt.x - (loc.x - bnds.x), gridpt.y - (loc.y - bnds.y), bnds.width, bnds.height);
        // maybe inflate R if you want some space between the node and any other nodes
        r.inflate(-0.5, -0.5);  // by default, deflate to avoid edge overlaps with "exact" fits
    }
    */

  myDiagram.nodeTemplateMap.add(
    "RMForm",
    $(
      go.Node,
      "Table",
      //{ dragComputation: doFormOnNode },
      {
        locationObjectName: "BODY",
        locationSpot: go.Spot.Center,
        selectionObjectName: "BODY",
      },
      new go.Binding("location", "loc", go.Point.parse).makeTwoWay(
        go.Point.stringify
      ),

      // the body
      $(
        go.Panel,
        "Auto",
        {
          row: 1,
          column: 1,
          name: "BODY",
          stretch: go.GraphObject.Fill,
        },
        $(go.Shape, "RoundedRectangle", {
          fill: "#a1f6ec",
          stroke: "#599888",
          strokeWidth: 2,
          minSize: nodeSize,
          maxSize: nodeSize,
        }),
        $(
          go.TextBlock,
          {
            //margin: 10,
            textAlign: "center",
            font: "bold 11px Roboto",
            stroke: "#599888",
            editable: false,
          },
          new go.Binding("text", "rmf_text").makeTwoWay()
        )
      ), // end Auto Panel body
      // includes a panel on each side with an itemArray of panels containing ports
      leftPortPanel(true, false, false, false, false, false),
      topPortPanel(true, false, false, false, false, false),
      rightPortPanel(true, false, false, false, false, false),
      bottomPortPanel(true, false, false, false, false, false)
    )
  );

  myDiagram.nodeTemplateMap.add(
    "Start",
    $(
      go.Node,
      "Table",
      {
        locationObjectName: "BODY",
        locationSpot: go.Spot.Center,
        selectionObjectName: "BODY",
      },
      new go.Binding("location", "loc", go.Point.parse).makeTwoWay(
        go.Point.stringify
      ),

      // the body
      $(
        go.Panel,
        "Auto",
        {
          row: 1,
          column: 1,
          name: "BODY",
          stretch: go.GraphObject.Fill,
        },
        $(go.Shape, "RoundedRectangle", {
          fill: "#d1f6ec",
          stroke: "#599888",
          strokeWidth: 2,
          minSize: nodeSize,
          maxSize: nodeSize,
        }),
        $(
          go.TextBlock,
          {
            //margin: 10,
            textAlign: "center",
            font: "bold 21px Roboto",
            stroke: "#599888",
            editable: false,
          },
          new go.Binding("text", "text").makeTwoWay()
        )
      ), // end Auto Panel body
      // includes a panel on each side with an itemArray of panels containing ports
      leftPortPanel(true, false, false, false, false, false),
      topPortPanel(true, false, false, false, false, false),
      rightPortPanel(true, false, false, false, false, false),
      bottomPortPanel(true, false, false, false, false, false)
    )
  );

  myDiagram.nodeTemplateMap.add(
    "Close",
    $(
      go.Node,
      "Table",
      {
        locationObjectName: "BODY",
        locationSpot: go.Spot.Center,
        selectionObjectName: "BODY",
      },
      new go.Binding("location", "loc", go.Point.parse).makeTwoWay(
        go.Point.stringify
      ),
      // the body
      $(
        go.Panel,
        "Auto",
        {
          width: nodeSize,
          height: nodeSize,
          row: 1,
          column: 1,
          name: "BODY",
          stretch: go.GraphObject.Fill,
        },
        $(go.Shape, "RoundedRectangle", {
          fill: "#f5ecff",
          stroke: "#9c69d2",
          strokeWidth: 2,
          minSize: nodeSize,
          maxSize: nodeSize,
        }),
        $(
          go.TextBlock,
          {
            //margin: 10,
            textAlign: "center",
            font: "bold 21px Roboto",
            stroke: "#9c69d2",
            editable: false,
          },
          new go.Binding("text", "text").makeTwoWay()
        )
      ), // end Auto Panel body
      // includes a panel on each side with an itemArray of panels containing ports
      leftPortPanel(false, true, false, false, false, false),
      topPortPanel(false, true, false, false, false, false),
      rightPortPanel(false, true, false, false, false, false),
      bottomPortPanel(false, true, false, false, false, false)
    )
  );

  // the node template

  // includes a panel on each side with an itemArray of panels containing ports
  myDiagram.nodeTemplateMap.add(
    "Node",
    $(
      go.Node,
      "Table",
      {
        locationObjectName: "BODY",
        locationSpot: go.Spot.Center,
        selectionObjectName: "BODY",
        //selectionChanged: function (a, b, c) {
        //  console.log("selectionChanged")
        //}
      },
      new go.Binding("location", "loc", go.Point.parse).makeTwoWay(
        go.Point.stringify
      ),
      {
        selectionAdornmentTemplate: $(
          go.Adornment,
          "Spot",
          {
            name: "foo",
          },
          $(
            go.Panel,
            "Auto",
            // this Adornment has a rectangular blue Shape around the selected node
            $(go.Shape, { fill: null, stroke: "dodgerblue", strokeWidth: 3 }),
            $(go.Placeholder)
          ),
          // and this Adornment has a Button to the top right of the selected node
          // needed so that the ActionTool intercepts mouse events
          go.GraphObject.make(
            go.Panel,
            "Auto",
            {
              isActionable: true,
              alignment: new go.Spot(1.2, 0, 0, -15),
              margin: 0,
              toolTip: $(
                "ToolTip",
                $(go.TextBlock, { margin: 6, text: "Edit Activity" })
              ),
              click: editNode,
              mouseEnter: function (e, obj, prev) {
                let shape = obj.findObject("edit-node");
                shape.stroke = "darkgrey";
                shape.fill = "lightgrey";
              },
              mouseLeave: function (e, obj, prev) {
                let shape = obj.findObject("edit-node");
                shape.fill = null;
                shape.stroke = null;
              },
            },
            $(go.Shape, {
              figure: "RoundedRectangle",
              fill: null,
              stroke: null,
              width: 16,
              height: 15,
              name: "edit-node",
            }),
            $(go.Picture, { source: "/static/result_manager/edit-node.svg" })
          ),
          go.GraphObject.make(
            go.Panel,
            "Auto",
            {
              isActionable: true,
              alignment: new go.Spot(0.95, 0, 0, -15),
              margin: 0,
              toolTip: $(
                "ToolTip",
                $(go.TextBlock, { margin: 6, text: "Remove Activity" })
              ),
              click: removeObject,
              mouseEnter: function (e, obj, prev) {
                let shape = obj.findObject("remove-node");
                shape.stroke = "darkgrey";
                shape.fill = "lightgrey";
              },
              mouseLeave: function (e, obj, prev) {
                let shape = obj.findObject("remove-node");
                shape.fill = null;
                shape.stroke = null;
              },
            },
            $(go.Shape, {
              figure: "RoundedRectangle",
              fill: null,
              stroke: null,
              width: 16,
              height: 15,
              name: "remove-node",
            }),
            $(go.Picture, {
              source: "/static/result_manager/remove-node.svg",
            })
          ),
          // and this Adornment has a Button to the bottom right of the selected node
          // needed so that the ActionTool intercepts mouse events and do edit/remove rmform.
          go.GraphObject.make(
            go.Panel,
            "Auto",
            {
              isActionable: true,
              alignment: new go.Spot(-0.2, 1, 0, 15),
              margin: 0,
              toolTip: $(
                "ToolTip",
                $(go.TextBlock, { margin: 6, text: "Edit Form" })
              ),
              click: editNodeRMForm,
              mouseEnter: function (e, obj, prev) {
                let shape = obj.findObject("edit-form");
                shape.stroke = "darkgrey";
                shape.fill = "lightgrey";
              },
              mouseLeave: function (e, obj, prev) {
                let shape = obj.findObject("edit-form");
                shape.fill = null;
                shape.stroke = null;
              },
            },
            $(go.Shape, {
              figure: "RoundedRectangle",
              fill: null,
              stroke: null,
              width: 16,
              height: 15,
              name: "edit-form",
            }),
            $(
              go.Picture,
              {
                source: "/static/result_manager/edit-node.svg",
                visible: false,
              },
              new go.Binding("visible", "rmf_id", function (x) {
                return x ? true : false;
              })
            )
          ),
          go.GraphObject.make(
            go.Panel,
            "Auto",
            {
              isActionable: true,
              alignment: new go.Spot(0.05, 1, 0, 15),
              margin: 0,
              toolTip: $(
                "ToolTip",
                $(go.TextBlock, { margin: 6, text: "Remove Form" })
              ),
              click: removeNodeRMForm,
              mouseEnter: function (e, obj, prev) {
                let shape = obj.findObject("remove-form");
                shape.stroke = "darkgrey";
                shape.fill = "lightgrey";
              },
              mouseLeave: function (e, obj, prev) {
                let shape = obj.findObject("remove-form");
                shape.fill = null;
                shape.stroke = null;
              },
            },
            $(go.Shape, {
              figure: "RoundedRectangle",
              fill: null,
              stroke: null,
              width: 16,
              height: 15,
              name: "remove-form",
            }),
            $(
              go.Picture,
              {
                source: "/static/result_manager/remove-node.svg",
                visible: false,
              },
              new go.Binding("visible", "rmf_id", function (x) {
                return x ? true : false;
              })
            )
          ),
          new go.Binding("visible", "diagram", function (d) {
            return !(d instanceof go.Palette);
          }).ofObject()
        ), // end Adornment
      },

      // the body
      $(
        go.Panel,
        "Auto",
        {
          row: 2,
          column: 2,
          name: "BODY",
          stretch: go.GraphObject.Fill,
          mouseEnter: function (e, obj) {
            obj.panel
              .findObject("leftPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "darkgrey"
                );
              });
            obj.panel
              .findObject("topPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "darkgrey"
                );
              });
            obj.panel
              .findObject("rightPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "darkgrey"
                );
              });
            obj.panel
              .findObject("bottomPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "darkgrey"
                );
              });
          },
          mouseLeave: function (e, obj) {
            obj.panel
              .findObject("leftPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "transparent"
                );
              });
            obj.panel
              .findObject("topPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "transparent"
                );
              });
            obj.panel
              .findObject("rightPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "transparent"
                );
              });
            obj.panel
              .findObject("bottomPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "transparent"
                );
              });
          },
        },
        $(go.Shape, "RoundedRectangle", {
          fill: "#e4f3ff",
          stroke: "#1d70a2",
          strokeWidth: 2,
          minSize: nodeSize,
          maxSize: nodeSize,
        }),
        $(
          go.Panel,
          "Horizontal",
          {
            name: "attached-rmf",
            visible: false,
          },
          $(go.Shape, "RoundedRectangle", {
            fill: "#a1f6ec",
            width: 50,
            height: 50,
          })
        ),
        /*
          $(go.Shape, "Rectangle",
            {
              fill: "#dbf6cb", stroke: null, strokeWidth: 0,
              minSize: new go.Size(60, 60)
            }),
          */
        $(
          go.TextBlock,
          {
            //margin: 10,
            textAlign: "center",
            font: "bold 11px Roboto",
            stroke: "#1d70a2",
            editable: false,
          },
          new go.Binding("text", "text").makeTwoWay()
        )
      ), // end Auto Panel body

      // Panel to the left of the left port Panel to capture mouseover events
      // which in turn show/hide the left panel ports.
      $(
        go.Panel,
        "Vertical",
        {
          row: 2,
          column: 0,
          stretch: go.GraphObject.Fill,
          mouseEnter: function (e, obj) {
            obj.panel
              .findObject("leftPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "darkgrey"
                );
              });
          },
          mouseLeave: function (e, obj) {
            obj.panel
              .findObject("leftPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "transparent"
                );
              });
          },
        },
        $(go.Shape, "Rectangle", {
          fill: "transparent",
          stroke: null,
          desiredSize: new go.Size(34, 84),
        })
      ), // end Auto Panel body

      // the Panel holding the top port elements, which are themselves Panels,
      // created for each item in the itemArray, bound to data.topArray
      $(go.Panel, "Vertical", new go.Binding("itemArray", "leftArray"), {
        row: 2,
        column: 1,
        name: "leftPorts",
        mouseEnter: function (e, obj) {
          obj.panel
            .findObject("leftPorts")
            .itemArray.forEach(function (element) {
              myDiagram.model.setDataProperty(element, "portColor", "darkgrey");
            });
        },
        mouseLeave: function (e, obj) {
          obj.panel
            .findObject("leftPorts")
            .itemArray.forEach(function (element) {
              myDiagram.model.setDataProperty(
                element,
                "portColor",
                "transparent"
              );
            });
        },
        itemTemplate: $(
          go.Panel,
          {
            _side: "left", // internal property to make it easier to tell which side it's on
            fromSpot: go.Spot.Left,
            toSpot: go.Spot.Left,
            fromLinkable: true,
            toLinkable: true,
            cursor: "pointer",
          },
          new go.Binding("portId", "portId"),
          $(
            go.Shape,
            "Rectangle",
            {
              stroke: null,
              strokeWidth: 0,
              fill: "transparent",
              desiredSize: portSize,
              // (t?: number, r?: number, b?: number, l?: number)
              margin: new go.Margin(1, 0, 1, 0),
            },
            new go.Binding("fill", "portColor")
          )
        ), // end itemTemplate
      }), // end Vertical Panel

      // Panel to the top of the top port Panel to capture mouseover events
      // which in turn show/hide the top panel ports.
      $(
        go.Panel,
        "Horizontal",
        {
          row: 0,
          column: 2,
          stretch: go.GraphObject.Fill,
          mouseEnter: function (e, obj) {
            obj.panel
              .findObject("topPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "darkgrey"
                );
              });
          },
          mouseLeave: function (e, obj) {
            obj.panel
              .findObject("topPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "transparent"
                );
              });
          },
        },
        $(go.Shape, "Rectangle", {
          fill: "transparent",
          stroke: null,
          strokeWidth: 0,
          desiredSize: new go.Size(84, 34),
        })
      ), // end Auto Panel body

      // the Panel holding the top port elements, which are themselves Panels,
      // created for each item in the itemArray, bound to data.topArray
      $(go.Panel, "Horizontal", new go.Binding("itemArray", "topArray"), {
        row: 1,
        column: 2,
        name: "topPorts",
        mouseEnter: function (e, obj) {
          obj.panel
            .findObject("topPorts")
            .itemArray.forEach(function (element) {
              myDiagram.model.setDataProperty(element, "portColor", "darkgrey");
            });
        },
        mouseLeave: function (e, obj) {
          obj.panel
            .findObject("topPorts")
            .itemArray.forEach(function (element) {
              myDiagram.model.setDataProperty(
                element,
                "portColor",
                "transparent"
              );
            });
        },
        itemTemplate: $(
          go.Panel,
          {
            _side: "top",
            fromSpot: go.Spot.Top,
            toSpot: go.Spot.Top,
            fromLinkable: true,
            toLinkable: true,
            cursor: "pointer",
          },
          new go.Binding("portId", "portId"),
          $(
            go.Shape,
            "Rectangle",
            {
              stroke: null,
              strokeWidth: 0,
              fill: "transparent",
              desiredSize: portSize,
              // (t?: number, r?: number, b?: number, l?: number)
              margin: new go.Margin(0, 1, 0, 1),
            },
            new go.Binding("fill", "portColor")
          )
        ), // end itemTemplate
      }), // end Horizontal Panel

      // Panel to the right of the right port Panel to capture mouseover events
      // which in turn show/hide the right panel ports.
      $(
        go.Panel,
        "Vertical",
        {
          row: 2,
          column: 4,
          stretch: go.GraphObject.Fill,
          mouseEnter: function (e, obj) {
            obj.panel
              .findObject("rightPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "darkgrey"
                );
              });
          },
          mouseLeave: function (e, obj) {
            obj.panel
              .findObject("rightPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "transparent"
                );
              });
          },
        },
        $(go.Shape, "Rectangle", {
          fill: "transparent",
          stroke: null,
          strokeWidth: 0,
          desiredSize: new go.Size(34, 84),
        })
      ), // end Auto Panel body

      // the Panel holding the right port elements, which are themselves Panels,
      // created for each item in the itemArray, bound to data.rightArray
      $(go.Panel, "Vertical", new go.Binding("itemArray", "rightArray"), {
        row: 2,
        column: 3,
        name: "rightPorts",
        mouseEnter: function (e, obj) {
          obj.panel
            .findObject("rightPorts")
            .itemArray.forEach(function (element) {
              myDiagram.model.setDataProperty(element, "portColor", "darkgrey");
            });
        },
        mouseLeave: function (e, obj) {
          obj.panel
            .findObject("rightPorts")
            .itemArray.forEach(function (element) {
              myDiagram.model.setDataProperty(
                element,
                "portColor",
                "transparent"
              );
            });
        },
        itemTemplate: $(
          go.Panel,
          {
            _side: "right",
            fromSpot: go.Spot.Right,
            toSpot: go.Spot.Right,
            fromLinkable: true,
            toLinkable: true,
            cursor: "pointer",
          },
          new go.Binding("portId", "portId"),
          $(
            go.Shape,
            "Rectangle",
            {
              fill: "transparent",
              stroke: null,
              strokeWidth: 0,
              desiredSize: portSize,
              // (t?: number, r?: number, b?: number, l?: number)
              margin: new go.Margin(1, 0, 1, 0),
            },
            new go.Binding("fill", "portColor")
          )
        ), // end itemTemplate
      }), // end Vertical Panel

      // Panel to the bottom of the bottom port Panel to capture mouseover events
      // which in turn show/hide the bottom panel ports.
      $(
        go.Panel,
        "Horizontal",
        {
          row: 4,
          column: 2,
          stretch: go.GraphObject.Fill,
          mouseEnter: function (e, obj) {
            obj.panel
              .findObject("bottomPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "darkgrey"
                );
              });
          },
          mouseLeave: function (e, obj) {
            obj.panel
              .findObject("bottomPorts")
              .itemArray.forEach(function (element) {
                myDiagram.model.setDataProperty(
                  element,
                  "portColor",
                  "transparent"
                );
              });
          },
        },
        $(go.Shape, "Rectangle", {
          fill: "transparent",
          stroke: null,
          strokeWidth: 0,
          desiredSize: new go.Size(84, 34),
        })
      ), // end Auto Panel body

      // the Panel holding the bottom port elements, which are themselves Panels,
      // created for each item in the itemArray, bound to data.bottomArray
      $(go.Panel, "Horizontal", new go.Binding("itemArray", "bottomArray"), {
        row: 3,
        column: 2,
        name: "bottomPorts",
        mouseEnter: function (e, obj) {
          obj.panel
            .findObject("bottomPorts")
            .itemArray.forEach(function (element) {
              myDiagram.model.setDataProperty(element, "portColor", "darkgrey");
            });
        },
        mouseLeave: function (e, obj) {
          obj.panel
            .findObject("bottomPorts")
            .itemArray.forEach(function (element) {
              myDiagram.model.setDataProperty(
                element,
                "portColor",
                "transparent"
              );
            });
        },
        itemTemplate: $(
          go.Panel,
          {
            _side: "bottom",
            fromSpot: go.Spot.Bottom,
            toSpot: go.Spot.Bottom,
            fromLinkable: true,
            toLinkable: true,
            cursor: "pointer",
          },
          new go.Binding("portId", "portId"),
          $(
            go.Shape,
            "Rectangle",
            {
              fill: "transparent",
              stroke: null,
              strokeWidth: 0,
              desiredSize: portSize,
              // (t?: number, r?: number, b?: number, l?: number)
              margin: new go.Margin(0, 1, 0, 1),
            },
            new go.Binding("fill", "portColor")
          )
        ), // end itemTemplate
      }) // end Horizontal Panel
    )
  ); // end Node

  // callback for toggle button to turn go.js diagram canvas grid

  jQuery("#toggle-grid").change(function () {
    myDiagram.grid.visible = jQuery(this).prop("checked");
  });

  jQuery("#toggle-palette").change(function () {
    if (jQuery(this).prop("checked")) jQuery("#paletteDraggable").show();
    else jQuery("#paletteDraggable").hide();
  });

  /// Link stuff ////////////////////////////////////////////////////////////////////
  
  // an orthogonal link template, reshapable and relinkable
  myDiagram.linkTemplate = $(
    go.Link /*CustomLink*/, // defined below
    {
      routing: go.Link.AvoidsNodes,
      corner: 4,
      curve: go.Link.JumpGap,
      reshapable: true,
      resegmentable: true,
      relinkableFrom: true,
      relinkableTo: true,
      relinkableTo: true,
      selectionChanged: function (part) {
        let shape = part.findObject("link-label");
        if (part.isSelected) {
          shape.stroke = "darkgrey";
          // #e4f3ff - 228, 243, 255
          shape.fill = "#e4f3ff"; //'lightgrey';
        } else {
          shape.fill = $(go.Brush, "Radial", {
            0: "rgb(240, 240, 240)",
            0.3: "rgb(240, 240, 240)",
            1: "rgba(240, 240, 240, 0)",
          });
          shape.stroke = null;
        }
      },
    },
    new go.Binding("points").makeTwoWay(),
    $(go.Shape, { stroke: "#1d70a2", strokeWidth: 2 }),
    $(go.Shape, { toArrow: "OpenTriangle", strokeWidth: 1, stroke: "#1d70a2" }),
    $(
      go.Panel,
      "Auto",
      {
        segmentOffset: new go.Point(0, -9),
        padding: 10,
      },
      $(
        go.Shape, // the label background, which becomes transparent around the edges
        {
          name: "link-label",
          fill: $(go.Brush, "Radial", {
            0: "rgb(240, 240, 240)",
            0.3: "rgb(240, 240, 240)",
            1: "rgba(240, 240, 240, 0)",
          }),
          stroke: null,
        }
      ),
      $(
        go.TextBlock,
        " ", // the label text
        {
          textAlign: "center",
          font: "bold 11px Roboto",
          stroke: "#1d70a2",
          margin: 1,
          //editable: true  // editing the text automatically updates the model data
        },
        new go.Binding("text", "text")
      )
    ),
    {
      selectionAdornmentTemplate: $(
        go.Adornment,
        "Spot",
        $(
          go.Panel,
          "Auto",
          {
            segmentOffset: new go.Point(5, -20),
          },
          $(
            go.Panel,
            "Table",
            $(
              go.Panel,
              "Auto",
              {
                isActionable: true,
                row: 0,
                column: 0,
                margin: new go.Margin(0, 0, 10, 0),
                toolTip: $(
                  "ToolTip",
                  $(go.TextBlock, { margin: 6, text: "Edit result option" })
                ),
                click: editLink,
                mouseEnter: function (e, obj, prev) {
                  let shape = obj.findObject("edit-link");
                  shape.stroke = "darkgrey";
                  shape.fill = "lightgrey";
                },
                mouseLeave: function (e, obj, prev) {
                  let shape = obj.findObject("edit-link");
                  shape.fill = null;
                  shape.stroke = null;
                },
              },
              $(go.Shape, {
                figure: "RoundedRectangle",
                fill: null,
                stroke: null,
                width: 16,
                height: 15,
                name: "edit-link",
              }),
              $(go.Picture, {
                source: "/static/result_manager/edit-node.svg",
              }) // TODO
            ),
            $(
              go.Panel,
              "Auto",
              {
                isActionable: true,
                row: 0,
                column: 1,
                margin: new go.Margin(0, 0, 10, 0),
                toolTip: $(
                  "ToolTip",
                  $(go.TextBlock, { margin: 6, text: "Remove result option" })
                ),
                click: removeObject,
                mouseEnter: function (e, obj, prev) {
                  let shape = obj.findObject("remove-link");
                  shape.stroke = "darkgrey";
                  shape.fill = "lightgrey";
                },
                mouseLeave: function (e, obj, prev) {
                  let shape = obj.findObject("remove-link");
                  shape.fill = null;
                  shape.stroke = null;
                },
              },
              $(go.Shape, {
                figure: "RoundedRectangle",
                fill: null,
                stroke: null,
                width: 16,
                height: 15,
                name: "remove-link",
              }),
              $(go.Picture, {
                source: "/static/result_manager/remove-node.svg",
              }) // TODO
            )
          )
        )
      ),
    }
  );

  myDiagram.toolManager.linkingTool.temporaryLink.routing = go.Link.Orthogonal;
  myDiagram.toolManager.relinkingTool.temporaryLink.routing = go.Link.Orthogonal;
  myDiagram.toolManager.hoverDelay = 500;

  function LinkDrawn(e) {
    // link from 'Start' node does not require name or description
    if (e.subject.fromNode.data.text === "Start") return;

    ArbutusVisualEditor.isVisualEdit = false;
    showDialog("edge");
  }

  function LinkRelinked(e) {}

  /// Palette stuff //////////////////////////////////////////////////////////////

  // initialize the Palette that is on the left side of the page
  var myGraphLinksModel = new go.GraphLinksModel();
  (myGraphLinksModel.copiesArrays = true),
    (myGraphLinksModel.copiesArrayObjects = true),
    (myGraphLinksModel.nodeKeyProperty = "id");
  myGraphLinksModel.linkKeyProperty = "id";
  myGraphLinksModel.linkCategoryProperty = "Link";
  (myGraphLinksModel.linkFromPortIdProperty = "fromPort"),
    (myGraphLinksModel.linkToPortIdProperty = "toPort"),
    (myGraphLinksModel.nodeDataArray = [
      {
        category: "Node",
        text: "Activity",
        leftArray: [],
        rightArray: [],
        topArray: [],
        bottomArray: [],
      },
      {
        category: "RMForm",
        rmf_text: "Form",
      },
    ]);

  var myPalette = $(
    go.Palette,
    "myPaletteDiv", // must name or refer to the DIV HTML element
    {
      "animationManager.duration": 800, // slightly longer than default (600ms) animation
      initialScale: 0.8,
      nodeTemplateMap: myDiagram.nodeTemplateMap, // share the templates used by myDiagram
      // specify the contents of the Palette
      model: myGraphLinksModel,
    }
  );

  myPalette.addDiagramListener(
    "InitialLayoutCompleted",
    function (diagramEvent) {
      let pdrag = document.getElementById("paletteDraggable");
      let palette = diagramEvent.diagram;
      pdrag.style.width = palette.documentBounds.width + 28 + "px"; // account for padding/borders
      pdrag.style.height = palette.documentBounds.height + 58 + "px";
    }
  );

  myPalette.addDiagramListener("ObjectSingleClicked", function (diagramEvent) {
    let palette = diagramEvent.diagram;
    // do not use selectionAdornmentTemplate on palette node.
    for (let it = palette.nodes; it.next(); ) {
      let n = it.value; // n is now a Node or a Group
      n.selectionAdornmentTemplate = null;
    }
  });

  jQuery("#paletteDraggable")
    .draggable({ handle: "#paletteDraggableHandle" })
    .resizable({
      // After resizing, perform another layout to fit everything in the palette's viewport
      stop: function () {
        myPalette.layoutDiagram(true);
      },
    });

  // The following code overrides GoJS focus to stop the browser from scrolling
  // the page when either the Diagram or Palette are clicked or dragged onto.
  function customFocus() {
    const x = window.scrollX || window.pageXOffset;
    const y = window.scrollY || window.pageYOffset;
    go.Diagram.prototype.doFocus.call(this);
    window.scrollTo(x, y);
  }

  myDiagram.doFocus = customFocus;
  myPalette.doFocus = customFocus;

  // GoJS diagram event handlers ///////////////////////////////////////////////

  // event handler when palette object dropped on diagram
  myDiagram.addDiagramListener("ExternalObjectsDropped", function (e) {
    myDiagram.toolManager.draggingTool.clearGuidelines();

    // check if special form node.
    if (isFormNode(e)) {
      let currentFormNode = null;
      let currentNode = null;
      myDiagram.selection.each((n) => {
        if (n.category === "RMForm") {
          let baseNode = isFormOverlappingNode(n);
          if (baseNode) {
            currentNode = baseNode;
            currentFormNode = n;
          } else {
            currentFormNode = n;
          }
        }
      });

      if (currentFormNode) {
        myDiagram.remove(currentFormNode);
      }

      if (currentNode) manageNodeWithForm(currentNode);
    } else {
      // 'action' node
      addDefaultPorts();
      ArbutusVisualEditor.isVisualEdit = false;
      // TODO force correct status of node method based on status of node owner
      jQuery("#form_node_owner").change();

      remove_user_owner();

      // disable if first user created node.
      if (myDiagram.nodes.count === 3)
        jQuery("#form_node_return").attr("disabled", true);
      else jQuery("#form_node_return").removeAttr("disabled");

      showDialog("node");
    }
  });

  function addDefaultPorts() {
    const sides = ["top", "left", "right", "bottom"];
    jQuery.each(sides, function (idx, value) {
      let totalEdgeCount = 5;
      if (value == "top" || value == "bottom") totalEdgeCount = 5;
      for (let edgeCount = 0; edgeCount < totalEdgeCount; edgeCount++)
        addPort(value);
    });
  }

  function isFormNode(e) {
    let result = false;

    // are we a 'Form' node?
    myDiagram.selection.each((n) => {
      if (n.category === "RMForm") result = true;
    });

    return result;
  }

  function isFormOverlappingNode(node) {
    // this assumes each node is fully rectangular
    let bnds = node.actualBounds;
    // use PT instead of GRIDPT if you want to ignore any grid snapping behavior
    // see if the area at the proposed location is unoccupied
    let r = new go.Rect(bnds.x, bnds.y, bnds.width, bnds.height);
    let m = new go.Margin(40);
    r.subtractMargin(m);

    // maybe inflate R if you want some space between the node and any other nodes
    //r.inflate(-10, -10);  // by default, deflate to avoid edge overlaps with "exact" fits
    // only consider non-temporary Layers
    let gos = myDiagram.findObjectsIn(
      r,
      // Navigation function -- only return nodes
      function (x) {
        let p = x.part;
        return p instanceof go.Node ? p : null;
      },
      // Predicate that always receives a node, due to above navigation function
      function (node) {
        return node.data.category === "Node";
      },
      true
    );

    return gos.count > 0 ? gos.first() : null;
  }

  function manageNodeWithForm(node) {
    // we want to drop the form into the node and change the nodes appearnce
    // with some kind of inidication that a form is 'attached' to this node.
    // same as node and link, when it is dropped we also return a dialog.
    let node_rmf_panel = node.findObject("attached-rmf");
    if (node_rmf_panel) node_rmf_panel.visible = true;

    myDiagram.select(node);
    init_rmf_dialog(null, false);
    getRmfForms(null);
    create_type_dropdown(null);

    jQuery("#RMFormHelp").show();
    jQuery(".non-rmflist").addClass("col-md-9");
    jQuery("div.col-md-3.rmflist").show();
    jQuery("#rmFormNodeModal .modal-dialog").removeClass("single-column");

    ArbutusVisualEditor.editRMFormIDs = null;
    ArbutusVisualEditor.isVisualEdit = false;
    
    showDialog("rmFormNode");
  }

  
  function remove_user_owner()
  {
    // hide all _users_ in the node owner select control, as we now only require groups
    // however, it should be noted that web server app still sends all users and groups 
    // over to browser client as legacy installations may still have a user assigned owner, 
    // in those cases we only show said user and all groups.
    jQuery("#form_node_owner option").each(function(_, o) {
      if (o && o.value) {
        let value = o.value.split('_');
        if (value.length === 2 && value[1] === 'u') jQuery(o).hide(); 
      }
    });
    
    jQuery("#form_node_owner").selectpicker("refresh");
  }

  ///////////////////////////////////////////////////////////////////////////////

  jQuery("#warningConfirmModalOK").click(function () {
    // TODO send rollback to server.
    process_id = jQuery("#process_id").text();
    jQuery.ajax({
      url: "/result_manager/api/data/workflow-rollback",
      type: "POST",
      data: { pid: process_id },
      cache: false,
      dataType: "json",
      success: function (resp) {
        console.log("Workflow Cancel - OK");
        window.location.replace("processes");
      },
      error: function (e) {
        console.log(e.message);
      },
    });
  });

  ///////////////////////////////////////////////////////////////////////////////

  prepare_data();
  remove_user_owner();
  
  //////////////////////////////////////////////////////////////////////////////

  jQuery(document).on("click", ".clear-choices", function (e) {
    e.preventDefault();

    let full_qid = jQuery(e.target)[0].id;
    //let i = full_qid.lastIndexOf("-") + 1;
    //let qid = full_qid.substring(i);
    let qid = full_qid.split('-').pop();
    let domAllChoices = "#rmf-question-id-choices-" + qid;
    jQuery(domAllChoices).val("");
  });


  jQuery(document).on("click", ".delete-choice-button", function (e) {
    e.preventDefault();

    // Depending on the type of choice i.e. radio/dropdown
    // we might want to limit at least two choices?

    (e.currentTarget.parentNode.parentElement).remove();
  });


  jQuery(document).on("click", ".add-choice", function (e) {
    e.preventDefault();

    // extract question id from tag id.
    let full_qid = jQuery(e.target)[0].id;
    //let i = full_qid.lastIndexOf("-") + 1;
    //let qid = full_qid.substring(i);
    let qid = full_qid.split('-').pop();
    
    // get the current question type, so we know which container to render.
    // NOTE: only radio and dropdown currently allow adding question choices.
    let question_type = jQuery(`#rmf-question-id-type-${qid}`).val();
    let question_type_tag = 'radio';
    if (question_type == 2) question_type_tag = 'dropdown';

    // get the existing choice item count
    let item = jQuery(`#rmf-question-${question_type_tag}-choices-container-${qid}`)
      .children('.form-field_item.form-field-item_column.choices-list')
      .children('.choice-container');

    let snippet = kendo.template(jQuery(`#single-${question_type_tag}-choices-questions`).html())({
      qid: qid, 
      cid: item.length, 
      choice: ""
    });

    // insert choice snippet between end of last current choice-container and 
    // form-field_item (add choice button)
    jQuery(snippet).insertAfter(jQuery(item.last()));
  });
});


jQuery(document).on("click", "label.radio-button-control-label-secondary", function () {
  if (jQuery(this).hasClass('vertical'))
    console.log('vertical ' + jQuery(this));
  else
    console.log( 'horizontal ' + jQuery(this));
});


jQuery(document).on("keyup", "div.choice-container > div.choice-input-container > input.input-control", function (e) {
  let cid = jQuery(jQuery(e.currentTarget.parentNode.parentElement)[0]).children()[0].id;
  // HACK - if cid has no length, must be a dropdown.
  if (cid.length === 0) cid = jQuery(e.currentTarget)[0].id;
  let cidar = cid.split('-');
  let qid = cidar[cidar.length - 1];
  let ctypeid = `#rmf-question-id-type-${qid}`;
  let ctype = jQuery(ctypeid).val();

  // iterate over all choices to find largest choice length.
  let choice_ctrls = jQuery(
    `#rmf-question-${get_choices_type_label(ctype)}-choices-container-${qid} .choices-list input.input-control`);
  let max_len = 2;
  choice_ctrls.each(function (_, elem) {
    let value = jQuery(elem).val();
    if (value.length > max_len) max_len = value.length;
  });
  
  update_analyzer_fieldlength(max_len, qid);
});

function default_analyzer_fieldlength(ctype)
{
  let len = -1;
  if (ctype == '1' || ctype == '2' || ctype == '3') len = 2;     // radio, dropdown len. dictated by max length of its choices.
  //if (ctype == '3') len = 2;                                   // checkbox
  //else if (ctype == '4') return len;                           // label has no analyzer field (name/length), purely UI.
  else if (ctype == '5')  len = 128;                             // short answer
  else if (ctype == '10') len = 32;                              // email
  else if (ctype == '6') len = 12;                               // date
  else if (ctype == '7' || ctype == '9') len = 16;               // numeric, numeric scale
  else if (ctype == '8') len = 512;                              // paragraph
  return len; 
}

function update_analyzer_fieldlength(len, qid)
{
  //if (!ArbutusVisualEditor.editRMFormIDs) {  // only update if NOT editing
  let fnid = `#rmf-question-id-fieldlength-${qid}`;
  let current_len = jQuery(fnid).val();
  if (len > current_len) jQuery(fnid).val(len);
  //}
}

// Global Page Functions

// Make all ports on a node visible when the mouse is over the node

function showPorts(node, show) {
  let diagram = node.diagram;
  if (!diagram || diagram.isReadOnly || !diagram.allowLink) return;
  node.ports.each(function (port) {
    port.stroke = show ? "white" : null;
  });
}

// link context menu options
function editLink(e, obj) {
  let link = obj.part;

  if (link && link.data) {
    jQuery("#form_edge_label").val(link.data.text);
    jQuery("#form_edge_description").val(link.data.desc);
    // also handle old data that might still be 'T' or 'F'
    // now use;
    // "0" - default
    // "1" - choose
    // "2" - same
    let choose = link.data.choose;
    let value = "0";
    if (choose == "F") value = "0";
    else if (choose == "T") value = "1";
    else value = link.data.choose;

    // iterate over all assignee radio button labels and remove active class
    jQuery("input[name='assignee']").each(function (index) {
      let label = jQuery(this).parent("label");
      label.removeClass("active");
    });

    // select current button and make parent label active.
    let button = jQuery("input[name=assignee][value=" + value + "]");
    button.prop("checked", true);
    let label = button.parent("label");
    label.addClass("active");
  }

  ArbutusVisualEditor.isVisualEdit = true;
  showDialog("edge");
}

// This custom-routing Link class tries to separate parallel links from each other.
// This assumes that ports are lined up in a row/column on a side of the node.
/*function CustomLink() {
 go.Link.call(this);
 };
 go.Diagram.inherit(CustomLink, go.Link);
 CustomLink.prototype.findSidePortIndexAndCount = function (node, port) {
 var nodedata = node.data;
 if (nodedata !== null) {
 var portdata = port.data;
 var side = port._side;
 var arr = nodedata[side + "Array"];
 var len = arr.length;
 for (var i = 0; i < len; i++) {
 if (arr[i] === portdata) return [i, len];
 }
 }
 return [-1, len];
 };
 /!** @override *!/
 CustomLink.prototype.computeEndSegmentLength = function (node, port, spot, from) {
 var esl = go.Link.prototype.computeEndSegmentLength.call(this, node, port, spot, from);
 var other = this.getOtherPort(port);
 if (port !== null && other !== null) {
 var thispt = port.getDocumentPoint(this.computeSpot(from));
 var otherpt = other.getDocumentPoint(this.computeSpot(!from));
 if (Math.abs(thispt.x - otherpt.x) > 20 || Math.abs(thispt.y - otherpt.y) > 20) {
 var info = this.findSidePortIndexAndCount(node, port);
 var idx = info[0];
 var count = info[1];
 if (port._side == "top" || port._side == "bottom") {
 if (otherpt.x < thispt.x) {
 return esl + 4 + idx * 8;
 } else {
 return esl + (count - idx - 1) * 8;
 }
 } else {  // left or right
 if (otherpt.y < thispt.y) {
 return esl + 4 + idx * 8;
 } else {
 return esl + (count - idx - 1) * 8;
 }
 }
 }
 }
 return esl;
 };
 /!** @override *!/
 CustomLink.prototype.hasCurviness = function () {
 if (isNaN(this.curviness)) return true;
 return go.Link.prototype.hasCurviness.call(this);
 };
 /!** @override *!/
 CustomLink.prototype.computeCurviness = function () {
 if (isNaN(this.curviness)) {
 var fromnode = this.fromNode;
 var fromport = this.fromPort;
 var fromspot = this.computeSpot(true);
 var frompt = fromport.getDocumentPoint(fromspot);
 var tonode = this.toNode;
 var toport = this.toPort;
 var tospot = this.computeSpot(false);
 var topt = toport.getDocumentPoint(tospot);
 if (Math.abs(frompt.x - topt.x) > 20 || Math.abs(frompt.y - topt.y) > 20) {
 if ((fromspot.equals(go.Spot.Left) || fromspot.equals(go.Spot.Right)) &&
 (tospot.equals(go.Spot.Left) || tospot.equals(go.Spot.Right))) {
 var fromseglen = this.computeEndSegmentLength(fromnode, fromport, fromspot, true);
 var toseglen = this.computeEndSegmentLength(tonode, toport, tospot, false);
 var c = (fromseglen - toseglen) / 2;
 if (frompt.x + fromseglen >= topt.x - toseglen) {
 if (frompt.y < topt.y) return c;
 if (frompt.y > topt.y) return -c;
 }
 } else if ((fromspot.equals(go.Spot.Top) || fromspot.equals(go.Spot.Bottom)) &&
 (tospot.equals(go.Spot.Top) || tospot.equals(go.Spot.Bottom))) {
 var fromseglen = this.computeEndSegmentLength(fromnode, fromport, fromspot, true);
 var toseglen = this.computeEndSegmentLength(tonode, toport, tospot, false);
 var c = (fromseglen - toseglen) / 2;
 if (frompt.x + fromseglen >= topt.x - toseglen) {
 if (frompt.y < topt.y) return c;
 if (frompt.y > topt.y) return -c;
 }
 }
 }
 }
 return go.Link.prototype.computeCurviness.call(this);
 };*/
// end CustomLink class

// modified document
/*function do_modified() {
 var button = document.getElementById("SaveButton");
 if (button)
 button.disabled = !myDiagram.isModified;
 var idx = document.title.indexOf("*");
 if (myDiagram.isModified) {
 if (idx < 0) document.title += "*";
 } else {
 if (idx >= 0) document.title = document.title.substr(0, idx);
 }
 }*/

// remove Node
function removeObject(e, obj) {
  jQuery("#warningObjRemoveConfirmModal")
    .one("hide.bs.modal", function (modal_evt) {
      let btn_id = jQuery(document.activeElement).attr("id");
      if (btn_id === "warningObjRemoveConfirmOK") {
        // determine WorkFlow UI Object to determine DELETE MSG type for server.
        let gobj = obj.part.adornedPart;
        e.diagram.commandHandler.deleteSelection();

        let msg = "";
        let gid = -1;
        let sid = -1;
        let pid = -1;
        if (gobj instanceof go.Node) {
          msg = "delete-states";
          gid = gobj.data.id;
          pid = sessionStorage.getItem("process_id");
        } else if (gobj instanceof go.Link) {
          msg = "delete-actions";
          gid = gobj.data.id;
        } else if (gobj.data.category === "RMForm") {
          // not relevant as RMForm has it own handler -> removeNodeRMForm(...)
          msg = "delete-forms";
          gid = gobj.data.rmf_id;
          pid = sessionStorage.getItem("process_id");
          sid = gobj.data.id;
        }

        if ((gid > 0 || gid.length > 0) && msg.length > 0) {
          ExceptionManagerServer.setCurrentCommand("Delete");
          ExceptionManagerServer.api_data_ve_details(msg, {
            gid: gid,
            pid: pid,
            sid: sid,
            flow: myDiagram.model.toJson()
          });
        }
      }
    })
    .modal("show");
  jQuery("#warningObjRemoveConfirmModal").appendTo("body"); // hack to force dialog to front
}

function removeNodeRMForm(e, obj) {
  let node = obj.part.adornedPart;

  // not need to show warning if no rmform attahced to node.
  let node_rmf_panel = node.findObject("attached-rmf");
  if (node_rmf_panel && node_rmf_panel.visible === false) return;

  jQuery("#warningObjRemoveConfirmModal")
    .one("hide.bs.modal", function (modal_evt) {
      let btn_id = jQuery(document.activeElement).attr("id");
      if (btn_id === "warningObjRemoveConfirmOK") {
        // hide the rmform shape on current node.
        node_rmf_panel.visible = false;

        // send to server
        ExceptionManagerServer.setCurrentCommand("Delete");
        ExceptionManagerServer.api_data_ve_details("delete-forms", {
          gid: node.data.rmf_id,
          pid: sessionStorage.getItem("process_id"),
          sid: node.data.id,
          flow: myDiagram.model.toJson(),
        });

        // clear the rmf specific node properites
        clear_rmf_node_fields(node);
      }
    })
    .modal("show");
  jQuery("#warningObjRemoveConfirmModal").appendTo("body"); // hack to force dialog to front
}

// edit node
function editNode(e, obj) {
  let node = obj.part.adornedPart;

  // populate dialog with node details
  if (!(node && node.data)) {
  } else {
    jQuery("#form_node_label").val(node.data.text);
    jQuery("#form_node_description").val(node.data.desc);    

    // see if id is a user owner type
    let owner_type = "u";
    let is_owner_type = jQuery(
      "#form_node_owner option[value='" +
        node.data.owner +
        "_" +
        owner_type +
        "']"
    );

    // if id is not user owner type, then it must be group
    if (is_owner_type.length == 0) 
      owner_type = "g";
    else
      is_owner_type.show();
    
    let option_value = node.data.owner + "_" + owner_type;
    jQuery("#form_node_owner").selectpicker("val", option_value);
    jQuery("#form_node_owner").selectpicker("refresh");

    // NOTE: Now that blank is a valid option, it cannot be used to decide if we should enable the widget.
    if (owner_type === "g")
      jQuery("#form_node_method").prop("disabled", false);
    else 
      jQuery("#form_node_method").prop("disabled", true);

    jQuery("#form_node_method").selectpicker("val", node.data.method);
    jQuery("#form_node_method").selectpicker("refresh");

    if (node.data.return === "T")
      jQuery("#form_node_return").prop("checked", true);
    else 
      jQuery("#form_node_return").prop("checked", false);

    // disable if first user created node.
    if (
      myDiagram.nodes.count === 3 ||
      (node.findLinksInto().count === 1 &&
        node.findLinksInto().iterator.first().data.from === 0)
    )
      jQuery("#form_node_return").attr("disabled", true);
    else jQuery("#form_node_return").removeAttr("disabled");

    // new notification related controls

    if (node.data.emergency === "T")
      jQuery("#form_node_emergency").prop("checked", true);
    else jQuery("#form_node_emergency").prop("checked", false);

    jQuery("#form_node_subject").val(node.data.subject);
    jQuery("#form_node_body").val(node.data.body);

    ///////////////////////////////////////////////////////////////////////////////////////////////////

    jQuery("#form_node_duration").val(node.data.duration);
    //option_value = jQuery("#form_node_type").find("option:contains(" + node.data.type + ")").val();
    jQuery("#form_node_type").selectpicker(
      "val",
      node.data.type /*option_value*/
    );
    jQuery("#form_node_type").selectpicker("refresh");

    //
    // Edit state: comment out or hide the controls related to overdue action and reminder.
    // These won't make phase 1, as they are so easy to set up in analyzer.
    //

    /*
        option_value = jQuery("#form_node_overdue").find("option:contains(" + node.data.overdue + ")").val();
        jQuery("#form_node_overdue").selectpicker('val', option_value);
        jQuery("#form_node_reminder").val(node.data.reminder);
        */
  }

  ArbutusVisualEditor.isVisualEdit = true;
  showDialog("node");
}

/*
function rmFormExists(search_phrase = null) {
  jQuery.ajax({
    url: "/result_manager/api/data/get-rmforms",
    type: "POST",
    data: {
      search_phrase: JSON.stringify(search_phrase),
    },
    cache: false,
    dataType: "json",
    success: function (resp) {
      
      if (resp.error.length === 0) {   // check for hub server error
        const form_label = fields[5];
        if (form_label === search_phrase) 
      } else {
        jQuery("#errors").html(resp.error);
        jQuery("#messageModal").modal("show");
        return false;
      } 
    },
    error: function (e) {
      console.log(e.message);
    }
  });
}
*/

function getRmfForms(search_phrase = null) {
  jQuery.ajax({
    url: "/result_manager/api/data/get-rmforms",
    type: "POST",
    data: {
      search_phrase: JSON.stringify(search_phrase),
    },
    cache: false,
    dataType: "json",
    success: function (resp) {
     
      if (resp.error.length === 0) {   // check for hub server error
        jQuery("#rmf-node-forms-list").empty();
        if (resp.forms.length === 0 || resp.forms[0].length === 0) return;

        resp.forms.forEach(function (obj) {
          //     0          1             2         3         4         5           6         7
          // "process_id\process_label\state_id\state_label\form_id\form_label\description\questions"
          const fields = obj.split("\t");
          if (fields.length < 7) return;
          const process_id = fields[0];
          const state_id = fields[2];
          const form_id = fields[4];
          const form_label = fields[5];
          const description = fields[6];

          // NOTE: Could use client-side templating instead of embedded HTML/CSS
          const value = process_id + "*" + state_id + "*" + form_id;
          let class_str =
            'class="list-group-item list-group-item-action flex-column align-items-start"';
          if (ArbutusVisualEditor.previousFormListSelection == form_id)
            class_str =
              'class="list-group-item list-group-item-action flex-column align-items-start selected"';

          jQuery("#rmf-node-forms-list").append(
            '<button type="button "' +
              class_str +
              '" data-value="' +
              value +
              '">' +
              '<div class="d-flex w-100 justify-content-between">' +
              '<h5 class="mb-1 form-label">' +
              form_label +
              "</h5>" +
              "<span class='form-date'>" +
//              "12 Jun 2022" +   // no date currently in get-rm-forms buffer returned 
              "</span>" +
              "</div>" +
              "<p class='description'>" +
              description +
              "</p>" +
              "</button>"
          );
        });
      } else {
        jQuery("#errors").html(resp.error);
        jQuery("#messageModal").modal("show");
        return;
      }
    },
    error: function (e) {
      console.log(e.message);
    },
  });
}

function create_type_dropdown(qid, qv=5) {
  let domSelector = ".rmf-question-type";
  if (qid !== null) domSelector = "#rmf-question-id-type-" + qid;

  const ICONS = {
    checkbox: "checkbox-icon",
    radiobutton: "radiobutton-icon",
    dropdown: "dropdown-icon",
    date: "date-icon",
    paragraph: "paragraph-icon",
    label: "label-icon",
    email: "email-icon",
    numeric: "numeric-icon",
    numericscale: "scale-icon",
    email: "email-icon",
    shortanswer: "short-answer-icon",
  };

  jQuery(domSelector).kendoDropDownList({
    valueTemplate: ({ text }) => {
      return `<span class="icon-element ${
        ICONS[text.toLowerCase().replace(/\s/g, "")]
      }" ></span>${text}`;
    },
    index: parseInt(qv) - 1,
  })
}

function prepare_question_choices(aQuestion, question_no)
{
  if (aQuestion.hasOwnProperty("choices") && aQuestion.choices.length > 0) {
    let choices_arr = aQuestion.choices.split(",");   // comma seperated string of choices.
    choices_arr.forEach(function (aChoice, idx) {
      
      // two input widget choices in html template as default,
      // so if we need more we will need to create them dynamically?

      let cid = '#rmf-question-' + get_choices_type_label(aQuestion.type) + '-choices-container-' + question_no; 
      // determine input widget for this cid (parent) container
      if (idx > 1)
        ; // TODO - add another choice input to relevant question type/choices container.

      // e.g. '#rmf-question-dropdown-choices-container-1'
      jQuery(jQuery(cid).find('input.input-control')[idx]).val(aChoice);

    });

  }
}

function populateNodeRMFormQuestion(rmf_questions) {
  let tabstrip = jQuery("#tabstrip").data("kendoTabStrip");

  // if there is already items, remove them.
  tabstrip.remove(tabstrip.tabGroup.children());

  let idx_offset = 0;
  rmf_questions.forEach(function (aQuestion, idx) {
    // do not add any questions that do not have legit data
    if ( aQuestion["question-rmid"] != -1 && aQuestion.hasOwnProperty('thequestion') ) {
      let question_no = idx + 1;
      question_no += idx_offset;
      let append_text = "Question " + question_no;
      // ' <button data-type="remove" class="k-button k-button-icon"><span class="k-icon k-i-close"></span></button>';
      tabstrip.append([
        {
          text: append_text,
          imageUrl: "/static/result_manager/img/drag-icon.svg",
          encoded: false, // Allows use of HTML for item text
          content: kendo.template(jQuery("#question-template").html())({
            qid: question_no,
            quest: aQuestion
          }) // Content for the content element
        }
      ]);

      /*
      if (rmf_questions == 1) {
        // set initial state of only one question to disabled
        let item = jQuery("[data-type='remove']");
        item.prop("disabled", true).addClass("k-state-disabled");
      }
      */

      // Note, we could in theory pass the edit val's into the kendoui template BUT
      // modifying all the different control types that are not simple values, seemed easier to do
      // with javascript by referencing rather than passing as template data.

      // top-level-template - rmform-question-id

      // common-top
      let cid = "#rmf-question-id-question-rmid-" + question_no;
      let question_rmid = aQuestion["question-rmid"];
      if (question_rmid != -1) {  // TODO: Should there be -1 rmid questions?
        jQuery(cid).val(question_rmid);
        cid = "#rmf-question-id-type-" + question_no;
        create_type_dropdown(question_no, aQuestion.type);
        
        //jQuery(cid + ' option[value="' + aQuestion.type + '"]').prop(
        //  "selected",
        //  true
        //);
        cid = "#rmf-question-id-thequestion-" + question_no;
        jQuery(cid).val(aQuestion.thequestion);

        // common-choices // TODO use Edit/Tag system
        prepare_question_choices(aQuestion, question_no);

        // common-numeric-scale // NOTE,  will use choices to hold values if type is numeric as choices will be a multi-purpose holder.
        if (aQuestion['type'] === '9') {
          let choices = aQuestion['choices'].split(',')
          cid = "#rmf-question-id-numeric-min-" + question_no;
          jQuery(cid).val(choices[0].trim());  // min
          cid = "#rmf-question-id-numeric-max-" + question_no;
          jQuery(cid).val(choices[1].trim());  // max
        }

        // common-bottom
        cid = "#rmf-question-id-mandatory-" + question_no;
        aQuestion.mandatory === "T" || aQuestion.mandatory === "Y"
          ? jQuery(cid).prop("checked", true)
          : jQuery(cid).prop("checked", false);
        cid = "#rmf-question-id-fieldname-" + question_no;
        jQuery(cid).val(aQuestion.fieldname);
        cid = "#rmf-question-id-fieldlength-" + question_no;
        jQuery(cid).val(aQuestion.fieldlength);

        show_hide_form_containers(aQuestion.type, question_no);
      }
    } else {
      idx_offset -= 1;
    }
  });

  //tabstrip.select("li:first");  // Select by jQuery selector
  tabstrip.select(0);

  if (rmf_questions.length == 1) {
    // set initial state of only one question to disabled
    let item = jQuery("[data-type='remove']");
    item.prop("disabled", true).addClass("k-state-disabled");
  }

}

function editNodeRMForm(e, obj) {
  // extract relevant RMForm properities from parent node
  // and populate the form.
  let node = obj.part.adornedPart;

  // no rmform attached to node, return
  let node_rmf_panel = node.findObject("attached-rmf");
  if (node_rmf_panel && node_rmf_panel.visible === false) return;

  // populate all forms dropdown
  getRmfForms(null);

  // populate dialog with node rm form details
  if (node && node.data) {
    ArbutusVisualEditor.editRMFormIDs =
      jQuery("#process_id").text() +
      "*" +
      node.data.id +
      "*" +
      node.data.rmf_id;
    jQuery("#rmf-node-label").val(node.data.rmf_text);
    jQuery("#rmf-node-description").val(node.data.rmf_desc);

    // populate dialog with node rm form Questions
    populateNodeRMFormQuestion(node.data.rmf_questions);
  }

  jQuery("#RMFormHelp").hide();
  jQuery(".non-rmflist").removeClass("col-md-9");
  jQuery("div.col-md-3.rmflist").hide();
  jQuery("#rmFormNodeModal .modal-dialog").addClass("single-column");

  ArbutusVisualEditor.isVisualEdit = true;
  showDialog("rmFormNode");
}

// Add a port to the specified side of the selected nodes.
function addPort(side) {
  myDiagram.startTransaction("addPort");
  myDiagram.selection.each(function (node) {
    // skip any selected Links
    if (!(node instanceof go.Node)) return;
    // compute the next available index number for the side
    let i = 0;
    while (node.findPort(side + i.toString()) !== node) i++;
    // now this new port name is unique within the whole Node because of the side prefix
    const name = side + i.toString();
    // get the Array of port data to be modified
    let arr = node.data[side + "Array"];
    if (arr) {
      // create a new port data object
      let newportdata = {
        portId: name, //,
        //fill: "transparent" //go.Brush.randomColor()
        // if you add port data properties here, you should copy them in copyPortData above
      };

      // and add it to the Array of port data
      myDiagram.model.insertArrayItem(arr, -1, newportdata);
    }
  });

  myDiagram.commitTransaction("addPort");
}

// Remove the clicked port from the node.
// Links to the port will be redrawn to the node's shape.
function removePort(port) {
  myDiagram.startTransaction("removePort");
  let pid = port.portId;
  let arr = port.panel.itemArray;
  for (let i = 0; i < arr.length; i++) {
    if (arr[i].portId === pid) {
      myDiagram.model.removeArrayItem(arr, i);
      break;
    }
  }

  myDiagram.commitTransaction("removePort");
}

// Remove all ports from the same side of the node as the clicked port.
function removeAll(port) {
  myDiagram.startTransaction("removePorts");
  let nodedata = port.part.data;
  let side = port._side; // there are four property names, all ending in "Array"
  myDiagram.model.setDataProperty(nodedata, side + "Array", []); // an empty Array
  myDiagram.commitTransaction("removePorts");
}

// Change the color of the clicked port.
// function changeColor(port) {
//     myDiagram.startTransaction("colorPort");
//     var data = port.data;
//     myDiagram.model.setDataProperty(data, "portColor", go.Brush.randomColor());
//     myDiagram.commitTransaction("colorPort");
// }

function get_first_state_id() {
  let first_state_id = null;
  for (let it = myDiagram.nodes; it.next(); ) {
    let n = it.value; // n is now a Node or a Group
    if (n.category === "Start") {
      first_state_id = n.findNodesOutOf().value.data.id;
      break;
    }
  }

  return first_state_id;
}

function validate_diagram() {
  let errors = [];
  // start node must have 1 link from itself to at least 1 other node
  // close node must have at least 1 link to it.
  // state nodes must have at least 1 link in and 1 link out to other nodes.

  // iterate over all the nodes in the diagram and check their status
  // with respects to the rules outlined above.
  for (let it = myDiagram.nodes; it.next(); ) {
    let n = it.value; // n is now a Node or a Group
    if (n.category === "Start") {
      if (n.findLinksOutOf().count < 1) {
        errors.push("Start requires one action link to another activity node!");
      } else if (n.findLinksOutOf().first().toNode.category == "Close") {
        errors.push("Must be at least one activity node between Start and Close!");
      }
    } else if (n.category === "Close") {
      if (n.findLinksInto().count < 1) {
        errors.push("Close requires at least one action link from another activity node!");
      }
    } else if (n.category === "Node") {
      let linksout = false;
      let linksin = false;

      // iterate over links out of node
      for (let lt = n.findLinksOutOf(); lt.next(); ) {
        let l = lt.value;
        //  if link not pointing to self
        if (l.toNode != n) {
          linksout = true;
          break;
        }
      }

      for (let lt = n.findLinksInto(); lt.next(); ) {
        let l = lt.value;
        //  if link not pointing to self
        if (l.fromNode != n) {
          linksin = true;
          break;
        }
      }

      if (!linksout || !linksin)
        errors.push(
          "Every activity node must have at least 1 action link to and from another activity node!"
        );
    } else {
      console.log("Unknown node Category!");
    }
  }

  return errors;
}

function show_diagram_errors(errors) {
  let errors_html = "";
  for (let idx in errors) {
    errors_html += "<p>";
    errors_html += errors[idx];
    errors_html += "</p>";
  }

  jQuery("#errors").html(errors_html);
  jQuery("#messageModal").modal("show");
}

//////////////////////////////////////////////////////////////////////////////
// Show the diagram's model in JSON format
function save() {
  // check diagram and show any client side assumptions not met.
  let errors = validate_diagram();
  let label = jQuery("#process_label").val();
  if (errors.length > 0) {
    show_diagram_errors(errors);
    return;
  }
  else if(label.match("'") || label.match('"')) {
    jQuery("#errors").html("Single and double quotes are not acceptable in the workflow label.");
    jQuery("#messageModal").modal('show');
    return; 
  }

  let form_data = {
    process_id: jQuery("#process_id").text(),
    first_state_id: get_first_state_id(),
    process_label: jQuery("#process_label").val(),
    process_description: jQuery("#process_description").val(),
    process_serialno: jQuery("#process_serialno").val(),
    savedModel: myDiagram.model.toJson(),
    command: ArbutusVisualEditor.currentCommand,
  };

  // disable 'save' button until we return from server.
  jQuery('#SaveButton').prop('disabled', true);

  // send data to server
  ExceptionManagerServer.setCurrentCommand(ArbutusVisualEditor.currentCommand);
  ExceptionManagerServer.api_data_ve_details("visual-flows", form_data);

  /*
    jQuery.ajax({
        url: "/result_manager/api/veditor/save",
        type: "POST",
        data: {
            "savedModel": json_data,
            "process_label": jQuery('#process_label').val(),
            "process_description": jQuery('#process_description').val(),
            "command": ArbutusVisualEditor.currentCommand,
            "process_id": jQuery('#process_id').text()
        },
        cache: false,
        dataType: "json",
        success: function (resp) {
            // check for windows server error
            if (resp.result === 'OK') {
                // redirect to processes window
                window.location.replace("processes");
            }
            else {
                jQuery('#errors').html(resp.error);
                jQuery('#messageModal').modal('show');
                console.log(resp.err);
                return;
            }
        },
        error: function (e) {
            console.log(e.message);
        }
    });
    */
}

function cancel(e) {
  jQuery("#warningConfirmModal").modal("show");
  jQuery("#warningConfirmModal").appendTo("body"); // hack to force dialog to front
}

function load(data) {
  if (data != null) myDiagram.model = go.Model.fromJson(data);
  else
    myDiagram.model = go.Model.fromJson(
      document.getElementById("defaultModel").innerHTML
    );
}

function showDialog(s) {
  const name = "#" + s + "Modal";
  jQuery(name)
    .off()
    .on("hide.bs.modal", function (e) {
      if (ArbutusVisualEditor.dialogCancelled == true) {
        // only undo if was a create NOT edit.
        if (ArbutusVisualEditor.isVisualEdit == false) {
          myDiagram.commandHandler.undo();
        }
      }

      // should reset dialog form values?
      jQuery(this).find("form").trigger("reset");
      jQuery("select").scrollTop(0);
      jQuery("#form_node_owner").selectpicker("refresh");
      jQuery("#form_node_method").selectpicker("refresh");

      ArbutusVisualEditor.dialogCancelled = true;
    })
    .on("shown.bs.modal", function (e) {
      jQuery("input:text:visible:enabled", this)
        .not('[readonly="readonly"]')
        .first()
        .focus();
        
      // ensure that scrollbar redrawn after adding all the form question panels.
      kendo.resize(jQuery(".tabstrip-container"));
      //jQuery("#tabstrip").kendoTabStrip().data("kendoTabStrip").select(1);
    })
    .modal("show");
}

function prepare_data() {
  // data in global js, display
  jQuery("#process_label").val(sessionStorage.getItem("process_label"));
  jQuery("#process_label").attr('title', sessionStorage.getItem("process_label"));
  jQuery("#process_description").val(sessionStorage.getItem("process_description")); 
  jQuery("#process_description").attr('title', sessionStorage.getItem("process_description"));
  jQuery("#process_serialno").val(sessionStorage.getItem("process_serialno")); 
  jQuery("#process_serialno").attr('title', sessionStorage.getItem("process_serialno"));
  jQuery("#process_id").text(sessionStorage.getItem("process_id"));
  if (sessionStorage.getItem("process_entry").length > 0) {
    ArbutusVisualEditor.currentCommand = "Update";
    load(sessionStorage.getItem("process_entry"));

    // iterate over diagram nodes and if it has a form, make node form panel visible.
    for (let it = myDiagram.nodes; it.next(); ) {
      let n = it.value; // n is now a Node or a Group (we are not using groups to data...)
      if (n.category === "Node") {
        if (n.data.hasOwnProperty("rmf_id") && n.data.rmf_id > 1000000) {
          let node_rmf_panel = n.findObject("attached-rmf");
          if (node_rmf_panel) node_rmf_panel.visible = true;
        }
      }
    }
  } else {
    ArbutusVisualEditor.currentCommand = "Create";
    load(null);
  }
}

function clear_rmf_node_fields(node) {
  // if node is null, use the first selected node
  if (node === null) node = myDiagram.selection.first();

  // if rmf... properities not found, no form on node assumed.
  if (node && node.data) {
    delete node.data.rmf_text;
    delete node.data.rmf_desc;
    delete node.data.rmf_id;
    delete node.data.rmf_questions;
  }
}

function init_rmf_dialog(tabstrip, clear_model) {
  if (tabstrip === null) tabstrip = jQuery("#tabstrip").data("kendoTabStrip");

  // if there is already items, remove them.
  tabstrip.remove(tabstrip.tabGroup.children());

  tabstrip.append([
    {
      text: "Question 1",
      encoded: false, // Allows use of HTML for item text
      imageUrl: "/static/result_manager/img/drag-icon.svg",
      // Content for the content element
      content: kendo.template(jQuery("#question-template").html())({ 
        qid: 1, 
        quest: null 
      })
    }
  ]);

  // set initial state of only one question to disabled
  let item = jQuery("[data-type='remove']");
  item.prop("disabled", true).addClass("k-state-disabled");

  tabstrip.select(0);

  if (clear_model) {
    // form question-rmid
    if (
      typeof myDiagram.selection.first().data.rmf_questions === "undefined" ||
      !Array.isArray(myDiagram.selection.first().data.rmf_questions)
    ) {
      myDiagram.selection.first().data.rmf_questions = [];
    }

    myDiagram.selection
      .first()
      .data.rmf_questions.push({ "question-rmid": -1 });
      
    const domId = "#rmf-question-id-question-rmid-1";
    jQuery(domId).val(-1);
  }

  show_hide_form_containers(5, 1);  // default is 5:'Short Answer'
  datePickerInit();
  numericInputInit();
  selectControlInit();

  // default to short answer for question type
  update_analyzer_fieldlength(default_analyzer_fieldlength(5), 1);
}

function datePickerInit() {
  jQuery("[data-type=date-picker]:not([data-role=datepicker])").kendoDatePicker(
    {
      format: "yyyy-MM-dd",
    }
  );
  jQuery(".datepicker .k-icon").removeClass("k-i-calendar");
  jQuery(".datepicker .k-icon").addClass("calendar-icon");
}

function numericInputInit() {
  jQuery(
    "[data-type=numeric-input]:not([data-role=numerictextbox])"
  ).kendoNumericTextBox();

  jQuery(".numeric-input .k-link-decrease .k-icon").removeClass(
    "k-i-arrow-60-down"
  );
  jQuery(".numeric-input .k-link-decrease .k-icon").addClass(
    "chevron-down-small-icon"
  );

  jQuery(".numeric-input .k-link-increase .k-icon").removeClass(
    "k-i-arrow-60-up"
  );
  jQuery(".numeric-input .k-link-increase .k-icon").addClass(
    "chevron-up-small-icon"
  );
}

function selectControlInit(data = [1, 2, 3, 4, 5, 6, 7, 8, 9]) {
  jQuery("[data-type=select]:not([data-role=dropdownlist])").kendoDropDownList({
    dataSource: data,
  });
}

function generateSectionTypeDomIds(index) {
  return {
    radioChoicesDomId: `#rmf-question-radio-choices-container-${index}`,
    dropdownChoicesDomId: `#rmf-question-dropdown-choices-container-${index}`,
    checkboxChoicesDomId: `#rmf-question-checkbox-choices-container-${index}`,
    numericDomId: `#rmf-question-numeric-container-${index}`,
    choicesPositionDomId: `#rmf-question-fields-position-${index}`,
    paragraphDomId: `#rmf-question-paragraph-container-${index}`,
    emailDomId: `#rmf-question-email-container-${index}`,
    shortAnswerDomId: `#rmf-question-short-answer-container-${index}`,
    mandatoryDomId: `#rmf-question-mandatory-container-${index}`,
    dateDomId: `#rmf-question-date-container-${index}`,
    numericScaleDomId: `#rmf-question-numeric-scale-container-${index}`,
  };
}

function show_hide_form_containers(val, index) {
  const domIds = generateSectionTypeDomIds(index);

  const {
    checkboxChoicesDomId,
    choicesPositionDomId,
    dateDomId,
    dropdownChoicesDomId,
    emailDomId,
    mandatoryDomId,
    numericDomId,
    numericScaleDomId,
    paragraphDomId,
    radioChoicesDomId,
    shortAnswerDomId,
  } = domIds;

  jQuery.each(domIds, (key, value) => {
    if (value === mandatoryDomId) {
      jQuery(value).show();
      return;
    }
    jQuery(value).hide();
  });

  type_val = parseInt(val);
  switch (type_val) {
    case 1:
      jQuery(radioChoicesDomId).show();
      jQuery(choicesPositionDomId).show();
      break;
    case 2:
      jQuery(dropdownChoicesDomId).show();
      break;
    case 3:
      jQuery(checkboxChoicesDomId).show();
      jQuery(choicesPositionDomId).show();
      break;
    case 4:
      jQuery(mandatoryDomId).hide();
      break;
    case 5:
      jQuery(shortAnswerDomId).show();
      break;
    case 6:
      jQuery(dateDomId).show();
      break;
    case 7:
      jQuery(numericDomId).show();
      break;
    case 8:
      jQuery(paragraphDomId).show();
      break;
    case 9:
      jQuery(numericScaleDomId).show();
      break;
    case 10:
      jQuery(emailDomId).show();
      break;

    default:
      break;
  }
}

function get_choices_type_label(aType)
{
  let result = '';
  switch ( parseInt(aType) ) {
    case 1:
      result = 'radio';
      break;
    case 2:
      result = 'dropdown';
      break;
    //case 3:
    //  result = 'checkbox';
    //  break;
    default:
      break;
  }

  return result;  // if empty string, this is not a question type with choices.
}
