from django.urls import re_path
from django.contrib.auth.decorators import login_required

from . import views, views_api


urlpatterns = [
    # plain template views, template with GET and grid populated with POST
    re_path(r'^$', views.LoginView.as_view(), name='em-login'),
    re_path(r'^activities', views.ActivityView.as_view(), name='activity'),
    re_path(r'^activities/thread(?P<thread_activities_id>[0-9]+)/$', views.ActivityView.as_view(), name='thread-activities'),
    re_path(r'^users$', views.UsersView.as_view(), name='users'),
    re_path(r'^groups$', views.GroupsView.as_view(), name='groups'),
    re_path(r'^processes$', views.ProcessesView.as_view(), name='processes'),
    re_path(r'^threads', views.ThreadsView.as_view(), name='threads'),
    re_path(r'^admin', views.AdminView.as_view(), name='admin'),

    # special view handlers for attachments
    re_path(r'^attachments', views.download_file, name='attachments'),
    re_path(r'^upload', views.upload, name='upload'),

    # You may optionally define a delete re_path as well

    # sundry views without grids
    re_path(r'^dashboard$', views.DashboardView.as_view(), name='dashboard'),
    re_path(r'^logout$', views.LogoutView.as_view(), name='em-logout'),
    re_path(r'^visual-editor$', views.VisualEditorView.as_view(), name='visual-editor'),

    # JSONs responses
    re_path(r'^api/data/basic$', views_api.api_data_basic, name='api-data-basic'),
    re_path(r'^api/data/details$', views_api.api_data_details, name='api-data-details'),
    re_path(r'^api/data/ve-details$', views_api.api_data_ve_details, name='api-data-ve-details'),
    re_path(r'^api/data/close-activity$', views_api.api_data_close_activity, name='api-data-close-activity'),
    re_path(r'^api/data/reassign-activities$', views_api.api_data_reassign_activities, name='api_data_reassign_activities'),
    re_path(r'^api/data/notes-activity$', views_api.api_data_notes, name='api-data-notes'),
    #re_path(r'^api/veditor/load', views.api_veditor_load, name='api-veditor-load'),
    re_path(r'^api/veditor/save', views_api.api_veditor_save, name='api-veditor-save'),
    re_path(r'^api/data/grids-config', login_required(views_api.api_data_grids_config), name='api-data-grids-config'),
    re_path(r'^api/data/backup', login_required(views_api.api_data_backup), name='api-data-backup'),
    re_path(r'^api/data/restore', login_required(views_api.api_data_restore), name='api-data-restore'),
    re_path(r'^api/data/enum-log', login_required(views_api.api_data_enum_log), name='api-data-enum-log'),

    # rm forms
    re_path(r'^api/data/request-id/(?P<num_ids>\d+)/$', login_required(views_api.api_request_id), name='api-request-id'),
    re_path(r'^api/data/get-rmforms', login_required(views_api.api_get_rmforms), name='api-get-rmforms'),
    re_path(r'^api/data/workflow-rollback', login_required(views_api.api_workflow_rollback), name='api-get-rmforms'),
    re_path(r'^api/data/close-activity-add-answers', login_required(views_api.api_close_activity_add_answers), name='api-close-activity-add-answers'),
    #re_path(r'^api/data/get-a-rmform', login_required(views_api.api_get_a_rmform), name='api-get-a-rmform'),
    
    # JSON (db charts api)
    re_path(r'^api/data/dbcharts/(?P<chart_id>\d+)/(?P<category>.+)$',
        login_required(views_api.api_data_dbcharts),
        name='api-data-dbcharts'),
]
