#import bz2, os

# all the fields for the various views.
# NOTE, id is prepended to each list if required .
# ID,type,desc,ref,priority,assignee,creator,created,due,closed,cost, hrs,process label,state label
PAGE_FIELD_NAMES = {
    'activities': ['id', 'type', 'description', 'serialno', 'ref', 'priority', 'assignee', 'creator', 'created', 'due',
                   'closed', 'cost', 'hours', 'process', 'state', 'openedby', 'closedreason', 'nref', 'nresult'],
    'users': ['id', 'name', 'login', 'email', 'initials', 'type', 'admin', 'notify', 'begins', 'ends', 'notifyTime', 'who', 'date'],
    'groups': ['id', 'name', 'description', 'method', 'who', 'date'],
    'processes': ['id', 'label', 'description', 'serialno', 'entry', 'who', 'date'],
    'threads': ['id', 'type', 'description', 'serialno', 'ref', 'process', 'priority', 'creator', 'opened', 'closed', 'assigned', 'cost', 'hours']
}

ACTIVITY_CLOSE_FIELDS = PAGE_FIELD_NAMES['activities'] + ['state_id', 'thread_id', 'can_return']
ACTIVITY_CLOSE_FORM_FIELDS = ['id', 'pid', 'sid', 'uid', 'questions-count', 'label', 'description', 'date']
ACTIVITY_CLOSE_QUESTION_FIELDS = ['id', 'type', 'view_pos', 'question', 'columns', 'choices', 'mandatory', 'answer']

# form.id\tform.process\tform.state\tform.who\tform.questions\tlabel\tdesc\tform.date'\0'
# questions are sorted by view order.
# question part: question.id\tcontrolType\tquestion\tcolumns\tchoices\tmandatory\tanalyzer_fieldLength\tanalyzer_fieldName'\0'

# api_data_ve_details_get
VE_FORM_FIELD_NAMES = {
    'get-a-rmform': [ 'id', 'pid', 'sid', 'uid', 'questions-count', 'label', 'description', 'date', 
    ['question-rmid', 'type', 'thequestion', 'columns', 'choices', 'mandatory', 'fieldlength', 'fieldname'] ],
}


def extract_em_messages_result(result, fields):
    # convert result to an array of data
    all_bufs = result[0].get('buffer').decode('utf-8').split('\x00\x00')
    num_bufs = len(all_bufs) - 1
    records = []
    for buf_count in range(num_bufs):
        buf_records = all_bufs[buf_count].split('\x00')
        total = len(buf_records)
        for count in range(total):
            record = {}
            idx = 0
            for field_name in fields:
                try:
                    record[field_name] = buf_records[count].split('\t')[idx]
                    if field_name == 'id':
                        record[field_name] = int(record[field_name])
                except IndexError:
                    pass
                except ValueError:
                    continue

                idx += 1

            records.append(record)

    return records


def extract_enum_activity_result(result_arr):
  # activity details
  activity_arr = result_arr[0].split('\x00')[0]
  activity_details = {}
  idx = 0
  for field_value in activity_arr.split('\t'):
      activity_details[ACTIVITY_CLOSE_FIELDS[idx]] = field_value
      idx += 1
  
  # iterate over all this activites forms
  forms = []
  forms_arr = result_arr[0].split('\x00\x00')
  if len(forms_arr) > 1 and forms_arr[1] != '\x00':
    num_of_forms = len(forms_arr) - 1
  else:
    num_of_forms = len(forms_arr) - 2

  if num_of_forms < 1:
    # need to check if only one form as it will not have a double null split.
    single_forms_arr = result_arr[0].split('\x00')
    if len(single_forms_arr) > 1 and single_forms_arr[1] != '\x00' and single_forms_arr[1] != '':
      num_of_forms = 1

  if num_of_forms > 0:
    for outer_index, form_item in enumerate(forms_arr): 
      questions = []
      form_details = {}
      question_details = {}
      aform_arr = form_item.split('\x00')
      # first aform_arr item also has activity details, so skip via offset
      offset = 0
      if outer_index == 0:
        offset = 1

      # form details and its questions
      for index, form_contents in enumerate(aform_arr[offset:]):
        # first item is the form details
        if (index == 0):
          idx = 0
          for field_value in form_contents.split('\t'):
            form_details[ACTIVITY_CLOSE_FORM_FIELDS[idx]] = field_value
            idx += 1
        #elif index % 2 == 0:  # even index array item is the answer i.e 1,3,5... question_details i.e. 2,4,6... 
          #question_details['answer'] = form_contents    # this questions answer added to question_details
          #questions.append(question_details)            # append question_details to questions array
        #  if (index == len(aform_arr[offset:]) - 1):     # last item in aform_arr to be considered
        #    form_details['questions'] = questions        # attach all this forms questions to form details
        #    forms.append(form_details)                   # append current form  details to forms array
        else:
          # process each questions fields
          inner_idx = 0
          question_details = {}
          for field_value in form_contents.split('\t'):
            question_details[ACTIVITY_CLOSE_QUESTION_FIELDS[inner_idx]] = field_value
            inner_idx += 1

          questions.append(question_details)            # append question_details to questions array
      
      form_details['questions'] = questions        # attach all this forms questions to form details
      forms.append(form_details)                   # append current form  details to forms array

  # attach all forms to activity details
  activity_details['forms'] = forms
  return activity_details


def adjust_chart_id(chart_id: int, category: str):
    if category is not None and len(category) > 0 and category != '0':
        return chart_id+100
    else:
        return chart_id


def change_id_from_number_to_string_value(obj):
    for key, value in obj.items():
        if key == 'id' or key == 'to' or key == 'from':
            obj[key] = str(value)
