import re


def htmlify_options_part(options, default):
    content = ''
    options = options.strip('\"')    # remove ""
    opt_list = options.split(';')
    count = 1
    for opt in opt_list:
        if len(default) > 0 and count == int(default):
            content += '<option selected value="' + opt + '">' + opt + '</option>'
        else:
            content += '<option value="' + opt + '">' + opt + '</option>'

        count += 1
    
    return content
   

def htmlify_dialog_part(parts, keyword, is_quote_sep):
    """

    :param parts:
    :param keyword:
    :param is_quote_sep:
    :return:
    """
    content = ''
    start = parts.upper().find(keyword)
    if start > 0:
        start += len(keyword)
        if is_quote_sep:
            contents = re.findall(r'"([^"]*)"', parts[start:])
        else:
            contents = parts[start:].split()  #contents = re.findall(r'\\s([^\\s]*)\\s', parts[start:])

        if len(contents) > 0: content = contents[0]

    return content


def htmlify_dialog_fields(dialog_part, field):
    """

    :param dialog_part:
    :param field:
    :return:
    """
    #if dialog_part.upper().decode('utf-8').find('BUTTONSET ') == 0:
    #    return make_button(dialog_part)
    if dialog_part.upper().find('TEXT ') == 0:
        return make_label(dialog_part)
    elif dialog_part.upper().find('EDIT ') == 0:
        return make_edit(dialog_part, field)
    elif dialog_part.upper().find('BUTTONSET ') == 0:
        return make_buttonset(dialog_part, field)
    elif dialog_part.upper().find('CHECKBOX ') == 0:
        return make_checkbox(dialog_part, field)
    elif dialog_part.upper().find('DROPDOWN ') == 0:
        return make_dropdown(dialog_part, field)
    elif dialog_part.upper().find('RADIOBUTTON ') == 0:
        return make_radiobutton(dialog_part, field)
    elif dialog_part.upper().find('ITEM ') == 0:
        return make_item(dialog_part, field)


    return ''


# def make_button(dialog_part):
# TODO pass the text of OK and Cancel from analyzer to JQuery UI dialog
# to accomodate unicode chars /languages etc., use the open function
# of dialog to change text.
#     # BUTTONSET - (BUTTONSET TITLE "&OK;&Cancel" AT 370 12 DEFAULT 1 )
#     # extract TITLE/s - as it is a buttonset, can be multiple
#     title1 = "OK"
#     title2 = "Cancel"
#     # extract  AT
#     return '<button id="batch_btn" class="ui-button ui-widget ui-corner-all btn btn-block batch">'+title1+'</button>'

def make_buttonset(dialog_part, field):
    return ''


def make_label(dialog_part):
    """

    :param dialog_part:
    :return:
    """
    # LABEL - (TEXT TITLE "Email Message" AT 36 216 )
    title = htmlify_dialog_part(dialog_part, 'TITLE', True)
    x1, y1 = get_field_at(dialog_part)
    x = str(x1)
    y = str(y1)
    return '<label style="position: absolute;left: '+x+'px;top: '+y+'px;font-weight:normal;​" for="">'+title+'</label>'


def make_edit(dialog_part, field):
    """

    :param dialog_part:
    :param field:
    :return:
    """
    # EDIT - (EDIT TO "BATCH_EMAIL_MSG" AT 24 250 WIDTH 541 HEIGHT 222 CHAR )
    var_name = htmlify_dialog_part(dialog_part, 'TO', True)  # ''BATCH_EMAIL_MSG'
    x, y = get_field_at(dialog_part)                         # extract AT
    w = htmlify_dialog_part(dialog_part, 'WIDTH', False)     # extract WIDTH
    h = htmlify_dialog_part(dialog_part, 'HEIGHT', False)    # extract HEIGHT
    types = [ ['CHAR', 'text', 'C'], ['NUM', 'number', 'N'], ['DATE', 'date', 'D'] ]
    html_type = 'text'
    for dtype in types:
        t = htmlify_dialog_part(dialog_part, dtype[0], False)       # extract EDIT type.
        if len(t)>0:
            html_type = dtype[1]
            break
    
    widget = '<div>'
    if len(h) == 0 or t != 'CHAR':
        h = '28'
        widget = '<input style="position: absolute;left: '+x+'px;top: '+y+'px;width: '+w+'px;height: '+h+'px" ' + \
            'type="' + html_type + '" name="'+var_name+'" id="'+var_name + '" value="" class="text ui-widget-content ui-corner-all" />'
    elif t == 'CHAR':
        widget = '<textarea style="position: absolute;left: '+x+'px;top: '+y+'px;width: '+w+'px;height: '+h+'px;resize: none;"' + \
            'name="'+var_name+'" id="'+var_name+'" class="text ui-widget-content ui-corner-all"> </textarea>'

    widget += '</div>'
    field.append({'name': var_name, 'ftype': dtype[2]})
    return widget


def make_dropdown(dialog_part, field):
    # (DROPDOWN TITLE "dd1;fdfs;sdfds;dsf" TO "DROPDOWN1" AT 84 46 DEFAULT 2 )
    var_name = htmlify_dialog_part(dialog_part, 'TO', True)         # 'DROPDOWN1'
    x, y = get_field_at(dialog_part)                                # extract AT
    options = htmlify_dialog_part(dialog_part, 'TITLE', True)       # extract list
    default = htmlify_dialog_part(dialog_part, 'DEFAULT', False)    # extract DEFAULT value.
    widget = '<div>'
    widget += '<select style="position: absolute;left: '+x+'px;top: '+y+'px;" + name="'+var_name+'" id="'+var_name+'" class="text ui-widget-content ui-corner-all" >'
    widget += htmlify_options_part(options, default)
    widget += '</select>'
    widget += '</div>'
    field.append({'name': var_name, 'ftype': 'C'})
    return widget


def make_checkbox(dialog_part, field):
    # (CHECKBOX TITLE "foo" TO "CHECKBOX1" AT 48 131 ) (CHECKBOX TITLE "boo" TO "CHECKBOX2" AT 144 131 CHECKED )
    var_name = htmlify_dialog_part(dialog_part, 'TO ', True)         # ''BATCH_EMAIL_MSG'
    x, y = get_field_at(dialog_part)                                 # extract AT
    y = str(int(y) + 3)
    yy = str(int(y) + 4)
    xx = str(int(x) + 20)
    w = htmlify_dialog_part(dialog_part, 'WIDTH ', False)            # extract WIDTH
    h = htmlify_dialog_part(dialog_part, 'HEIGHT ', False)           # extract HEIGHT
    title = htmlify_dialog_part(dialog_part, 'TITLE', True)
    checked =  dialog_part.upper().find(' CHECKED')            
    
    # <input type="checkbox" id="scales" name="scales" checked />
    # <label for="scales">Scales</label>
    widget = '<div>'
    widget += '<input style="position: absolute;left: '+x+'px;top: '+y+'px;width: '+w+'px;height: '+h+'px;'
    widget += '" type="checkbox" name="'+var_name+'" id="'+var_name+'" class="text ui-widget-content ui-corner-all" '
    if checked > -1:  widget += 'checked'
    widget += ' />'
    widget += '<label style="position: absolute;left: '+xx+'px;top: '+yy+'px;width: '+w+'px;height: '+h+'px;'
    widget += '" for="'+var_name+'">'+title+'</label>'
    widget += '</div>'
    field.append({'name': var_name, 'ftype': 'L'})
    return widget


def make_radiobutton(dialog_part, field):
    # TODO does not support vertical layout.
    var_name = htmlify_dialog_part(dialog_part, 'TO ', True)         # ''BATCH_EMAIL_MSG'
    x, y = get_field_at(dialog_part)                                 # extract AT
    y = str(int(y) + 3)
    yy = str(int(y) + 4)
    w = htmlify_dialog_part(dialog_part, 'WIDTH ', False)            # extract WIDTH
    h = htmlify_dialog_part(dialog_part, 'HEIGHT ', False)           # extract HEIGHT
    options = htmlify_dialog_part(dialog_part, 'TITLE ', True)       # extract list
    default = htmlify_dialog_part(dialog_part, 'DEFAULT ', False)    # extract DEFAULT value.
    horz =  dialog_part.upper().find(' HORZ')                        # extract DEFAULT value.

    widget = '<div>'
    loop_count = 1
    default_int = 0
    if len(default) > 0:  default_int = int(default)
    for radio in options.split(';'):
        if horz == -1: widget += '<div>'    
        widget += '<input style="position: absolute;left: '+x+'px;top: '+y+'px;width: '+w+'px;height: '+h+'px;'
        if horz == -1: widget += 'display: block;'
        widget += '" type="radio" name="'+var_name+'" id="'+var_name+'_'+str(loop_count)+'" value="'+radio+'" class="text ui-widget-content ui-corner-all" '
        if loop_count == default_int:  widget += 'checked'
        widget += '/> '
        x = str(int(x) + 20)
        widget += '<label style="position: absolute;left: '+x+'px;top: '+yy+'px;width: '+w+'px;height: '+h+'px;'
        if horz == -1: widget += 'display: block;'
        widget += '" for="'+var_name+'_'+str(loop_count)+'">'+radio+'</label>'
        if horz == -1: widget += '</div>'    
        x = str(int(x) + 20)
        loop_count += 1

    widget += '</div>'
    field.append({'name': var_name, 'ftype': 'C'})
    return widget


def make_item(dialog_part, field):
    return ''


def get_field_at(dialog_part):
    """

    :param dialog_part:
    :return:
    """
    start = dialog_part.upper().find(' AT ')
    if start > 0:
        pos = start+len(' AT ')
        rest = dialog_part[pos:].split(' ')
        return rest[0], rest[1]

    return 0, 0


def get_index(strings, substr):
    for idx, string in enumerate(strings):
        if substr in string:
            break
    return idx


def create_batch_dialog(result_packet):
    """

    :param result_packet:
    :return:
    """

    html_dialog_field_part = {}
    buffer = result_packet.get('buffer', (b'',))
    sched_start = buffer.upper().decode('utf-8').find('SCHEDULE START')
    sched_end = buffer.upper().decode('utf-8').find('SCHEDULE END')
    if sched_start >= 0:  # assumes only one dialog and the SCHEDULE START and SCHEDULE END in first buffer!
        sched_buffer = buffer[sched_start:sched_end]
        # TODO strip out all COMMENTS
        dialog_start = sched_buffer.upper().decode('utf-8').find('DIALOG')
        all_dialg_parts = re.findall(r"\((.*?)\)", sched_buffer[dialog_start:].decode('utf-8'))
        if len(all_dialg_parts) > 0:
            di = get_index(all_dialg_parts, 'DIALOG')
            html_dialog_field_part['title'] = htmlify_dialog_part(all_dialg_parts[di], 'TITLE', True)
            html_dialog_field_part['width'] = htmlify_dialog_part(all_dialg_parts[di], 'WIDTH', False)
            html_dialog_field_part['height'] = htmlify_dialog_part(all_dialg_parts[di], 'HEIGHT', False)
            html_dialog_field_part['field'] = []

            html_dialog_field_part['html_part'] = ''
            html_dialog_field_part['html_part'] += '<form>'
            html_dialog_field_part['html_part'] += '<fieldset>'

            for dialog_part in all_dialg_parts[1:]:
                html_dialog_field_part['html_part'] += htmlify_dialog_fields(
                    dialog_part,
                    html_dialog_field_part['field']
                )

            html_dialog_field_part['html_part'] += '</fieldset>'
            html_dialog_field_part['html_part'] += '</form>'

    return html_dialog_field_part
