import struct


from .constants import (
    CLU_OPENFILE, CLU_CLOSEFILE, FILE_READ_BINARY,
    REPLY_SUCCESS, WRITE_BUFFER_SIZE
)
from .network import get_reply
from .dialog_builder import create_batch_dialog


def build_asi_packet_open_file(batch_info):
    """

    :param batch_info:
    :return:
    """
    # build buffer
    buf = b''
    batch_name = batch_info.path.encode() + b'\\' + batch_info.name.encode() + b'.pro'
    buf += batch_name
    buf += b'\000'
    buf += b'r'
    buf += b'\000'
    buf += str(0).encode()
    buf += b'\000'
    buf += str(0).encode()
    buf += b'\000'
    # build packet header
    buflen = len(buf)
    pacsize = buflen
    server = 2  # TODO
    flags = 0
    cmd_type = CLU_OPENFILE
    data_size = buflen
    dest_srce = 0
    str_fmt = '>HBBHHI%ds' % buflen
    return struct.pack(
        str_fmt, pacsize, server, flags, cmd_type,
        data_size, dest_srce, buf)


def build_asi_packet_read_file(result_packet):
    """

    :param result_packet:
    :return:
    """
    buffer = str(WRITE_BUFFER_SIZE).encode()
    buffer += b'\000'
    buffer += result_packet.get('buffer', (b'',))
    pacsize = result_packet.get('pacsize', 0)
    server = result_packet.get('server', 0)   # TODO
    flags = result_packet.get('flags', 0)
    cmd_type = FILE_READ_BINARY
    data_size = result_packet.get('data_size', 0)
    dest_srce = result_packet.get('dest_srce', 0)
    str_fmt = '>HBBHHI%ds' % pacsize
    return struct.pack(
        str_fmt, pacsize, server, flags, cmd_type,
        data_size, dest_srce, buffer)


def build_asi_packet_close_file(result_packet):
    """

    :param result_packet:
    :return:
    """
    buffer = b''
    pacsize = 0
    server = result_packet.get('server', 0)   # TODO
    flags = 0
    cmd_type = CLU_CLOSEFILE
    data_size = 0
    dest_srce = result_packet.get('dest_srce', 0)
    str_fmt = '>HBBHHI%ds' % pacsize
    return struct.pack(
        str_fmt, pacsize, server, flags, cmd_type,
        data_size, dest_srce, buffer)


def parse_batch_file(server_socket, batch_info_id):
    """

    :param server_socket:
    :param batch_info_id:
    :return:
    """

    # open file
    return_result = None
    send_packet = build_asi_packet_open_file(batch_info_id)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    # read file
    if result.get('cmd_type') == REPLY_SUCCESS:
        send_packet = build_asi_packet_read_file(result)
        server_socket.send(send_packet)
        result = get_reply(server_socket)
        return_result = create_batch_dialog(result)
        if len(return_result) < 1:
            return_result = None
        # close file
        send_packet = build_asi_packet_close_file(result)
        server_socket.send(send_packet)
        # NO reply!!! result = get_reply(server_socket)
        return return_result


def parse_batch_comment(server_socket, batch_info_id):
    """
    NOTE: exactly the same as parse_batch_file, except
    we call read batch comments instead of calling create_batch_dialog(result)
    :param server_socket:
    :param batch_info_id:
    :return:
    """
    # open file
    return_result = None
    send_packet = build_asi_packet_open_file(batch_info_id)
    server_socket.send(send_packet)
    result = get_reply(server_socket)
    # read file
    if result.get('cmd_type') == REPLY_SUCCESS:
        send_packet = build_asi_packet_read_file(result)
        server_socket.send(send_packet)
        result = get_reply(server_socket)
        return_result = read_batch_comment(result)
        # close file
        send_packet = build_asi_packet_close_file(result)
        server_socket.send(send_packet)
        # NO reply!!! result = get_reply(server_socket)
        return return_result


def read_batch_comment(result_packet):
    """
    TODO extract comments from top of batch
    :param result_packet:
    :return:
    """
    comment = ""
    buffer_str = result_packet.get('buffer', (b'',)).decode("utf-8")
    buffer_lines = buffer_str.split("\r\n")
    if len(buffer_lines) > 0 and buffer_lines[0].strip().find("*") == 0:
        # we have at least 1 line of comment
        comment = buffer_lines[0][1:]
        # get rest of comment lines if any
        line_num = 1
        while len(buffer_lines[line_num]) > 0 and buffer_lines[line_num][0] == "*":
            line = buffer_lines[line_num][1:]
            # restore removed newlines
            if len(line) == 0:
                line = '\r\n'

            line += '\r\n'
            line_num += 1
            comment += line

    return comment
