
from ..helpers import (
    build_asi_cmd_type_packet, get_reply, show_data_tables
)
from .constants import CLU_CMD_SHARED_DIR


def do_server_folder(server_socket, username, folder_path, folder_name):
    """

    :param server_socket:
    :param username:
    :param folder_path:
    :param folder_name:
    :return:
    """
    raw_buf = folder_path.encode()
    raw_buf += b'\000'
    raw_buf += username.encode()
    raw_buf += b'\000'
    raw_buf += b'.awf'  # b'.xlsx,'
    raw_buf += b'\000'
    print(raw_buf)
    send_packet = build_asi_cmd_type_packet(raw_buf, CLU_CMD_SHARED_DIR)
    server_socket.send(send_packet)
    return process_server_folder(get_reply(server_socket), folder_name)


def process_server_folder(asipacket, folder_name):
    """

    :param asipacket:
    :param folder_name:
    :return:
    """
    buffer = asipacket.get('buffer', None)
    if buffer is None:
        return None

    # iterate over buffer and place each entry into dictionary of values
    entries = []
    start_pos = 10
    i = 0
    have_buffer = True
    last_fullpath = ''
    while have_buffer:
        end_pos = buffer.find(b'\x00', start_pos)
        if end_pos == -1:
            have_buffer = False
        entry = buffer[start_pos:end_pos]

        # extract parts from each entry
        entry_parts = {'tree_id': folder_name + '_' + str(i)}
        i += 1
        start_entry = 1
        is_workflow = False
        for entry_key in ['path', 'filename', 'type', 'reclen', 'joined', 'hasrel', 'ref_type', 'profile_name']:
            inc_end = 1
            if entry_key == 'filename':
                entry_end1 = entry.find(b'.pro",', start_entry)
                entry_end2 = entry.find(b'.fmt",', start_entry)
                entry_end3 = entry.find(b'.awf",', start_entry)
                if entry_end1 < 0 and entry_end2 < 0 and entry_end3 < 0:
                    entry_end = -1
                elif entry_end1 > 0:
                    entry_end = entry_end1
                elif entry_end2 > 0:
                    entry_end = entry_end2
                else:
                    entry_end = entry_end3
                    is_workflow = True

                if entry_end == -1:
                    entry_end = entry.find(b',', start_entry)
                else:
                    inc_end = 6
            else:
                entry_end = entry.find(b',', start_entry)

            value = entry[start_entry:entry_end].decode('utf-8').strip('\"')
            
            # recent change on hub server side, where a '*' value used to 
            # indicates that a previous path has the full path.
            
            #for aentry in reversed(entries):
            #    if aentry['path'] != '*':
            #        value = aentry['path'] 
            if entry_key == 'path':
                if value != '*':
                    last_fullpath = value
                else:
                    value = last_fullpath

            # special case for workflow, make it an upper 'B' 
            # still treat it is an asi batch 'b' but can still determine
            # if it is workflow later on.
            if entry_key == 'type' and is_workflow: # and value == 'b' 
                entry_parts[entry_key] = 'B' 
            else:
                entry_parts[entry_key] = value

            start_entry = entry_end + inc_end

        entry_parts['profile_index'] = entry[start_entry:]
        if is_valid_webconnect_file_type(entry_parts.get('type', '').lower()):
            entries.append(entry_parts)
            
        start_pos = end_pos+1

    return entries


def is_valid_webconnect_file_type(entry_parts_type):
    if ( entry_parts_type == 'b' or entry_parts_type == 'd' or entry_parts_type == 's' or 
    (entry_parts_type == 'f' and show_data_tables()) ):
        return True

    return False
