
from .models import UserProfile, SharedFolder, ServerProfile


def save_user_profile(username):
    try:
        user_profile = UserProfile.objects.get(username__iexact=username)
    except UserProfile.DoesNotExist:
        user_profile = UserProfile(username=username)

    # user_profile must be saved before M2M set can be called.
    user_profile.save()

    # Only required for new users BUT as it is a set should not do anything if existing user
    # as these would have already been assigned.
    # check for default shared folders and add to user profile
    user_profile.sharedfolder_set.add(*list(SharedFolder.objects.filter(default=True)))
    # add webapp_server to authenticating user profile
    user_profile.serverprofile_set.add(ServerProfile.objects.get(webapp_server=True))

    return user_profile
