from django import forms
from django.forms import ModelForm, PasswordInput

from crispy_forms.helper import FormHelper
from crispy_forms.layout import Submit, Layout, Field, HTML

from common.constants import PASSLEN

from .models import ODBCProfile
from .helpers import encrypt_password


class LoginForm(forms.Form):
    username = forms.CharField(label="Username", required=True)
    password = forms.CharField(
        label="Password",
        required=True,
        widget=forms.PasswordInput)
    # remember = forms.BooleanField(label="Remember Me?")

    helper = FormHelper()
    helper.form_method = 'POST'
    helper.form_class = 'form-signin'
    helper.layout = Layout(
        HTML('<div class="form-signin-heading">Welcome!</div>'),
        Field('username', id="username-field", css_class="form-control login-input", title="Username"),
        Field('password', id="password-field", css_class="form-control login-input", title="Password")
    )
    helper.add_input(Submit('login', 'Log in', css_class='btn login-btn'))


class SuccessForm(forms.Form):
    pass

    #helper = FormHelper()
    #helper.form_method = 'POST'
    # <li><a href="/result_manager/logout">Logout</a></li>
    #helper.add_input(Submit('logout', 'Log out', css_class=''))


class ODBCProfileForm(ModelForm):

    class Meta:
        model = ODBCProfile
        widgets = {
            'db_password': PasswordInput(),
        }
        exclude = ()

    def save(self, commit=True):
        odbcProfile = super(ODBCProfileForm, self).save(commit=False)
        db_password = self.cleaned_data["db_password"]
        asi_encrypted_password = encrypt_password(db_password)
        passlen = PASSLEN + 1
        odbcProfile.db_password = asi_encrypted_password.raw[:passlen].hex().upper()

        if commit:
            odbcProfile.save()

        return odbcProfile
