# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-03-14 19:56
#from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import schedule.fields


class Migration(migrations.Migration):

    dependencies = [
        ('schedule', '0026_remove_globalconfig_active'),
    ]

    operations = [
        migrations.AddField(
            model_name='variabledescription',
            name='column_title',
            field=models.CharField(default='', help_text='Descriptive title for column referenced on the batch form', max_length=128),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='globalconfig',
            name='logo',
            field=models.ImageField(blank=True, help_text='Company logo', upload_to=''),
        ),
        migrations.AlterField(
            model_name='globalconfig',
            name='user_prepended_prefix',
            field=models.CharField(blank='True', help_text='Folder location on Arbutus Server that can contain all users private folders', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serverprofile',
            name='host_name',
            field=models.CharField(help_text='Network hostname or IP', max_length=256),
        ),
        migrations.AlterField(
            model_name='serverprofile',
            name='name',
            field=models.CharField(help_text='Name of Arbutus server', max_length=256),
        ),
        migrations.AlterField(
            model_name='serverprofile',
            name='port',
            field=models.IntegerField(help_text='Port Arbutus server is listening on'),
        ),
        migrations.AlterField(
            model_name='serverprofile',
            name='server_type',
            field=models.IntegerField(choices=[(0, 'MVS'), (1, 'Windows'), (2, 'Linux'), (3, 'AS400'), (4, 'Local')], default=1, help_text='Arbutus server platform type'),
        ),
        migrations.AlterField(
            model_name='serverprofile',
            name='users',
            field=models.ManyToManyField(help_text='All users that will use this server profile.', to='schedule.UserProfile'),
        ),
        migrations.AlterField(
            model_name='serverprofile',
            name='webapp_server',
            field=schedule.fields.OneTrueBooleanField(default=False, help_text='Arbutus server used by WebConnect.'),
        ),
        migrations.AlterField(
            model_name='sharedfolder',
            name='default',
            field=models.BooleanField(default=False, help_text='Common shared folder for ALL users.'),
        ),
        migrations.AlterField(
            model_name='sharedfolder',
            name='name',
            field=models.CharField(help_text='Shared folder name', max_length=256),
        ),
        migrations.AlterField(
            model_name='sharedfolder',
            name='path',
            field=models.CharField(help_text='Folder location of shared folder on Arbutus server', max_length=1024),
        ),
        migrations.AlterField(
            model_name='sharedfolder',
            name='server_profile',
            field=models.ForeignKey(help_text='Server location of this shared folder', on_delete=django.db.models.deletion.CASCADE, to='schedule.ServerProfile'),
        ),
        migrations.AlterField(
            model_name='sharedfolder',
            name='users',
            field=models.ManyToManyField(help_text='All users that have access to this shared folder.', to='schedule.UserProfile'),
        ),
        migrations.AlterField(
            model_name='userprofile',
            name='prefix',
            field=models.CharField(blank=True, help_text='Users private folder on Arbutus server.', max_length=1024),
        ),
        migrations.AlterField(
            model_name='variabledescription',
            name='batches',
            field=models.CharField(blank=True, help_text='Comma separated list of batch names that will use this variable. If empty, used by all.', max_length=4096),
        ),
        migrations.AlterField(
            model_name='variabledescription',
            name='column_description',
            field=models.CharField(help_text='Variable column name as referenced in batch', max_length=128),
        ),
        migrations.AlterField(
            model_name='variabledescription',
            name='user_editable',
            field=models.BooleanField(default=True, help_text='User can edit the value of this variable'),
        ),
        migrations.AlterField(
            model_name='variabledescription',
            name='user_viewable',
            field=models.BooleanField(default=True, help_text='User can view the value of this variable'),
        ),
    ]
