# Generated by Django 4.2.3 on 2023-08-21 23:16

from django.db import migrations, models
import django.db.models.deletion
import schedule.fields


class Migration(migrations.Migration):

    dependencies = [
        ('schedule', '0044_auto_20211118_0946'),
    ]

    operations = [
        migrations.AlterField(
            model_name='globalconfig',
            name='user_prepended_prefix',
            field=models.CharField(blank='True', help_text='Folder location on Arbutus hub server that can contain all users private folders', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serverprofile',
            name='name',
            field=models.CharField(help_text='Name of Arbutus hub server', max_length=256),
        ),
        migrations.AlterField(
            model_name='serverprofile',
            name='port',
            field=models.IntegerField(help_text='Port Arbutus hub server is listening on'),
        ),
        migrations.AlterField(
            model_name='serverprofile',
            name='server_type',
            field=models.IntegerField(choices=[(0, 'MVS'), (1, 'Windows'), (2, 'Linux'), (3, 'AS400'), (4, 'Local')], default=1, help_text='Arbutus hub server platform type'),
        ),
        migrations.AlterField(
            model_name='serverprofile',
            name='users',
            field=models.ManyToManyField(help_text='All users that will use this Arbutus hub server profile.', to='schedule.userprofile'),
        ),
        migrations.AlterField(
            model_name='serverprofile',
            name='webapp_server',
            field=schedule.fields.OneTrueBooleanField(default=False, help_text='Arbutus hub server used by WebConnect.'),
        ),
        migrations.AlterField(
            model_name='sharedfolder',
            name='path',
            field=models.CharField(help_text='Folder location of shared folder on Arbutus hub server', max_length=1024),
        ),
        migrations.AlterField(
            model_name='sharedfolder',
            name='server_profile',
            field=models.ForeignKey(help_text='Arbutus hub server location of this shared folder', on_delete=django.db.models.deletion.CASCADE, to='schedule.serverprofile'),
        ),
        migrations.AlterField(
            model_name='userprofile',
            name='prefix',
            field=models.CharField(blank=True, help_text='Users private folder on Arbutus hub server.', max_length=1024),
        ),
    ]
