/**
 * Created by luke_duguid on 28/07/2016.
 */

// wrap page variables in 'ArbutusSchedule' namespace to limit global name pollution.

let ArbutusSchedule = {
  batchid: undefined,
  tableid: undefined,
  filenodeid: undefined,
  fileparentnodeid: undefined,
  filename: undefined,
};

// Global event handler for getTextWidth and onScroll (grid table body)

/**
 * Uses canvas.measureText to compute and return the width of the given text of given font in pixels.
 *
 * @param {String} text The text to be rendered.
 * @param {String} font The css font descriptor that text is to be rendered with (e.g. "bold 14px verdana").
 *
 * @see http://stackoverflow.com/questions/118241/calculate-text-width-with-javascript/21015393#21015393
 * */

function getTextWidth(text, font) {
  // re-use canvas object for better performance
  let canvas =
    getTextWidth.canvas ||
    (getTextWidth.canvas = document.createElement("canvas"));
  let context = canvas.getContext("2d");
  context.font = font;
  let metrics = context.measureText(text);
  return metrics.width;
}

//  document loaded
$(document).ready(function () {
  // using jQuery csrf guff

  function getCookie(name) {
    let cookieValue = null;
    if (document.cookie && document.cookie != "") {
      let cookies = document.cookie.split(";");
      for (let i = 0; i < cookies.length; i++) {
        let cookie = jQuery.trim(cookies[i]);
        // Does this cookie string begin with the name we want?
        if (cookie.substring(0, name.length + 1) == name + "=") {
          cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
          break;
        }
      }
    }

    return cookieValue;
  }

  let csrftoken = getCookie("csrftoken");

  function csrfSafeMethod(method) {
    // these HTTP methods do not require CSRF protection
    return /^(GET|HEAD|OPTIONS|TRACE)$/.test(method);
  }

  $.ajaxSetup({
    crossDomain: false, // obviates need for sameOrigin test
    beforeSend: function (xhr, settings) {
      if (!csrfSafeMethod(settings.type)) {
        xhr.setRequestHeader("X-CSRFToken", csrftoken);
      }
    },
  });

  //////////////////////////////////////////////////////////////////////////

  // initialize some DOM state on page loaded.

  $("#batch_btn").prop("disabled", true);
  $("#batch_btn").hide();
  $(".status-symbol").hide();

  // general helper functions

  /*
     function isEmail(email) {
        var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
        return regex.test(email);
    }
    */

  function run_batch_success(resp) {
    // update various UI widgets based on success of batch running
    // NOTE: success is at a AJAX level, resp should be processed
    // to determine result success or not (TODO)
    let filename_label = ArbutusSchedule.filename;
    let status_label = "Submitted";
    let message_label =
      "Your document is already in progress, check your results in a few minutes. <br> Thanks for your patience.";
    $("#filename-label").html(filename_label);
    $("#status-label").html(status_label);
    $("#message-label").html(message_label);
    $(".status-symbol").show();
    $("#batch_status_text").show();

    // deselect current run batch and select its parent folder
    $("#jstree_div").jstree("deselect_node", ArbutusSchedule.filenodeid);
    $("#jstree_div").jstree("select_node", ArbutusSchedule.fileparentnodeid);
    // TODO handle response in UI
    let data = resp.process_data;
  }

  function run_batch_app_error(resp) {
    // check for error_msg
    if (resp.app_error != null) {
      let html_error = "<h3>" + resp.app_error + "</h3>";
      $("#render_data").html(html_error);
      // no need to continue if app error
      return true;
    }

    return false;
  }

  ///////////////////////////////////////////////////////////////////////////////

  let isDateField = [];
  let exportFlag = false;
  let nonReordableColumn;

  function save_grid_options(grid_column_options) {
    $.ajax({
      type: "post",
      url: "/webconnect/grid_table_data/",
      dataType: "json",
      data: {
        table_id: ArbutusSchedule.tableid,
        grid_options: JSON.stringify({
          grid_column_options: grid_column_options,
        }),
      },
      cache: false,
      success: function (result) {
        if (
          result.saved_ok === true //console.log("grid options saved on web app server OK");
        );
        else console.log("grid options NOT saved on web app server!");
      },
    });
  }

  function generateGrid(response, table_id, filename) {
    let model = generateModel(response);
    let columns = generateColumns(response);
    // need a filler Column to allow for spacing of last column when all
    // column width less than the grids column area width.
    columns.push({ field: "fillerColumn", title: " " });

    let grid = $("#grid")
      .kendoGrid({
        toolbar: kendo.template($("#grid-toolbar-template").html()),
        excel: {
          allPages: true,
        },
        columns: columns,
        dataSource: {
          transport: {
            read: {
              //async: false,
              url: "/webconnect/grid_table_data/",
              type: "get",
              dataType: "json",
              data: {
                table_id: ArbutusSchedule.tableid,
              },
            },
          },
          change: function (e) {
            $("#total-records").text(e.sender._total);
            $("span#object-name.k-label").text(filename);
          },
          /*
                error: function (xhr, error) {
                    console.debug(xhr);
                    console.debug(error);
                },
                */
          schema: {
            model: model,
            data: "data",
            pageSize: "pageSize",
            total: "total",
          },
          pageSize: 300,
          serverPaging: true,
        },
        /* grid in firefox show incorrect rows when last row displayed
            pageable: {
                info: true,
                previousNext: false,
                numeric: false,
                messages: {
                    display: "{2} Records"
                }
            },*/
        //scrollable: {
        //  virtual: false,
        //},
        scrollable: true,
        pageable: true,
        resizable: true,
        columnResize: function (e) {
          //console.log(e.column.field, e.newWidth, e.oldWidth);
          save_grid_options(grid.getOptions().columns);
        },
        /*
            columnResize: function(e) {
                //console.log(e.column.field, e.newWidth, e.oldWidth);
                if (e.column.field == "fillerColumn") {
                  e.preventDefault();
                  setTimeout(function(){
                    e.sender.wrapper.removeClass("k-grid-column-resizing");
                    $(document.body).add(".k-grid th").css("cursor", "");
                  });
                }
            },
            */
        reorderable: true,
        columnReorder: function (e) {
          //console.log(e.column.field, e.newIndex, e.oldIndex);
          // if last column non-reordable (empty) and
          // it is moved, put it back in place.
          let grid = e.sender;
          setTimeout(function (e) {
            grid.reorderColumn(columns.length - 1, nonReordableColumn);
            save_grid_options(grid.getOptions().columns);
          }, 1);
        },
        excelExport: function (e) {
          e.workbook.fileName = ArbutusSchedule.filename + ".xlsx";

          // hide fillerColumn
          if (!exportFlag) {
            e.sender.hideColumn(columns.length - 1);
            e.preventDefault();
            exportFlag = true;
            setTimeout(function () {
              e.sender.saveAsExcel();
            });
          } else {
            e.sender.showColumn(1);
            exportFlag = false;
          }
        },
        dataBound: function (e) {
          nonReordableColumn = e.sender.columns[columns.length - 1];
          /*
                window.setTimeout(function(){
                    var ht=0;
                    var maxht=0;
                    jQuery('#grid').find("tr[role='row']").each(function(){
                        ht=parseInt($(this).height());
                        if (ht > maxht)
                            maxht = ht;
                    });
                    // ht - total rows height
                    //jQuery("#grid").find(".k-scrollbar-vertical").find("div").height(ht);     /// set kendo scrollbar height to ht
                    console.log(maxht);
                } ,1000);
                */
        }, //databound ends
      })
      .data("kendoGrid");

    grid.resizable.bind("start", function (e) {
      if ($(e.currentTarget).data("th").data("field") == "fillerColumn") {
        e.preventDefault();
        setTimeout(function () {
          grid.wrapper.removeClass("k-grid-column-resizing");
          $(document.body).add(".k-grid th").css("cursor", "");
        });
      }
    });

    if (response["grid_options"]) {
      let grid_options = JSON.parse(response["grid_options"]);
      grid.setOptions({ columns: grid_options.grid_column_options });
    }
  }

  /*
  function resizeGrid() {
    gridElement = $("#grid");

    gridElement.data("kendoGrid").resize();
  
    var newHeight = gridElement.height();

    var headerHeight = $(".k-grid-header").height();
    var pagerHeight = $(".k-grid-pager").height();
    var rowHeight = $("#grid tr:last").height();

    var numberOfRows = Math.round((newHeight - headerHeight - pagerHeight) / rowHeight);

    gridElement.data("kendoGrid").dataSource.pageSize(numberOfRows);
    gridElement.data("kendoGrid").refresh();
  }

  $(window).resize(function() {
    resizeGrid(); // resize when browser windoe resized as well.
  });
  */
 
  function generateColumns(response) {
    let columnNames = response["columns"];
    //var rowLen = columnNames.length;

    return columnNames.map(function (column, i) {
      let name = column["field"];
      let title = column["title"];
      let ctype = column["ctype"];
      let font_0_width = getTextWidth("0", "normal 14px Helvetica Neue") * 1.4; // 1.4 fudge factor
      let pixel_width = 0;

      if (title.length > column["width"])
        pixel_width = font_0_width * (title.length + 1);
      else pixel_width = (column["width"] + 1) * font_0_width;

      pixel_width = Math.ceil(pixel_width); // round off to higher integer

      let format = "";
      if (ctype === "D" && isDateField[name]) {
        format = "{0:D}";
      }

      if (ctype === "N") {
        return {
          field: name,
          title: title,
          width: pixel_width,
          format: format,
          attributes: { class: "number-cell" },
          headerAttributes: {
            class: "table-header-cell",
            style: "text-align: right;",
          },
        };
      } else {
        return {
          field: name,
          title: title,
          width: pixel_width,
          format: format,
        };
      }
    });
  }

  function generateModel(response) {
    let sampleDataItem = response["data"][0];
    let model = {};
    let fields = {};

    for (let property in sampleDataItem) {
      if (property.indexOf("ID") !== -1) {
        model["id"] = property;
      }

      let propType = typeof sampleDataItem[property];
      if (propType === "number") {
        fields[property] = {
          type: "number",
          validation: {
            required: true,
          },
        };
        if (model.id === property) {
          fields[property].editable = false;
          fields[property].validation.required = false;
        }
      } else if (propType === "boolean") {
        fields[property] = {
          type: "boolean",
        };
      } else if (propType === "string") {
        let parsedDate = kendo.parseDate(sampleDataItem[property]);
        if (parsedDate) {
          fields[property] = {
            type: "date",
            validation: {
              required: true,
            },
          };
          isDateField[property] = true;
        } else {
          fields[property] = {
            validation: {
              required: true,
            },
          };
        }
      } else {
        fields[property] = {
          validation: {
            required: true,
          },
        };
      }
    }

    model.fields = fields;
    return model;
  }

  function new_grid() {
    $.ajax({
      type: "GET",
      url: "/webconnect/grid_table_data/",
      dataType: "json",
      data: {
        table_id: ArbutusSchedule.tableid,
      },
      cache: false,
      success: function (result) {
        $("#render_data").html('<div id="grid"></div>');

        $("#batch_btn").hide();
        $("#batch_status_text").hide();
        $(".status-symbol").hide();
        $(".user_var_form_container").show();

        let grid = $("#grid").data("kendoGrid");
        if (grid)
          // TODO reuse by setOptions?
          grid.destroy();

        generateGrid(result, ArbutusSchedule.tableid, ArbutusSchedule.filename);
      },
    });
  }

  ////////////////////////////////////////////////////////////////////////////////
  // event handlers for 'Run' button click

  $("#batch_btn").click(function () {
    /*
        // get and check email
        email_address=$("#id_email").val();
        if (!isEmail(email_address)) {
            alert("Please enter a valid email address!")
            return;
        }
        */

    $("#batch_btn").prop("disabled", true);

    $.ajax({
      url: "/webconnect/process/",
      type: "GET",
      data: { batch_id: ArbutusSchedule.batchid },
      cache: false,
      dataType: "json",
      success: function (resp) {
        run_batch_app_error(resp);

        // get uservars input ids and values
        let uservar_form_data = {};
        $("#user_vars input[id]")
          .map(function () {
            return (uservar_form_data[this.id] = $("#" + this.id).val());
          })
          .get();

        let dialog_form_data = {};
        if (resp.dialog_data != null) {
          // TODO extract all the dialog data so we can
          let dd = resp.dialog_data;
          let adjusted_width = Math.round(parseInt(dd.width) + parseInt(dd.width) * 0.15);
          let adjusted_height = Math.round(parseInt(dd.height) + parseInt(dd.height) * 0.15);
          //let px_width = adjusted_width.toString() + "px";
          //let px_height = adjusted_height.toString() + "px";
          //  dynamically create it
          $('<div id="#batch_dialog"> </div>')
            .dialog({
              modal: true,
              title: dd.title,
              minHeight: dd.height * 2,
              height: adjusted_height * 2, 
              minWidth: dd.width,
              width: adjusted_width,

              open: function () {
                //var markup = 'Content of dynamic dialog goes here';
                $(this).html(dd.html_part);
              },
              close: function () {
                $("#batch_btn").prop("disabled", false);
              },
              buttons: [
                {
                  text: "Ok",
                  width: 75,
                  class: "",
                  click: function () {
                    // extract form values from DOM by looping over dialog form fields
                    for (i = 0; i < dd.field.length; i++) {
                      let field = dd.field[i];
                      let field_name = field['name'];
                      let field_type = field['ftype'];
                      let field_id = "#" + field_name;
                      if ($(field_id).length > 0) {
                        if (field_type === 'L') {
                          // if a 'L' field type, for now assume checkbox.
                          let val = 'F';
                          if ($(field_id).is(':checked')) {
                            val = 'T';  
                          }

                          dialog_form_data[field_name] = {'value': val, 'ftype': field_type};
                        }
                        else {
                          dialog_form_data[field_name] = {'value': $("#" + field_name).val(), 'ftype': field_type};
                        }
                      } else {
                        // try radio button
                        dialog_form_data[field_name] = {'value': $("input[name='"+field_name+"']:checked").val(), 'ftype': field_type };
                      }
                    }

                    //$.post('/schedule/process/', {batch_id: batchid}, function (form, data) {
                    $.ajax({
                      url: "/webconnect/process/",
                      type: "POST",
                      data: {
                        batch_id: ArbutusSchedule.batchid,
                        dialog_form_data: JSON.stringify(dialog_form_data),
                        uservar_form_data: JSON.stringify(uservar_form_data),
                      },
                      cache: false,
                      dataType: "json",
                      success: function (resp) {
                        if (run_batch_app_error(resp) == false) {
                          run_batch_success(resp);
                        }
                      },
                    });
                    $(this).dialog("close");
                    $(this).dialog("destroy");
                    //$("#batch_btn").prop("disabled", false);
                  },
                },
                {
                  text: "Cancel",
                  width: 75,
                  class: "",
                  click: function () {
                    $(this).dialog("close");
                    $(this).dialog("destroy");
                    $("#batch_btn").prop("disabled", false);
                  },
                },
              ],
            })
            .css("font-size", "12px"); //end confirm dialog
        } else {
          $.ajax({
            url: "/webconnect/process/",
            type: "POST",
            data: {
              batch_id: ArbutusSchedule.batchid,
              dialog_form_data: JSON.stringify(dialog_form_data),
              uservar_form_data: JSON.stringify(uservar_form_data),
            },
            cache: false,
            dataType: "json",
            success: function (resp) {
              if (run_batch_app_error(resp) == false) {
                run_batch_success(resp);
              }
            },
          });
        }
      },
    });
  });

  // jstree TODO, remove instantiated on login page

  $(".search-input").keyup(function () {
    let searchString = $(this).val();
    $("#jstree_div").jstree("search", searchString);
  });

  $("#jstree_div") // listen for event
    .on("changed.jstree", function (e, data) {
      let i,
        j,
        r = [];
      //for (i = 0, j = data.selected.length; i < j; i++) {
      //    r.push(data.instance.get_node(data.selected[i]).text);
      //}
      let node = data.instance.get_node(data.selected[0]);
      if (
        node &&
        (node.li_attr.hasOwnProperty("data-batch-id") ||
          node.li_attr.hasOwnProperty("data-table-id"))
      ) {
        ArbutusSchedule.filenodeid = node.id;
        ArbutusSchedule.fileparentnodeid = $("#jstree_div").jstree(
          "get_parent",
          node.id
        );
        ArbutusSchedule.filename = node.text;

        if (node.li_attr.hasOwnProperty("data-batch-id")) {
          $("#batch_status_text").hide(); // hide batch run badge & show if run
          $(".status-symbol").hide();
          $("#batch_btn").prop("disabled", false);

          ArbutusSchedule.batchid = node.li_attr["data-batch-id"];
          ArbutusSchedule.tableid = undefined;

          // render user var form
          $.ajax({
            url: "/webconnect/render_user_var_form/",
            type: "GET",
            data: { batch_id: ArbutusSchedule.batchid },
            cache: false,
            //dataType: "json",
            success: function (resp) {
              // TODO handle response in UI
              $("#render_data").html(resp);
              $("#batch_btn").show();
              $("#batch-name").show();
              $("#batch-name").text(node.text);
              $(".user_var_form_container").show();
            },
          });
        } else if (node.li_attr.hasOwnProperty("data-table-id")) {
          $("#batch_btn").prop("disabled", true);
          $("#batch-name").text("");
          $("#batch-name").hide();

          ArbutusSchedule.tableid = node.li_attr["data-table-id"];
          ArbutusSchedule.batchid = undefined;
          new_grid();
        }
      } else {
        $("#batch_btn").prop("disabled", true);
        $("#batch_btn").hide();
        $("#batch-name").text("");
        $("#batch-name").hide();
        $(".user_var_form_container").hide();
      }
    })
    .on("open_node.jstree", function (evt, data) {
      if ( !data.node.li_attr.hasOwnProperty('class') ) // && !data.node.li_attr.class.includes("script-node") )
        data.instance.set_icon(data.node, tree_ofolder_url);
    })
    .on("close_node.jstree", function (evt, data) {
      if ( !data.node.li_attr.hasOwnProperty('class') ) // && !data.node.li_attr.class.includes("script-node") )
        data.instance.set_icon(data.node, tree_folder_url);
    })
    .jstree({
      core: {
        multiple: false,
        animation: 0,
      },
      search: {
        case_insensitive: true,
        show_only_matches: true,
      },
      plugins: ["dnd", "search", "state", "types", "wholerow"],
    });
});
