"""Default variable filters."""
##from __future__ import unicode_literals

from django.utils.encoding import force_str
#from django.utils.encoding import force_text
from django.utils.html import conditional_escape
from django.utils.safestring import mark_safe
from django import template
from django.templatetags.static import static
#from django.contrib.staticfiles.templatetags.staticfiles import static

register = template.Library()


# note this is a copy/paste of the standard defaultsfilters.py templatetag unordered_list
# which was then modified to allow various ul and li tag attributes that make it useful for
# jstree and the schedule app.

@register.filter(is_safe=True, needs_autoescape=True)
def unordered_list_jstree(value, autoescape=True):
    """
    Recursively takes a self-nested list and returns an HTML unordered list --
    WITHOUT opening and closing <ul> tags.

    The list is assumed to be in the proper format. For example, if ``var``
    contains: ``['States', ['Kansas', ['Lawrence', 'Topeka'], 'Illinois']]``,
    then ``{{ var|unordered_list }}`` would return::

        <li>States
        <ul>
                <li>Kansas
                <ul>
                        <li>Lawrence</li>
                        <li>Topeka</li>
                </ul>
                </li>
                <li>Illinois</li>
        </ul>
        </li>
    """
    if autoescape:
        escaper = conditional_escape
    else:
        escaper = lambda x: x

    def walk_items(item_list):
        item_iterator = iter(item_list)
        try:
            item = next(item_iterator)
            while True:
                try:
                    next_item = next(item_iterator)
                except StopIteration:
                    yield item, None
                    break
                if not isinstance(next_item, dict):  #six.string_types):
                    try:
                        iter(next_item)
                    except TypeError:
                        pass
                    else:
                        yield item, next_item
                        item = next(item_iterator)
                        continue
                yield item, None
                item = next_item
        except StopIteration:
            pass

    def list_formatter(item_list, tabs=1):
        indent = '\t' * tabs
        output = []
        for item, children in walk_items(item_list):
            item_name = item.get('name', '')
            item_type = item.get('file_type', 'f')
            #item_path = item.get('path', '')
            item_id = item.get('tree_id', -1)
            sublist = ''
            if item_type.lower() == 'b':
                li_open_tag = ('<li class="script-node" data-batch-id="'+str(item_id) +
                               '" data-jstree=\'{"icon": "/static/schedule/tree-script.png" }\''
                               )
            elif item_type == 'd':
                li_open_tag = '<li class="folder-node" data-jstree=\'{"icon": "/static/schedule/tree-folder.png" }\''
            elif item_type == 'f':
                li_open_tag = ('<li class="table-node" data-table-id="'+str(item_id) +
                               '" data-jstree=\'{"icon": "/static/schedule/tree-table.png" }\''
                               )
            elif item_type == 's':
                # TODO determine icon to be used base on script state in name
                item_status = item.get('status', '')
                #item_filename = item.get('filename', '')
                if item_status == '0':
                    li_open_tag = ('<li class="slg-node" data-slg-id="'+str(item_id) + 
                    '" data-jstree=\'{"icon": "/static/schedule/ov_dot_green.png" }\''
                    )
                elif item_status == '1':
                    li_open_tag = ('<li class="slg-node" data-slg-id="'+str(item_id) + 
                    '" data-jstree=\'{"icon": "/static/schedule/ov_dot_yellow.png" }\''
                    )
                elif item_status == '2':
                    li_open_tag = ('<li class="slg-node" data-slg-id="'+str(item_id) + 
                    '" data-jstree=\'{"icon": "/static/schedule/ov_dot_red.png" }\''
                    )
                else:
                    li_open_tag = ('<li class="slg-node" data-slg-id="'+str(item_id) + 
                    '" data-jstree=\'{"icon": "/static/schedule/ov_dot_grey.png" }\''
                    )
            else:
                li_open_tag = '<li'
            if children:
                sublist = '\n%s<ul>\n%s\n%s</ul>\n%s' % (
                    indent, list_formatter(children, tabs + 1), indent, indent)

            output.append('%s%s>%s%s</li>' % (
                indent, li_open_tag, escaper(force_str(item_name)), sublist))
        return '\n'.join(output)

    return mark_safe(list_formatter(value))