$(document).ready(function () {
  ExceptionManagerGrid.loadGridStatesFromServer([]);
  sessionStorage.setItem("msg_filter", "USER");
  let searchPhrase = null;

  // only remember thread_activities_id if available on page load
  // var thread_activities_id = sessionStorage.getItem("thread_activities_id");
  // sessionStorage.removeItem("thread_activities_id");

  let grid = $("#grid")
    .kendoGrid({
      columns: [
        {
          field: "close",
          title: " ",
          width: "90",
          template:
            "#if (closed.length == 0) { " +
            "# <div class='buttons-holder'><button type='button' title='Details' class='btn btn-xs command-btn command-edit'><span class='fa fa-pencil'></span></button>" +
            "<button type='button' title='Reassign' class='btn btn-xs command-btn command-reassign'><span class='fa fa-exchange'></span></button></div> # } " +
            "else { " +
            "# <button type='button' title='Information' class='btn btn-xs command-btn command-info'><span class='fa fa-info'></span></button> # } " +
            "#",
        },
        { field: "type", width: "50", title: "Type" },
        { field: "description", width: "350", title: "Description" },
        { field: "serialno", width: "120", title: "Serial No.", type: "number" },
        { field: "ref", width: "130", title: "Ref" },
        { field: "priority", width: "30", title: "Priority", type: "number" },
        { field: "assignee", width: "150", title: "Assignee" },
        { field: "created", width: "150", title: "Opened" },
        { field: "closed", width: "150", title: "Closed" },
        { field: "process", width: "90", title: "Workflow" },
        { field: "state", width: "150", title: "Action Item" },
        {
          field: "nref",
          width: "50",
          title: "Numeric Ref",
          type: "number",
          hidden: true,
        },
        { field: "creator", width: "50", title: "Creator", hidden: true },
        { field: "due", width: "150", title: "Due", hidden: true },
        {
          field: "closedreason",
          title: "Closed reason",
          width: "150",
          hidden: true,
        },
        {
          field: "nresult",
          width: "50",
          title: "Result Amount",
          hidden: true,
        },
        {
          field: "id",
          width: "80",
          title: "ID",
          type: "number",
          hidden: true,
        },
      ],
      dataSource: {
        transport: {
          read: {
            url: "/result_manager/api/data/basic",
            type: "post",
            dataType: "json",
            data: {
              pathname: "activities",
              msg_filter: "USER",
              thread_activities_id: null,
              searchPhrase: null,
            },
          },
        },
        requestStart: function (e) {
          this.options.transport.read.data.msg_filter = sessionStorage.getItem(
            "msg_filter"
          );
          this.options.transport.read.data.thread_activities_id = thread_activities_id;
          this.options.transport.read.data.searchPhrase = searchPhrase;
        },
        schema: {
          data: "rows",
          skip: "skip",
          take: "take",
          total: "total",
          pageSize: "pageSize",
          page: "page",
          id: "id",
        },
        pageSize: 250,
        serverPaging: true,
        serverSorting: true,
      },
      pageable: {
        info: true,
        previousNext: false,
        numeric: false,
      },
      /*
        pageable: {
            pageSizes: [10, 25, 50, "all"],
            pageSize: 25,
            numeric: false,
        },*/
      scrollable: {
        virtual: true,
      },
      selectable: "row",
      resizable: true,
      columnMenu: false,
      //filterable: true,
      reorderable: true,
      sortable: true,
      dataBound: onDataBound,
      sort: function (e) {
        $("#grid .k-scrollbar-vertical").scrollTop(0);
        // manipulate the stlying of the grid column header
        styleColumnHeader(e.sort["field"], e.sort["dir"]);
      },
      /*
        columnMenuInit: function(e) {
            // Remove the item from the menu via JQuery
            //e.container.find(".k-item").remove();
            var items = e.container.find(".k-item");
            items.each(function(i,e) {
                if(e.className.indexOf("k-filter-item") == -1)
                {
                    e.remove()
                }
            });
        },
        */
      toolbar: kendo.template($("#template").html()),
    })
    .data("kendoGrid");

  ExceptionManagerGrid.setGridOptions("activities", []);

  $("#grid")
    .kendoTooltip({
      filter: "button",
      position: "top",
      content: function (e) {
        let target = e.target; // the element for which the tooltip is shown
        return target.data("title") + " " + target.text(); // set the element text as content of the tooltip
      },
    })
    .data("kendoTooltip");

  // add column menu to toolbar
  let ds = [];
  for (let i = 0, max = grid.columns.length; i < max; i++) {
    let title = grid.columns[i].title;
    if (title.trim().length === 0) title = grid.columns[i].field;

    ds.push({
      encoded: false,
      text:
        "<input type='checkbox' checked='checked' class='check k-checkbox' data-field='" +
        grid.columns[i].field +
        "' id='" +
        grid.columns[i].field +
        "'/>" +
        "<label class='k-checkbox-label' for='" +
        grid.columns[i].field +
        "'>" +
        title +
        "</label>",
    });
  }
 
  
  // setup some initial state

  $("#reassignContainer").css("visibility", "hidden");
  $("[name=userNames]").val(""); // To select "Reassign to..."

  // on load, check of there is a thread_activities_id, if so
  // set the id and read the grid data again
  if (thread_activities_id > 0) {
    $("#grid").data("kendoGrid").dataSource.read({
      thread_activities_id: thread_activities_id,
    });
  }

  // toolbar status dropdown creation.
  let status = $("#status").kendoDropDownList({
    change: function (e) {
      let name = e.sender.value();
      if (name.length === 0) name = "user";

      // filter status by selected option value

      // do not reload grid data, i.e. do nothing for now
      if (name === "thread") return false;

      // only show reassign if admin (no active unless admin)
      if (name === "active")
        $("#reassignContainer").css("visibility", "visible");
      else $("#reassignContainer").css("visibility", "hidden");

      // user/active/all - clear thread_activities_id
      let msgFilter = name.toUpperCase();
      //thread_activities_id = null;

      // persist status - message filter
      sessionStorage.setItem("msg_filter", msgFilter);

      // request grid data based on status - message filter
      $("#grid").data("kendoGrid").dataSource.read({
        pathname: "activities",
        msg_filter: msgFilter,
        thread_activities_id: null,
        searchPhrase: searchPhrase,
      });
    },
  });

  let reassign = $("#form_activity_reassign_user").kendoDropDownList({
    change: function (e) {},
  });

  // column menu on toolbar handler
  $("#column-menu").kendoMenu({
    dataSource: [
      {
        text: "Columns",
        imageUrl: "/static/result_manager/arbutus-img/columns12x12.png",
        items: ds,
      },
    ],
    openOnClick: true,
    closeOnClick: false,
    open: function () {
      let selector;
      // deselect hidden columns
      $.each(grid.columns, function () {
        if (this.hidden) {
          selector = "input[data-field='" + this.field + "']";
          $(selector).prop("checked", false);
        }
      });
    },
    select: function (e) {
      // ignore click on top-level menu button
      if ($(e.item).parent().filter("div").length) return;

      let input = $(e.item).find("input.check");
      let field = $(input).data("field");
      if ($(input).is(":checked")) {
        grid.showColumn(field);
      } else {
        grid.hideColumn(field);
      }
    },
  });

  // grid event handlers
  function onDataBound(e) 
  {
    /*
      // manage width of grid columns
      for (var i = 0; i < this.columns.length; i++) {
        this.autoFitColumn(i);
      }
      */

    // manage reassign widgets if required.
    let msg_filter = sessionStorage.getItem("msg_filter");
    if (msg_filter.length == 0 || msg_filter != "ACTIVE") {
      $(".command-reassign").hide();
      $("[name=userNames]").val(""); // To select "Reassign to..."
    } else {
      $(".command-reassign").show();
      // determine reassign select.
      if (
        $("#form_activity_reassign_user option:selected") &&
        $("#form_activity_reassign_user option:selected").val().length > 0
      ) {
        $(".command-reassign").prop("disabled", false);
      } else {
        $(".command-reassign").prop("disabled", true);
      }
    }
  }

  $("#grid").on("click", "tbody tr", function (e) {
    let isReassignBtn =
      ($(e.target).hasClass("command-reassign") &&
        $(e.target).prop("disabled") == false) ||
      ($(e.target).parent().hasClass("command-reassign") &&
        $(e.target).parent().prop("disabled") == false);

    // select grid item if not reassign button
    if (!isReassignBtn) {
      // open user edit dialog
      let grid = $("#grid").data("kendoGrid");
      let selected = $(e.currentTarget).closest("tr");
      let row_data = grid.dataItem(selected);
      if (row_data == null) return;

      let handle_type = "open";
      if (row_data.closed.length == 0) handle_type = "close";

      let selectedTable = selected.closest("table");
      if (selectedTable.hasClass("request-sent")) return;

      selected.addClass("requested-row");
      selectedTable.addClass("request-sent");
      $(
        '<div class="k-loading-mask" style="width: 100%; height: 100%; top: 0px; left: 0px;"><span class="k-loading-text">Loading...</span><div class="k-loading-image"></div><div class="k-loading-color"></div></div>'
      ).appendTo("#grid .k-grid-content");
      doHandleActivity(row_data.id, handle_type, function () {
        selected.removeClass("requested-row");
        selectedTable.removeClass("request-sent");
        $(".k-loading-mask").remove();
      });
    }

  });

  /* row buttons event handlers */

  function doHandleActivity(grid_id, handleType, callback) 
  {
    $.ajax({
      url: "/result_manager/api/data/close-activity",
      type: "GET",
      data: {
        activity_id: grid_id,
      },
      cache: false,
      dataType: "json",
      success: function (resp) {
        if (resp.enum_activity_error && resp.enum_activity_error.length > 0) {
          console.log(resp.enum_activity_error);
          $("#errors").html(resp.enum_activity_error);
          $("#messageModal").modal("show");
        } else {
          build_activity_dialog(
            resp.enum_activity_success,
            resp.enum_action_success,
            resp.enum_action_error,
            resp.enum_attach_success,
            resp.enum_notes_success,
            resp.enum_notes_error
          );

          // dialog form now populated, show it.
          //ArbutusExceptionManager.currentCommand = 'Close';
          let form_elem =
            "#form_" +
            "activities" /*ArbutusExceptionManager.page_path*/ +
            "_id";
          $(form_elem).show();

          if (handleType == "open") {
            // readonly result cost, cost, hours
            $("#form_activities_nresult").prop("readonly", true);
            $("#form_activities_cost").prop("readonly", true);
            $("#form_activities_hours").prop("readonly", true);

            // hide all action button
            $("#action_buttons").find("button").prop("disabled", true);

            // disable attachment buttons
            $(".drop-zone-element").hide();
            $(".drop-zone-actions-container").hide();

            /*
            $(".fileupload-buttonbar")
              .find("input, button")
              .prop("disabled", true);
            
            $('.fileupload-buttonbar').first().hide();
            */

            // disable notes button
            $("#dialog_activities_notes_save").prop("disabled", true);
          } else {
            // remove readonly result cost, cost, hours
            $("#form_activities_nresult").prop("readonly", false);
            $("#form_activities_cost").prop("readonly", false);
            $("#form_activities_hours").prop("readonly", false);

            // show all action buttons
            $("#action_buttons").find("button").prop("disabled", false);

            // enable attachment buttons
            $(".drop-zone-element").show();
            $(".drop-zone-actions-container").show();
            /*
            $(".fileupload-buttonbar")
              .find("input, button")
              .prop("disabled", false);
            
            $('.fileupload-buttonbar').first().show();
            */

            // enable notes button
            $("#dialog_activities_notes_save").prop("disabled", false);
          }

          $("#modal_" + "activities")
            .on("hide.bs.modal", function (e) {
              $(this).find("form").trigger("reset");
              $("select").scrollTop(0);
              $(".dual-select").bootstrapDualListbox("refresh", true);
            })
            .on("shown.bs.modal", function (e) {
              $("input:text:visible:enabled", this)
                .not('[readonly="readonly"]')
                .first()
                .focus();
              callback();
            })
            .modal("show");
        }
      },
      error: function (err) {
        console.log(err.message);
      },
    });
  }

  // grid toolbar button event handlers (reassign)
  $(document).on("change", "select#form_activity_reassign_user", function (e) 
  {
    if ($(e.target) && $(e.target).val().length > 0) {
      $(".command-reassign").prop("disabled", false);
    } else {
      $(".command-reassign").prop("disabled", true);
    }
  });

  $(document).on(
    "click",
    ".command-reassign" /*'.modal-footer .dialog_activities_reassign_save'*/,
    function (e) {
      let grid = $("#grid").data("kendoGrid");
      let selected = $(e.currentTarget).closest("tr");
      let row_data = grid.dataItem(selected);
      if (row_data == null) return;

      // web server side still expects array, although now only one id sent.
      let selected_rows = [];
      selected_rows.push(row_data.id);
      //$.each(grid.select(), function(i,v) {
      //    selected_rows.push(grid.dataItem(v).id);
      //});

      $.ajax({
        url: "/result_manager/api/data/reassign-activities",
        type: "POST",
        data: {
          new_user_id: $("#form_activity_reassign_user")
            .find(":selected")
            .val(),
          reassign_activities: JSON.stringify(selected_rows),
        },
        cache: false,
        dataType: "json",
        success: function (resp) {
          $("#grid").data("kendoGrid").dataSource.read();
          //$("#reassignContainer").css("visibility", "hidden");
          if (resp.result != "OK") {
            $("#errors").html(resp.message);
            $("#messageModal").modal("show");
          }
        },
        error: function (e) {
          console.log(e.message);
        },
      });
    }
  );

  // event handler for search widget
  $("#search").keyup(function () {
    searchPhrase = $(this).val();
    // NOTE: pulling grid data from webserver maybe too
    // expensive/slow for each key up???
    ExceptionManagerGrid.refreshGrid();
  });


  $(document).on(
    "click",
    "#activity-close-form-save",
    function ( ) {

      // This is where the current activity RM Form can be saved.
      // NOTE: This is different from closing the acitivty, which will
      // also save the form but with required/mandatory client-side 
      // validation.  As it is intended for the user to be able to 
      // partially enter form data, we allow mandatory fields to not be
      // fully validated on this event.

      close_activity_add_answer( get_current_rmform_values(false) );
    });

});
