
var ArbutusFormCloseActivity = {
  current_form_details: null,
  thread_id: null,
  activity_id: null,
};
  
  
// form fields init functions start

function selectControlInit( /*data = [1, 2, 3, 4, 5, 6, 7, 8, 9]*/ ) {
  jQuery("[data-type=select]:not([data-role=dropdownlist])").kendoDropDownList({
    //dataSource: [],
  });
}


function datePickerInit() {
  jQuery("[data-type=date-picker]:not([data-role=datepicker])").kendoDatePicker(
    {
      popup: {
        appendTo: $(".demo-section")
      },
      size: "small",
      format: "yyyy-MM-dd",
    },
    
  );

  jQuery(".datepicker .k-icon").removeClass("k-i-calendar");
  jQuery(".datepicker .k-icon").addClass("calendar-icon");
}


function rangeSliderInit(slid, min = 0, max = 10, enabled = false) {
  //jQuery("[data-type=range-slider]").kendoSlider({
  jQuery(slid).kendoSlider({
    showButtons: false,
    smallStep: 1,
    largeStep: max,
    min: min,
    max: max,
    tooltip: {
      enabled: false,
    },
    enabled: enabled,
    change: function (e) {
      e.sender.element
        .closest(".form-fields_row")
        .find(".range-slider-value")
        .html(e.value);
    },
  });
}


function rangeSliderSet(activity)
{
  // we have found the forms key, iterate over all activity forms.
  jQuery.each(activity['forms'], function (form_index, aForm) {

    // iterate over each question of this form.
    jQuery.each(aForm['questions'], function (_, aQuestion) {

      // type '9' is a numeric slider question
      if (aQuestion['type'] === '9') {
        const choices = aQuestion['choices'].split(',');
        let min = 0;
        let max = 10;
        if (choices.length == 2) {
          min = parseInt(choices[0].trim());
          max = parseInt(choices[1].trim());
        }
          
        // is first form and this form belongs to current activity strate and activity is NOT already closed
        const slid = "#question-" + aQuestion['id'];
        if (form_index == 0 && activity.state_id == activity.forms[form_index].sid && activity.closed.trim().length === 0)
          rangeSliderInit(slid, min, max, true);
        else
          rangeSliderInit(slid, min, max, false);
      }
    });
  });
}


function onUpload(e) 
{
  e.data = { thread_id: ArbutusFormCloseActivity.thread_id };
}


/*
function onComplete(e) {
console.log('on complete');
}
*/


function dropZoneInit() {
  jQuery("[data-type=drop-zone]").kendoUpload({
    async: {
      //chunksize: 65520,
      saveUrl: "/result_manager/upload",
      //saveUrl: "http://127.0.0.1:8000/result_manager/upload",
      //'removeUrl': "http://my-app.localhost/remove",
      autoUpload: false,
    },
    upload: onUpload,
    //complete: onComplete,
    validation: {
      //allowedExtensions: [".jpg", ".jpeg", ".png", ".bmp", ".gif"],
      //maxFileSize: 900000,
      //minFileSize: 300000
    },
    success: (e) => {
      const files_uploaded = e.response.files;

      // Note, that on 'success' the files_uploaded is information
      // returned from arbutus, not the kendoUpload widget.
      let rc = $('#uploaded-files tr').length;
      for (let i = 0; i < files_uploaded.length; i++) {
        const n = files_uploaded[i].name;
        const c = files_uploaded[i].created;
        const w = files_uploaded[i].who;
        const url = files_uploaded[i].url;
        const u = `<span><a href="${url}">Download</a></span>`
        const table_row = `<tr><th scope="row">${rc}</th><td>${n}</td><td>${c}</td><td>${w}</td><td>${u}</td></tr>`;
        $('#uploaded-files').append(table_row);
        rc++;
      }
    },
    showFileList: true,
    dropZone: ".drop-zone-element",
    template: ({ name, size, files }) => {
      return kendo.template($("#drop-zone-files-template").html())({
        name,
        size,
        extension: files[0].extension.replace(".", ""),
      });
    },
    error: (e) => console.log(e)
  });

  // form fields init functions end
  const upload = $("#files").data("kendoUpload");
  $("[data-type=download-all-files]").on("click", (e) => {
    e.preventDefault();
    upload.upload();
  });

  $("[data-type=paused-all-files]").on("click", (e) => {
    e.preventDefault();
    upload.pause();
  });
}


function handleShowNoteContent() {
  this.closest(".notes-list-item").classList.add("open-mode");
}


function handleHideNoteContent() {
  this.closest(".notes-list-item").classList.remove("open-mode");
}


function process_activity_note_save(new_note, thread_id, do_build_notes) {
  $.ajax({
    url: "/result_manager/api/data/notes-activity",
    type: "POST",
    data: {
      thread_id: thread_id, //$("#form_activities_thread_id").val(),
      new_note: JSON.stringify(new_note),
    },
    cache: false,
    dataType: "json",
    success: function (resp) {
      if (resp.result.length > 0) {
        if (do_build_notes) build_activity_notes(resp.result);
      } else {
        console.log(resp.result);   // handle app specific error
      }
    },
    error: function (e) {
      console.log(e.message);       // handle POST error
    },
  });
}


function get_current_rmform_values(check_mandatory) {
  // returning an empty object mean that this activity has no form
  // so no validation attempted
  // returning a null means that there was a form associated with this 
  // activity but it failed validation.
  let result = {};
  if (!ArbutusFormCloseActivity.current_form_details) return result;
  
  // state has a form attached to it, get user form data.
  result["thread_id"] = ArbutusFormCloseActivity.thread_id;
  result["activity_id"] = ArbutusFormCloseActivity.activity_id;
  result["process_id"] = ArbutusFormCloseActivity.current_form_details.pid;
  result["state_id"] = ArbutusFormCloseActivity.current_form_details.sid;
  result["form_id"] = ArbutusFormCloseActivity.current_form_details.id;

  // before assigning the current answers, we need to update the values from the widget.
  let is_form_valid = true;
  ArbutusFormCloseActivity.current_form_details.questions.forEach(function (elem, index) {
    const id = "question-" + elem.id;
    const domId = "#" + id;
    let value = " ";
    if (elem.type == 1) {                                 // radiobutton
      let rbid = "input[name=" + id + "]:checked";
      value = $(rbid).val();
    } else if (elem.type == 2) {                          // dropdown
      const selected_domId = domId + " option:selected";
      value = $(selected_domId).text();
    } else if (elem.type == 3) {                          // checkbox
      value = ($(domId).is(":checked")) ? "T" : "F"; 
    } else {                                              // all other type e.g. editbox & including date
      value = $(domId).val();                          
    }
    
    const is_disabled_form = $('form#close-activity-form-0').children('fieldset').prop('disabled');
    let is_valid_answer = true;
    if (check_mandatory && !is_disabled_form && elem.mandatory === "Y") (is_valid_answer = validate_rm_form(index, value));
    if (!is_valid_answer) is_form_valid = false;
    if (value !== undefined && is_valid_answer) ArbutusFormCloseActivity.current_form_details.questions[index].answer = value.trim();
  });

  result["questions"] = ArbutusFormCloseActivity.current_form_details.questions;
  if (!is_form_valid) result = null;

  return result
}


function isValidAnswer(i)
{
  const container = document.getElementsByClassName('question-container');
  const element = container[i];
  const input = element.getElementsByTagName('input');
  const texta = element.getElementsByTagName('textarea');
  const select = element.getElementsByTagName('select');
  
  let result = true;
  if (input.length > 0)
    result = input[0].checkValidity();
  else if (texta.length > 0)
    result = texta[0].checkValidity();
  else if (select.length > 0)
    result = select[0].checkValidity();
  else
    console.log("isValidAnswer(...) - unknown element type!")

  return result;
}


function validate_rm_form(i, val) 
{
  let result = true;
  if (val === undefined || val === null || (val !== undefined && val !== null && val.trim().length === 0) || !isValidAnswer(i)) {  
    // no elem value - highlight elem container based on index
    $($('.question-container')[i]).css({"border-color": "red", "border-style": "solid"});
    result = false;
  } 
  else {
    // is value - unhighlight dom elem container based on index
    $($('.question-container')[i]).css({"border-color": "red", "border-style": "none"});
  }

  return result;
}
