// global shared functions 

function styleColumnHeader(field, dir) {
  if (field.length > 0) {
    let gridHead = jQuery("#grid").getKendoGrid().thead;
    let cells = gridHead.find("th");
    jQuery(cells).css('font-weight', 'normal');
    for (let i = 0; i < cells.length; i++) {
      if (jQuery(cells[i]).data('field') === field) {
        if (dir === undefined || dir.length === 0) {
          jQuery(cells[i]).css('font-weight', 'normal');
          //jQuery(cells[i]).css('background-color', "white");
        }
        else {
          jQuery(cells[i]).css('font-weight', 'bold');
          //jQuery(cells[i]).css('background-color', "#9e9a9a");
        }

        break;
      }
    }
  }
}

$(document).ready(function () {

  // common delete dialog event handler

  jQuery(document).on('click', '#deleteConfirmModalOK', function () {
    //var grid = jQuery("#grid").data("kendoGrid");
    let selected_rows = [];

    // no grid row checkbox selected, so row delete button selected
    if (selected_rows.length < 1) {
      selected_rows.push(ExceptionManagerServer.getCurrentID());
      ExceptionManagerServer.clearCurrentID();
    }

    jQuery.ajax({
      url: "/result_manager/api/data/details",
      type: "POST",
      data: {
        "command": 'Delete',
        "dialog_type": window.location.pathname.split('/').pop(),
        "list_id": null,
        "form_data": null,
        "delete_rows": JSON.stringify(selected_rows)
      },
      cache: false,
      dataType: "json",
      success: function (resp) {

        // refresh the grid
        jQuery('#grid').data('kendoGrid').dataSource.read();
        jQuery('#btnDelete').prop("disabled", true);

        // arbutusserver error
        if (resp.result != 'OK') {
          jQuery('#errors').html(resp.message);
          jQuery('#messageModal').modal('show');
        }
      },
      error: function (e) {
        console.log(e.message);
      }
    });
  });

  // some page initialization

  // navbar on page load
  // persist nav expanded/collapsed state in localStorage
  if (localStorage.getItem('navbar-state') === null)              // none
    localStorage.setItem('navbar-state', 'expanded');             // default of page is to be expanded
  else if (localStorage.getItem('navbar-state') !== 'expanded')
    setTimeout(function () { jQuery('[data-toggle=offcanvas]').click() }, 100);  // toggle current state

  // off-canvas sidebar toggle 
  jQuery('[data-toggle=offcanvas]').click(function (e) {
    e.preventDefault();

    jQuery('#main').toggleClass('main-width-expand');
    // if new toggle of main is expanded, nav must be collapsed
    if (jQuery('#main').hasClass('main-width-expand')) {
      localStorage.setItem('navbar-state', 'collapsed');
      //$('.chartMenuContainer').css('margin-right', '3%');
    }
    else {
      localStorage.setItem('navbar-state', 'expanded');
      //$('.chartMenuContainer').css('margin-right', '6%'); 
    }

    jQuery('.row-offcanvas').toggleClass('active');
    jQuery('.collapse').toggleClass('in').toggleClass('hidden-xs').toggleClass('visible-xs');

    if (typeof myDiagram !== 'undefined') {
      myDiagram.requestUpdate();
    }
  });

  jQuery(".nav a").filter(function (index) {
    let pathname = window.location.pathname;
    let href = jQuery(this).attr("href")
    if ((pathname === href && !thread_activities_id) ||
      (pathname.split('/').pop() === "visual-editor") && (href.split('/').pop() === "processes") ||
      (pathname.split('/').pop() === "activities") && (href.split('/').pop() === "threads") && thread_activities_id) {
      // either current nav anchor matches current page, except if there is a thread_activities_id
      // or the current page is 'visual-editor' and current nav a is 'processes'
      // or the current page is 'activites' and current nav a is 'threads'. 
      //   - Keep on results nav active if (threads) is redirecting to 'Result Activities Log'
      jQuery(this).parent().addClass("active");
    }
  });

  // handle navbar link selection, except toggle for page selection
  jQuery(".nav a").on("click", function () {
    if (jQuery(this).data('toggle') !== 'offcanvas') {
      jQuery(".nav").find(".active").removeClass("active");
      jQuery(this).parent().addClass("active");
      //color: #F05B27; // see css
    }
  });

  jQuery("#form_processes_entry").hide();

  // initialize users and groups select widgets
  // as it uses two listbox's, i.e. available and selected.
  const page = window.location.pathname.split('/').pop();
  let pre_label = "Groups ";
  if (page === "groups")
    pre_label = "Users ";  

  const nonSelectedListLabel = pre_label + "Available";
  const selectedListLabel = pre_label + "Assigned";
  let users_groups_select = jQuery('.dual-select').bootstrapDualListbox({
    nonSelectedListLabel: nonSelectedListLabel,
    selectedListLabel: selectedListLabel,
    preserveSelectionOnMove: 'moved',
    moveOnSelect: false,
    infoText: false,
    showFilterInputs: false,
    selectorMinimalHeight: 200
  });

  users_groups_select.parent().find('.moveall').remove();
  users_groups_select.parent().find('.removeall').remove();

});

// 


/* when leaving a page save the current page grid state to sessionStorage */

jQuery(window).on("unload", function (e) {
  if (window.location.pathname.split('/').pop() != 'visual-editor') {
    ExceptionManagerGrid.handleUnloadPage();
  }
});

// helper object for handling grid states
var ExceptionManagerGrid = (function () {

  /*
      NOTE: using sessionStorage on the client side
      as it is persisted in the long term by arbutusserver
  */

  let common_key = "kendo-grid-options-";
  let page_names = ['activities', 'users', 'groups', 'processes', 'threads'];

  // https://tc39.github.io/ecma262/#sec-array.prototype.find
  // Use this polyfill to support shit browsers like IE
  if (!Array.prototype.find) {
    Object.defineProperty(Array.prototype, 'find', {
      value: function (predicate) {
        // 1. Let O be ? ToObject(this value).
        if (this == null) {
          throw new TypeError('"this" is null or not defined');
        }

        let o = Object(this);

        // 2. Let len be ? ToLength(? Get(O, "length")).
        let len = o.length >>> 0;

        // 3. If IsCallable(predicate) is false, throw a TypeError exception.
        if (typeof predicate !== 'function') {
          throw new TypeError('predicate must be a function');
        }

        // 4. If thisArg was supplied, let T be thisArg; else let T be undefined.
        let thisArg = arguments[1];

        // 5. Let k be 0.
        let k = 0;

        // 6. Repeat, while k < len
        while (k < len) {
          // a. Let Pk be ! ToString(k).
          // b. Let kValue be ? Get(O, Pk).
          // c. Let testResult be ToBoolean(? Call(predicate, T, « kValue, k, O »)).
          // d. If testResult is true, return kValue.
          let kValue = o[k];
          if (predicate.call(thisArg, kValue, k, o)) {
            return kValue;
          }
          // e. Increase k by 1.
          k++;
        }

        // 7. Return undefined.
        return undefined;
      },
      configurable: true,
      writable: true
    });
  }

  return {
    savePageGridState: function (page, state) {
      let page_key = common_key + page;
      sessionStorage[page_key] = state;
    },
    loadPageGridState: function (page) {
      let page_key = common_key + page;
      return sessionStorage[page_key];
    },
    hasAnyPageGridState: function () {
      let hasPageState = false;
      jQuery.each(page_names, function (idx, page) {
        let result = ExceptionManagerGrid.loadPageGridState(page);
        if (result && result.length > 0)
          hasPageState = true;
      });

      return hasPageState;
    },
    setGridOptions: function (current_page, click_events) {
      let options = this.loadPageGridState(current_page);
      if (options) {
        let parseOptions = JSON.parse(options);
        // find command column index
        // NOTE Array.prototype.find NOT supported in IE (see polyfill above)
        parseOptions.columns.find(function (v, i) {
          // command column has a space for a field name
          if (parseOptions.columns[i].hasOwnProperty('command')) {
            // set click method
            jQuery.each(click_events, function (idx, click_event) {
              parseOptions.columns[i].command[idx].click = click_event;
            });

            return false;
          }
        });

        jQuery("#grid").data("kendoGrid").setOptions(parseOptions);
      }
    },
    setClearGridState: function () {
      // clear all grid state client side.
      jQuery.each(page_names, function (idx, page) {
        let page_key = common_key + page;
        sessionStorage.removeItem(page_key);
      });

      // clear all grid state server side
      this.clearGridStatesOnServer();
    },
    clearGridStatesOnServer: function () {

      jQuery.ajax({
        url: "/result_manager/api/data/grids-config",
        type: "POST",
        data: {
          grids: null  // TODO check client side for null grids, if so it is a clear
        },
        cache: false,
        dataType: "json",
        success: function (resp) {
          if (resp.result == 'OK') {
            ;
          }
          else if (resp.result == 'CLEAR') {
            // unbind unload as we do not want to save sate
            jQuery(window).unbind("unload");

            // reload
            location.reload();
          }
          else {
            jQuery('#errors').html(resp.message);
            jQuery('#messageModal').modal('show');
          }
        },
        error: function (e) {
          console.log(e.message);
        }
      });

    },
    handleUnloadPage: function () {
      let grid = jQuery("#grid").data("kendoGrid");
      let msg = "handleUnloadPage - ";
      let page = window.location.pathname.split('/').pop();
      if (grid != undefined) {
        ExceptionManagerGrid.savePageGridState(page, kendo.stringify(grid.getOptions()));
        msg += "Grid on page " + page + " is saved";
      }
      else {
        msg += "No grid on page " + page;
      }

      //console.log(msg);
    },
    saveGridStatesToServer: function (saveOnUnLoad) {

      // save current page to sessionStorage as we will not have
      // unloaded the last page.
      if (saveOnUnLoad) {
        this.handleUnloadPage();
      }

      /*
          iterate over all the saved pages states persisted
          client side in sessionStorage.
       */

      let all_pages_state = [];
      jQuery.each(page_names, function (idx, page) {
        let grid_page = common_key + page;
        if (sessionStorage.getItem(grid_page)) {
          let obj = {};
          obj[page] = JSON.parse(sessionStorage.getItem(grid_page));
          all_pages_state.push(obj);
        }
      });

      if (all_pages_state.length > 0) {
        // send all_pages_state to server as json
        jQuery.ajax({
          url: "/result_manager/api/data/grids-config",
          type: "POST",
          data: {
            grids: JSON.stringify(all_pages_state)
          },
          cache: false,
          dataType: "json",
          success: function (resp) {
            if (resp.result == 'OK') {
              ;
            }
            else {
              jQuery('#errors').html(resp.message);
              jQuery('#messageModal').modal('show');
            }
          },
          error: function (e) {
            console.log(e.message);
          }
        });
      }

    },
    loadGridStatesFromServer: function (click_events) {
      // called after successful login and populates all the sessionStorage
      // with state with the data saved on arbutusserver.
      // check to see if any page grids have state, if not,
      // request it from the server.
      if (!this.hasAnyPageGridState()) {
        jQuery.ajax({
          url: "/result_manager/api/data/grids-config",
          type: "GET",
          cache: false,
          dataType: "json",
          async: false, // this _may_ assist grid initing correctly before all grid options avail.
          success: function (resp) {
            if (resp.result == 'OK') {
              if (resp.grids && resp.grids.length > 0) {
                jQuery.each(JSON.parse(resp.grids), function (i, item) {
                  let page = Object.keys(item)[0]
                  let grid_page = "kendo-grid-options-" + page;
                  sessionStorage[grid_page] = JSON.stringify(Object.values(item)[0]);
                });

                // NOTE: not sure of a better way to do this yet?

                // However, the issue is that on each page we initialize the grid
                // then immediately set that page grid options with options returned from
                // a call to loadPageGridState(), however the server may not yet have sent
                // these values, this is particularly an issue on the first grid page loaded
                // after logging in.

                // At this point all the persisted grid options have been returned
                // so we could set it here for the current page, the 'messiness' is that
                // for the first page we set it twice, once on its page load and here.
                ////var current_page = window.location.pathname.split('/').pop();
                ////ExceptionManagerGrid.setGridOptions(current_page, click_events)
              }
            }
            else {
              jQuery('#errors').html(resp.message);
              jQuery('#messageModal').modal('show');
            }
          },
          error: function (e) {
            console.log(e.message);
          }
        });
      }
    },
    refreshGrid: function (e) {
      jQuery('#grid').data('kendoGrid').dataSource.read();
    }
  };

})();

var ExceptionManagerServer = (function () {
  let currentID = null;
  let currentCommand = null;

  return {
    api_data_details: function (dialog_type, form_data) {

      jQuery.ajax({
        url: "/result_manager/api/data/details",
        type: "POST",
        data: {
          "command": currentCommand,
          "dialog_type": dialog_type,
          "list_id": currentID,
          "form_data": JSON.stringify(form_data),
        },
        cache: false,
        dataType: "json",
        success: function (resp) {
          let return_value = -1;
          if (resp.result == 'OK') {
            if (resp.message == "process_redirect") {
              sessionStorage.setItem("process_label", resp.data.process_label);
              sessionStorage.setItem("process_description", resp.data.process_description);
              sessionStorage.setItem("process_serialno", resp.data.process_serialno);
              sessionStorage.setItem("process_id", resp.data.process_id);
              sessionStorage.setItem("process_entry", resp.data.process_entry);

              // redirect to visual editor
              window.location.replace("visual-editor");
            }
            else if (currentCommand == 'Create' && resp.message == 'visual-forms') {
              let obj = myDiagram.findNodeForKey(form_data.node_id)
              if (obj && obj.data) {
                myDiagram.startTransaction("assignRmFormId");
                myDiagram.model.setDataProperty(obj.data, "rmf_id", resp.data.rmf_id);
                //obj.data.rmf_id = resp.data.rmf_id;
                myDiagram.commitTransaction("assignRmFormId");
              }
            }
            else if (currentCommand == "Create2") {
              jQuery('#form_groups_users').append(jQuery('<option>', {
                value: resp.data.id,
                text: resp.data.name
              }));
            }
            else if (currentCommand == "Create3") {
              jQuery('#form_users_groups').append(jQuery('<option>', {
                value: resp.data.id,
                text: resp.data.name
              }));
            }
            else if (dialog_type === 'threads' && currentCommand === 'Create') {
              
              const thread_id = resp.data.thread_id;
              ArbutusFormCloseActivity.thread_id = thread_id;

              // Notes  
              const new_note = $("#form_node_new_notes").val();                           // contents of writable text 
              if (new_note.length > 0) process_activity_note_save(new_note, thread_id, false);   // if contents len > 0, send to server
              
              // Attachments
              const upload = $("#files").data("kendoUpload");
              upload.upload();
              
            }

            let modal_name = "#modal_" + dialog_type;
            jQuery(modal_name).modal('hide');
            
            jQuery('#grid').data('kendoGrid').dataSource.read();
            return return_value;
          }
          else {
            jQuery('#errors').html(resp.message);
            jQuery('#messageModal').modal('show');
          }
        },
        error: function (e) {
          console.log(e.message);
        }
      });
    },
    api_data_details_get: function (dialog_type) {

      jQuery.ajax({
        url: "/result_manager/api/data/details",
        type: "GET",
        data: {
          "command": currentCommand,
          "dialog_type": dialog_type,
          "list_id": currentID,
          "form_data": null
        },
        cache: false,
        dataType: "json",
        success: function (resp) {
          if (resp.error && resp.error.length > 0) {
            jQuery('#errors').html(resp.error);
            jQuery('#messageModal').modal('show');
            return;
          }
          else {
            // iterate over each item in response
            jQuery.each(resp.result, function (name, value) {
              if ((name == 'users' || name == 'groups') && value.length > 0) {
                let elem;
                if (name == 'users') {
                  elem = "#form_groups_users option";
                }
                else if (name == 'groups') {
                  elem = "#form_users_groups option";
                }

                // iterate over array of items and find them in the select option them set
                // them as selected
                // clear all selected in select before setting those in list
                jQuery(elem).each(function () {
                  jQuery(this).prop('selected', false);
                });

                // now select those in list
                jQuery(value).each(function (idx, value) {
                  let option = elem + "[value='" + value + "']";
                  jQuery(option).prop('selected', true);
                });

                // TODO refresh the users and groups dual select widget
                jQuery('.dual-select').bootstrapDualListbox("refresh", true);

              }
              else {
                let form_elem_id = '#form_' + dialog_type + '_' + name;
                if (form_elem_id == '#form_processes_entry')
                  jQuery(form_elem_id).text(value);
                else if (form_elem_id == '#form_users_notify') {
                  jQuery(form_elem_id).val(value);
                }
                else if (form_elem_id == '#form_users_admin') {
                  if (value == "T") {
                    jQuery(form_elem_id).prop('checked', true);
                  } else {
                    jQuery(form_elem_id).prop('checked', false);
                  }
                }
                else if (form_elem_id == "#form_groups_method") {
                  jQuery(form_elem_id).selectpicker('val', value);
                  jQuery(form_elem_id).selectpicker('refresh');
                }
                else
                  jQuery(form_elem_id).val(value);
              }
            });
          }

          let form_elem = '#form_' + dialog_type + '_id';
          jQuery(form_elem).show();
          if (dialog_type == "processes") {
            // do not show edit dialog when editing an existing process
            jQuery('.dialog_save').trigger("click");
          }
          else {
            let modal_dialog_id = '#modal_' + dialog_type;
            jQuery(modal_dialog_id).on('hide.bs.modal', function (e) {
              jQuery(this).find('form').trigger('reset');
              jQuery('select').scrollTop(0);
              jQuery('.dual-select').bootstrapDualListbox("refresh", true);
            }).on('shown.bs.modal', function (e) {
              jQuery('input:text:visible:enabled', this).not('[readonly="readonly"]').first().focus();
              if (dialog_type == "users") jQuery("#form_users_notify").change();
            }).modal('show');
          }
        },
        error: function (e) {
          console.log(e.message);
        }
      });
    },
    api_data_ve_details: function (dialog_type, form_data) {

      jQuery.ajax({
        url: "/result_manager/api/data/ve-details",
        type: "POST",
        data: {
          "command": currentCommand,
          "dialog_type": dialog_type,
          "list_id": currentID,
          "form_data": JSON.stringify(form_data),
        },
        cache: false,
        dataType: "json",
        success: function (resp) {
          let return_value = -1;
          if (resp.result === 'OK') {
            //if (currentCommand === 'Create' && resp.message === 'visual-forms') {
            //  let obj = myDiagram.findNodeForKey(form_data.node_id)
            //  if (obj && obj.data) {
            //    myDiagram.startTransaction("assignRmFormId");
            //    myDiagram.model.setDataProperty( obj.data, "rmf_id", resp.data.rmf_id ); 
            //    myDiagram.commitTransaction("assignRmFormId");
            //  }
            //}

            // TODO - perhaps as a 'Save & Close' button that will redirect back to processes.
            //if (dialog_type === 'visual-flows') {
              // redirect to processes window
              //window.location.replace("processes");
            //}
            
            // if WF save was succesful, update the session process_entry
            // so our beforeunload guard is comparing the current state of visual-editor.
            // ignore other saves such as 'visual-states', visual-actions' and 'visual-forms'
            // as we need the initial load state to compare with current state. i.e.
            // only sync them when saving Workflow ('visual-flows')
            if (dialog_type === 'visual-flows')
              sessionStorage.setItem("process_entry", myDiagram.model.toJson());

            let modal_name = "#modal_" + dialog_type;
            if (dialog_type === 'visual-flows') {
              let msg = jQuery('#process_label').prop('title') + ' workflow successfully saved.';
              jQuery('#message-model-title').html("Save Workflow");
              jQuery('#errors').html(msg);
              jQuery('#messageModal').modal('show');
            }
            else {
              jQuery(modal_name).modal('hide');
            }

            // note only really useful when deleting a node form
            // but rather then make a special case do it for response 
            // as it does no harm.
            myDiagram.clearSelection();
            
            // enable 'save' button after we return from server.
            // regardless of success/hub server error/xhr error etc.
            jQuery('#SaveButton').prop('disabled', false);
            return return_value;
          }
          else {
            jQuery('#errors').html(resp.message);
            jQuery('#messageModal').modal('show');
            // enable 'save' button after we return from server.
            // regardless of success/hub server error/xhr error etc.
            jQuery('#SaveButton').prop('disabled', false);
          }
        },
        error: function (e) {
          // enable 'save' button after we return from server.
          jQuery('#SaveButton').prop('disabled', false);
          console.log(e.message);
        }
      });
    },
    api_data_ve_details_get: function (dialog_type) {

      jQuery.ajax({
        url: "/result_manager/api/data/ve-details",
        type: "GET",
        data: {
          "command": currentCommand,
          "dialog_type": dialog_type,
          "list_id": currentID,
          "form_data": null
        },
        cache: false,
        dataType: "json",
        success: function (resp) {
          if (resp.error && resp.error.length > 0) {
            jQuery('#errors').html(resp.error);
            jQuery('#messageModal').modal('show');
            return;
          }
          else {
            let tabstrip = jQuery("#tabstrip").data("kendoTabStrip");

            // iterate over each item in response
            jQuery.each(resp.result, function (name, value) {
              if (Array.isArray(resp.result[name]) && name === 'questions') 
              {
                // if there is already items, remove them.
                tabstrip.remove(tabstrip.tabGroup.children());

                // iterate over each question
                jQuery.each(resp.result.questions, function (idx, obj) {
                  idx += 1;
                  let append_text = 'Question ' + idx;
                  tabstrip.append(
                    [{
                      text: append_text,
                      imageUrl: "/static/result_manager/img/drag-icon.svg",
                      encoded: false,   // Allows use of HTML for item text
                      // Content for the content element
                      content: kendo.template(jQuery("#question-template").html())({ 
                        qid: idx,
                        quest: obj 
                      })    
                    }]
                  );

                  if (idx === 1) {
                    // set initial state of only one question to disabled
                    let item = jQuery("[data-type='remove']");
                    item.prop("disabled", true).addClass("k-state-disabled");
                  }
                  
                  // iterate over this particular questions details
                  jQuery.each(obj, function (key, question_value) {
                    let cid = '#rmf-question-id-' + key + '-' + idx;
                    if (key === 'type') {
                      let type_value = parseInt(question_value);
                      create_type_dropdown(idx, type_value);
                      show_hide_form_containers( type_value, idx);
                      jQuery(cid + ' option[value="' + question_value + '"]').prop('selected', true);
                    }
                    else if (key === 'mandatory') {
                      (question_value === 'T' || question_value === 'Y') ? jQuery(cid).prop('checked', true) : jQuery(cid).prop('checked', false);
                    }
                    else {
                      jQuery(cid).val(question_value);
                    }
                  });
                  
                  datePickerInit();
                  numericInputInit();
                  selectControlInit();
                });
              }
              else {
                // assume string values
                let form_elem_id = '#rmf-node-' + name;
                jQuery(form_elem_id).val(value);
              }
            });

            tabstrip.select(0);
          }
        },
        error: function (e) {
          console.log(e.message);
        }
      });
    },
    setCurrentID: function (id) {
      currentID = id;
    },
    getCurrentID: function () {
      return currentID;
    },
    clearCurrentID: function () {
      currentID = null;
    },
    setCurrentCommand: function (command) {
      currentCommand = command;
    },
    getCurrentCommand: function () {
      return currentCommand;
    },
    clearCurrentCommand: function () {
      currentCommand = null;
    }
  };

})();


/*
  It should be noted that we should no longer be using a requested id (from hub server) as 
  this was an experiment to see if we could create VE related objects on the fly.  Due to 
  consistent issues with keeping our database integrity with partial object saved before a 
  WF is saved. Now we just persist these objects all at once on said save.

  Code still calls this function but it should now always return the appropiate 
  already assigned id (or none) if required.

 */

function request_rm_id(callback, gobj, is_form, num_ids = 1) {

  function has_rm_id(cid) 
  {
    if (cid.toString().charAt(0) === '^' || cid > 0)
      return true;
    else
      return false;
  }

  // ensure that we have a valid object
  if (gobj && gobj.data) {
    let gid = gobj.data.id;     // is node or link
    if (is_form) {
      gid = gobj.data.rmf_id;   // is a form
    }
    if (gid === undefined) {
      gid = -1; // firt time form, this property will not be defined.
    }

    if (has_rm_id(gid)) {
      ExceptionManagerServer.setCurrentCommand('Update');
      return callback.apply(this, [gid]); // already have a hub server assigned id, use it.
    }
    else {
      let url = "/result_manager/api/data/request-id/" + num_ids
      jQuery.ajax({
        url: url,
        type: "GET",
        cache: false,
        dataType: "json",
        async: false,
        success: function (resp) {
          if (resp.rm_error && resp.rm_error.length > 0) {
            //console.log(resp.rm_error);
            jQuery("#errors").html(resp.rm_error);
            jQuery("#messageModal").modal("show");
          } else {
            let rm_id = resp.rm_id;
            ExceptionManagerServer.setCurrentCommand('Create');
            callback.apply(this, [rm_id]); // we succeeded in getting an id from hub server.
          }
        },
        error: function (err) {
          console.log(err.statusText);  // this is not an RM application err but rather a xhr err.
        }
      });
    }
  }
}
