$(document).ready(function () {

    // initialize widgets
    $("#em-restore").prop('disabled', true);

    $("#backup-list").kendoListBox({
        change: function (e) {
            let element = e.sender.select();
            let dataItem = e.sender.dataItem(element[0])
            if (dataItem.value.length > 0) {
                // enable restore button
                $("#em-restore").prop('disabled', false);
            }

            // AEM_ENUM_LOG
            let data = {'em_restore_selection': dataItem.value};
            call_arbutusserver("/result_manager/api/data/enum-log", 'POST', data, false);
        }
    });

    $("#log-list").kendoListBox({
        selectable: "single",
    });

    function call_arbutusserver(url, type, data, enable_restore) {
        $.ajax({
            url: url,
            type: type,
            data: data,
            cache: false,
            dataType: "json",
            success: function (resp) {
                if (resp.em_error.length === 0) {
                    if (resp.msg_type == 'backup') {
                        $('#backup-title').html("Backup success");
                        $('#backup-message').html(resp.result);
                        $('#backupModal').modal('show');
                    } else if (resp.msg_type == 'enum-backups') {
                        $('#backup-title').html("Backup list");
                        let backup_list = $("#backup-list").data("kendoListBox");
                        let newDataSource = new kendo.data.DataSource();
                        if (resp.result.length > 0) {
                            $.each(resp.result.split('\t'), function (i, v) {
                                let elem = {'value': v.toLowerCase(), 'text': v}
                                newDataSource.add(elem);
                            });
                        }
                        backup_list.setDataSource(newDataSource);
                        $('#backupListModal').modal('show');
                    } else if (resp.msg_type == 'restore') {
                        $('#backup-title').html("Restore");
                        $('#backup-message').html(resp.result);
                        $('#backupModal').modal('show');
                    } else if (resp.msg_type == 'enum-log') {
                        let log_list = $("#log-list").data("kendoListBox");
                        let newDataSource = new kendo.data.DataSource();
                        if (resp.result.length > 0) {
                            $.each(resp.result, function (i, v) {
                                let elem = {'value': i /*v.toLowerCase()*/, 'text': v}
                                newDataSource.add(elem);
                            });
                        }
                        log_list.setDataSource(newDataSource);
                        $('#backupListModal').modal('show');
                    }
                    else {
                        console.log("Not a valid EM back message type!")
                    }
                } else {
                    // handle EM specific errors
                    console.log("Error " + resp.em_error);

                    $('#backup-title').html("Backup error");
                    $('#backup-message').html(resp.em_error);
                    $('#backupListModal').modal('hide');
                    $('#backupModal').modal('show');
                }

                $("#em-backup").removeAttr("disabled");
                $("#em-enum-backups").removeAttr("disabled");
                if (enable_restore) $("#em-restore").removeAttr("disabled");
            },
            error: function (e) {
                // handle post errors
                console.log(e.message);
                $("#em-backup").removeAttr("disabled");
                $("#em-enum-backups").removeAttr("disabled");
                if (enable_restore) $("#em-restore").removeAttr("disabled");
            }
        });
    };

    // handle page events

    // enums of all backups
    $(document).on('click', '#em-enum-backups', function () {
        $("#em-restore").prop('disabled', true);
        // ensure clear selection and all data items
        $("#log-list").data("kendoListBox").clearSelection();
        $("#log-list").data("kendoListBox").dataSource.data([]);
        call_arbutusserver("/result_manager/api/data/backup", 'GET', false);
    });

    // back up
    $(document).on('click', '#em-backup', function () {
        $("#em-backup").attr("disabled", "disabled");
        $("#em-enum-backups").attr("disabled", "disabled");
        call_arbutusserver("/result_manager/api/data/backup", 'POST', false);
    });

    // restore
    $(document).on('click', '#em-restore', function () {
        $("#em-backup").attr("disabled", "disabled");
        $("#em-restore").attr("disabled", "disabled");
        $("#em-enum-backups").attr("disabled", "disabled");
        
        // selected restore item
        let restore_element =  $("#backup-list").data("kendoListBox").select();
        let restore_dataItem = $("#backup-list").data("kendoListBox").dataItem(restore_element[0]);

        /*
        // selected log items. can be more than one.
        let log_elements = $("#log-list").data("kendoListBox").select();
        let log_dataItems = [];
        $.each(log_elements, function (i, v) {
            let log_dataItem = $("#log-list").data("kendoListBox").dataItem(v);
            let datetimestamp = log_dataItem.text.split('\t')[0]
            let elem = {'value' : log_dataItem.value, 'text': datetimestamp};
            log_dataItems.push(elem);
        });
        */
        
        // only start and end now required, not a list of selected items.
        // start is always the first item of listbox items (if any).
        let log_dataItems = [];
        let last_log_element = $("#log-list").data("kendoListBox").select();
        if (last_log_element.length > 0) {

            // first item - only need if something has been selected (last item)
            let first_log_dataItems = $("#log-list").data("kendoListBox").dataItems();
            if (first_log_dataItems.length > 0) {
                first_log_dataItem = first_log_dataItems[0];
                let datetimestamp = first_log_dataItem.text.split('\t')[0]
                let elem = {'value' : first_log_dataItem.value, 'text': datetimestamp};
                log_dataItems.push(elem);
            } 

            // last item (seleted item)
            let last_log_dataItem = $("#log-list").data("kendoListBox").dataItem(last_log_element);
            let datetimestamp = last_log_dataItem.text.split('\t')[0]
            let elem = {'value' : last_log_dataItem.value, 'text': datetimestamp};
            log_dataItems.push(elem);
        }

        let data = {
            'em_restore_selection': restore_dataItem.value,
            'em_log_selection': JSON.stringify(log_dataItems)
        }

        call_arbutusserver("/result_manager/api/data/restore", 'POST', data, true);
    });
});
