
// dependant on activity_result_common.js

function build_thread_dialog(process_id, activity, notes, attachments) 
{
  // As some of the rm form question field names in the rm form data can differ
  // between activity and visual editor so requesting a form for the thread via
  // the visual-editor API, it uses ve field names as opposed to activity field names
  // so we need to change them so that the common client-side templating referenced 
  // field names are what is expected. e.g. 'thequestion' -> 'question', 'question-rmid' -> 'id' ...
  if (activity.forms.length > 0) {
    let form = activity.forms[0];
    // TODO, do we need to restore old names before sending to server side?
    form.questions.forEach(o => {
      delete Object.assign(o, {['question']: o['thequestion'] })['thequestion'];
      delete Object.assign(o, {['id']: o['question-rmid'] })['question-rmid']; 
      // add answer field to object and init with an empty string to avoid undefined values in UI.
      Object.assign(o, {['answer']: ""});
    });

  }
  
  // render appropiate UI with data.
  $("#panel-details-container").html("");
  $("#panel-details-container").append(
    kendo.template($("#close-thread-panel-template").html())
    ({ activity: activity }),
  );
   
  $("#tabstrip").html("");  // clear tabstrip before building.

  // tabstrip for the activity dialog
  let tabstrip = $("#tabstrip")
    .kendoTabStrip({
      dataTextField: "text",
      dataContentField: "content",
      show: function (e) {
        $(".notes-list-item__content").each(function () {
          if (this.clientHeight > 48) $(this).closest(".notes-list-item").addClass("hide-mode");
        });
      },
      dataSource: [
        {
          text: "Forms",
          encoded: false,
          content: kendo.template(
            $("#close-activity-forms-panel-template").html()
          )({ activity: activity, showFormSave: false }),
        },
        {
          text: "Notes",
          encoded: false,
          content: kendo.template(
            $("#close-activity-notes-panel-template").html()
          )({ notes: notes, showAddNote: false }),
        },
        {
          text: "Attachments",
          encoded: false,
          content: kendo.template(
            $("#close-activity-attachments-panel-template").html()
          )({ activity: activity, attachments: attachments, showUploads: false }),
        },
      ],
    })
    .data("kendoTabStrip");

  $("#panelbar-details").kendoPanelBar({});
  $("#panelbar-forms").kendoPanelBar({});

  tabstrip.select(0);

  // init form components
  selectControlInit();
  datePickerInit();
  rangeSliderSet(activity);   //rangeSliderInit();
  dropZoneInit();
  
  // init module globals
  ArbutusFormCloseActivity.activity_id = null;
  ArbutusFormCloseActivity.thread_id = null;
  if (activity.forms.length > 0) ArbutusFormCloseActivity.current_form_details = activity.forms[0];

  $('#form_threads_process').val(process_id);
}


function requestThreadRmForm(selected_process_id, selected_state_id) 
{

  // first up, we get a list of all RM Forms in the system
  jQuery.ajax({
    url: "/result_manager/api/data/get-rmforms",
    type: "POST",
    data: {
      search_phrase: JSON.stringify(null),
    },
    cache: false,
    dataType: "json",
    success: function (resp) {
      if (resp.error.length === 0) {                                        // check for hub server error
        if (resp.forms.length === 0 || resp.forms[0].length === 0) return;  // check for no form data.
        
        let foundForm = false;
        // iterate over all forms returned by Hub server.
        for(let i=0; i < resp.forms.length; i++) {
          //     0          1             2         3         4         5           6         7
          // "process_id\process_label\state_id\state_label\form_id\form_label\description\questions"
          const fields = resp.forms[i].split("\t");
          if (fields.length < 7) return;
          const process_id = fields[0];
          const state_id = fields[2];
          const form_id = fields[4];

          // find specific form in list based on selected process and state id's, 
          // when we find first match, use known form id as well and now request that spoecific RM Form.

          if (process_id == selected_process_id && state_id == selected_state_id) {
            foundForm = true;
            populateFoundRmForm(process_id, state_id, form_id);
            break;  // found one, so break iterating over more of the forms.
          }
        }

        // clear form panel in case previous selection had a form and current does not.
        if (!foundForm) {
          $("#panelbar-forms").html("");
          ArbutusFormCloseActivity.current_form_details = null;
          ArbutusFormCloseActivity.thread_id = null;
        }

      } else {
        jQuery("#errors").html(resp.error);
        jQuery("#messageModal").modal("show");
        return;
      }
    },
    error: function (e) {
      console.log(e.message);
    },
  });
}


function populateFoundRmForm(process_id, state_id, form_id)
{
  // server side expected format of IDs is -> 'pid*sid*fid' (process, state, form)
  const IDs = process_id + "*" + state_id + "*" + form_id;
  jQuery.ajax({
    url: "/result_manager/api/data/ve-details",
    type: "GET",
    data: {
      "command": '',
      "dialog_type": 'get-a-rmform',
      "list_id": IDs,                 
      "form_data": null
    },
    cache: false,
    dataType: "json",
    success: function (resp) {
      if (resp.error && resp.error.length > 0) {
        jQuery('#errors').html(resp.error);
        jQuery('#messageModal').modal('show');
        return;
      }
      else {
        // add some activity specific keys with appropiate values required by client-side templating.
        build_thread_dialog(process_id, {forms: [resp.result], state_id: resp.result.sid, closed: ""}, null, []);
      }
    },
    error: function (e) {
      console.log(e.message);
    },
  });
}


$(document).ready(function () {
  ExceptionManagerGrid.loadGridStatesFromServer([]);
  sessionStorage.setItem("msg_filter", "ACTIVE");
  let searchPhrase = null;

  var grid = $("#grid")
    .kendoGrid({
      columns: [
        {
          field: "info-thread-activities",
          width: "90",
          title: " ",
          template:
            "<button type='button' title='Information' class='btn btn-xs command-btn command-info'><span class='fa fa-info'></span></button>", // +
          //"<button type='button' title='Delete' class='btn btn-xs btn-danger command-btn command-delete'><span class='fa fa-trash-o'></span></button>"
        },
        { field: "type", width: "80", title: "Type" },
        { field: "description", width: "250", title: "Description" },
        { field: "serialno", width: "120", title: "Serial No.", type: "number" },
        { field: "ref", width: "90", title: "Ref" },
        { field: "process", width: "150", title: "Workflow" },
        { field: "priority", width: "100", title: "Priority", type: "number" },
        { field: "creator", width: "150", title: "Creator" },
        { field: "assigned", width: "150", title: "Assigned" },
        {
          field: "closed",
          width: "180",
          title: "Closed",
          type: "date",
          format: "{0:MM/dd/yyyy h:mm:s tt}",
        },
        {
          field: "opened",
          width: "180",
          title: "Opened",
          type: "date",
          format: "{0:MM/dd/yyyy h:mm:s tt}",
        },
        {
          field: "id",
          width: "100",
          title: "ID",
          type: "number",
          hidden: true,
        },
      ],
      dataSource: {
        transport: {
          read: {
            url: "/result_manager/api/data/basic",
            type: "post",
            dataType: "json",
            data: {
              pathname: "threads",
              msg_filter: "ACTIVE",
              thread_activities_id: null,
              searchPhrase: null
            },
            dataType: "json",
          },
        },
        requestStart: function (e) {
          this.options.transport.read.data.msg_filter = sessionStorage.getItem(
            "msg_filter"
          );
          this.options.transport.read.data.searchPhrase = searchPhrase;
        },
        schema: {
          data: "rows",
          skip: "skip",
          take: "take",
          total: "total",
          pageSize: "pageSize",
          page: "page",
          id: "id",
        },
        pageSize: 250,
        serverPaging: true,
        serverSorting: true,
      },
      height: 760,
      scrollable: {
        virtual: true,
      },
      /*
        pageable: {
            pageSizes: [10, 25, 50, "all"],
            pageSize: 25,
            numeric: false
        }, */
      selectable: "row",
      resizable: true,
      columnMenu: false,
      //filterable: true,
      reorderable: true,
      sortable: true,
      sort: function (e) {
        $("#grid .k-scrollbar-vertical").scrollTop(0);
        // manipulate the stlying of the grid column header
        styleColumnHeader(e.sort["field"], e.sort["dir"]);
      },
      toolbar: kendo.template($("#template").html()),
    }).data("kendoGrid");

  // load the page grid state if it has some
  ExceptionManagerGrid.setGridOptions("threads", []);

  $("#grid")
    .kendoTooltip({
      filter: "button",
      position: "top",
      content: function (e) {
        let target = e.target; // the element for which the tooltip is shown
        return target.data("title") + " " + target.text(); // set the element text as content of the tooltip
      },
    }).data("kendoTooltip");

  // add column menu to toolbar
  let ds = [];
  for (let i = 0, max = grid.columns.length; i < max; i++) {
    let title = grid.columns[i].title;
    if (title.trim().length === 0) title = grid.columns[i].field;

    ds.push({
      encoded: false,
      text:
        "<input type='checkbox' checked='checked' class='check k-checkbox' data-field='" +
        grid.columns[i].field +
        "' id='" +
        grid.columns[i].field +
        "'/>" +
        "<label class='k-checkbox-label' for='" +
        grid.columns[i].field +
        "'>" +
        title +
        "</label>",
    });
  }

  // toolbar status dropdown creation.
  $("#status").kendoDropDownList({
    change: function (e) {
      let name = e.sender.value();
      if (name.length === 0) name = "active";

      // filter status by selected option value
      let msgFilter = name.toUpperCase();
      sessionStorage.setItem("msg_filter", msgFilter);
      $("#grid").data("kendoGrid").dataSource.read({
        msg_filter: msgFilter,
        searchPhrase: searchPhrase
      });
    },
  });

  // column menu on toolbar handler
  $("#column-menu").kendoMenu({
    dataSource: [
      {
        text: "Columns",
        imageUrl: "/static/result_manager/arbutus-img/columns12x12.png",
        items: ds,
      },
    ],
    openOnClick: true,
    closeOnClick: false,
    open: function () {
      // deselect hidden columns
      $.each(grid.columns, function () {
        if (this.hidden) {
          let selector = "input[data-field='" + this.field + "']";
          $(selector).prop("checked", false);
        }
      });
    },
    select: function (e) {
      // ignore click on top-level menu button
      if ($(e.item).parent().filter("div").length) return;

      let input = $(e.item).find("input.check");
      let field = $(input).data("field");
      if ($(input).is(":checked")) {
        grid.showColumn(field);
      } else {
        grid.hideColumn(field);
      }
    },
  });

  $("#grid").on("click", "tbody tr", function (e) {
    let isDeleteBtn = ($(e.target).hasClass("command-delete") && $(e.target).prop("disabled") == false) || 
      ($(e.target).parent().hasClass("command-delete") && $(e.target).parent().prop("disabled") == false);

    // open grid item if not delete button
    if (!isDeleteBtn) {
      // list all exceptions activities after redirect to activities page.
      let grid = $("#grid").data("kendoGrid");
      let selected = $(e.currentTarget).closest("tr");
      let row_data = grid.dataItem(selected);
      if (row_data == null) return;
      let thread_activities_id = row_data.id.toString()       
      if (thread_activities_id) {
        // use href to keep history of results page navigation rather than .replace(...)
        window.location.href = 'activities?thread=' + thread_activities_id;;  
      }

      //sessionStorage.setItem("thread_activities_id", row_data.id.toString());
      //window.location.replace("activities");  // redirect to activities
    }
  });

  $(document).on("click", ".command-delete", function (e) {
    deleteUser(e);
  });


  function deleteUser(e) {
    e.preventDefault();
    ExceptionManagerServer.setCurrentID(
      $("#grid").data("kendoGrid").dataItem($(e.currentTarget).closest("tr")).id
    );
    
    $("#deleteConfirmModal").modal("show");
  }


  $(".toolbar-top").on("click", "button#btnAdd", function () {

    build_thread_dialog(null, {forms: []}, null, []);
    
    ExceptionManagerServer.setCurrentCommand("Create");
    $("#form_threads_id").hide();
    
    $("#modal_threads")
      .on("hide.bs.modal", function (e) {
        $(this).find("form").trigger("reset");
        $("select").scrollTop(0);
        $(".dual-select").bootstrapDualListbox("refresh", true);
      })
      .on("shown.bs.modal", function (e) {
        $("input:text:visible:enabled", this)
          .not('[readonly="readonly"]')
          .first()
          .focus();
      })
      .modal("show");
  });


  $("#dialog_threads_save_id").click(function () {

    // validate we have chosen a WorkFlow (process)
    if ($("#form_threads_process option:selected").val().length === 0) {
      $("#errors").html("You must select a WorkFlow.");
      $("#messageModal").modal("show");
      return;
    }

    let rmform = {};

    // extract values from threads dialog HTML form
    let form_data = {
      form_id: $("#form_threads_id").val(),
      type: $("#form_threads_type").val(),
      description: $("#form_threads_description").val(),
      ref: $("#form_threads_ref").val(),
      nref: $("#form_threads_nref").val(),
      process: $("#form_threads_process option:selected").text(),
      priority: $("#form_threads_priority").val(),
      creator: $("#form_threads_creator").val(),
      rmform: rmform, // only one form per thread (first WF node rmform)
      //attachment: $("#form_threads_attachment").val(),
    };

    if (ArbutusFormCloseActivity.current_form_details) {
      // we have a form, so populate existing form_data payload with its contents.
      form_data['rmform'] = get_current_rmform_values(false);
    }

    // create a thread on server by sending dialog form data to exception manager
    ExceptionManagerServer.api_data_details("threads", form_data);

  });


  // event handler for search widget
  $("#search").keyup(function () {
    searchPhrase = $(this).val();
    // NOTE: pulling grid data from webserver maybe too 
    // expensive/slow for each key up???
    ExceptionManagerGrid.refreshGrid();
  });

  $("div#modal_threads").on("change", "select#form_threads_process", function (e) {
    
    // capture the selected workflow meta data, such as its id (process) and entry (first state id)

    //const requested_process_label = this[this.selectedIndex].text;
    const requested_process_id = this[this.selectedIndex].value;
    const requested_process_entry = this[this.selectedIndex].getAttribute("data-entry");
    requestThreadRmForm(requested_process_id, requested_process_entry);
 });

});
