$(document).ready(function () {
  ExceptionManagerGrid.loadGridStatesFromServer([deleteUser]);
  sessionStorage.setItem("msg_filter", "ACTIVE");
  let searchPhrase = null;

  let grid = $("#grid")
    .kendoGrid({
      columns: [
        {
          field: "edit-delete-user",
          width: "80",
          title: " ",
          template:
            "<div class='buttons-holder'>" +
            "<button type='button' title='Edit' class='btn btn-xs command-btn command-edit'><span class='fa fa-pencil'></span></button>" +
            "<button type='button' title='Delete' class='btn btn-xs command-btn command-delete'><span class='fa fa-trash-o'></span></button" +
            "</div>",
        },
        { field: "name", width: "150", title: "Name" },
        { field: "login", width: "100", title: "Login" },
        { field: "type", width: "50", title: "Type" },
        { field: "admin", width: "50", title: "Admin" },
        { field: "who", width: "150", title: "Who" },
        { field: "date", width: "150", title: "Date" },
        { field: "notify", width: "50", title: "Notify"},
        { field: "begins", width: "70", title: "Begins"},
        { field: "ends", width: "50", title: "Ends" },
        { field: "email", width: "180", title: "Email", hidden: true },
        { field: "initials", width: "50", title: "Initials", hidden: true },
        { field: "id", width: "80", title: "ID", type: "number", hidden: true },
        { field: "notifyTime", width: "150", title: "Notify Time", hidden: true },
      ],
      dataSource: {
        transport: {
          read: {
            url: "/result_manager/api/data/basic",
            type: "post",
            dataType: "json",
            data: {
              pathname: "users",
              msg_filter: "ACTIVE",
              thread_activities_id: null,
              searchPhrase: null
            },
            dataType: "json",
          },
        },
        requestStart: function (e) {
          this.options.transport.read.data.msg_filter = sessionStorage.getItem(
            "msg_filter"
          );
          this.options.transport.read.data.searchPhrase = searchPhrase;
        },
        schema: {
          data: "rows",
          skip: "skip",
          take: "take",
          total: "total",
          pageSize: "pageSize",
          page: "page",
          id: "id",
        },
        pageSize: 250,
        serverPaging: true,
        serverSorting: true,
      },
      scrollable: {
        virtual: true,
      },
      /*
        pageable: {
            pageSizes: [10, 25, 50, "all"],
            pageSize: 25,
            numeric: false
        }, */
      selectable: "row",
      resizable: true,
      columnMenu: false,
      //filterable: true,
      reorderable: true,
      sortable: true,
      sort: function (e) {
        $("#grid .k-scrollbar-vertical").scrollTop(0);
        // manipulate the stlying of the grid column header
        styleColumnHeader(e.sort["field"], e.sort["dir"]);
      },
      toolbar: kendo.template($("#template").html()),
    }).data("kendoGrid");

  // load the page grid state if it has some
  ExceptionManagerGrid.setGridOptions("users", [deleteUser]);

  $("#grid")
    .kendoTooltip({
      filter: "button",
      position: "top",
      content: function (e) {
        let target = e.target; // the element for which the tooltip is shown
        return target.data("title") + " " + target.text(); // set the element text as content of the tooltip
      },
    })
    .data("kendoTooltip");

  // add column menu to toolbar
  let ds = [];
  for (let i = 0, max = grid.columns.length; i < max; i++) {
    let title = grid.columns[i].title;
    if (title.trim().length === 0)
      title = grid.columns[i].field;

    ds.push({
      encoded: false,
      text:
        "<input type='checkbox' checked='checked' class='check k-checkbox' data-field='" +
        grid.columns[i].field +
        "' id='" +
        grid.columns[i].field +
        "'/>" +
        "<label class='k-checkbox-label' for='" +
        grid.columns[i].field +
        "'>" +
        title +
        "</label>",
    });
  }

  // toolbar status dropdown creation.
  $("#status").kendoDropDownList({
    change: function (e) {
      let name = e.sender.value();
      if (name.length === 0) name = "active";

      // filter status by selected option value
      msgFilter = name.toUpperCase();
      sessionStorage.setItem("msg_filter", msgFilter);
      $("#grid").data("kendoGrid").dataSource.read({
        msg_filter: msgFilter,
        searchPhrase: searchPhrase
      });
    },
  });

  // column menu on toolbar handler
  $("#column-menu").kendoMenu({
    dataSource: [
      {
        text: "Columns",
        imageUrl: "/static/result_manager/arbutus-img/columns12x12.png",
        items: ds,
      },
    ],
    openOnClick: true,
    closeOnClick: false,
    open: function () {
      let selector;
      // deselect hidden columns
      $.each(grid.columns, function () {
        if (this.hidden) {
          selector = "input[data-field='" + this.field + "']";
          $(selector).prop("checked", false);
        }
      });
    },
    select: function (e) {
      // ignore click on top-level menu button
      if ($(e.item).parent().filter("div").length) return;

      let input = $(e.item).find("input.check");
      let field = $(input).data("field");
      if ($(input).is(":checked")) {
        grid.showColumn(field);
      } else {
        grid.hideColumn(field);
      }
    },
  });

  /* grid change event */

  $("#grid").on("click", "tbody tr", function (e) {
    let isDeleteBtn =
      ($(e.target).hasClass("command-delete") &&
        $(e.target).prop("disabled") == false) ||
      ($(e.target).parent().hasClass("command-delete") &&
        $(e.target).parent().prop("disabled") == false);

    // open grid item if not delete button
    if (!isDeleteBtn) {
      // open user edit dialog
      let grid = $("#grid").data("kendoGrid");
      let selected = $(e.currentTarget).closest("tr");
      let row_data = grid.dataItem(selected);
      if (row_data == null) return;

      ExceptionManagerServer.setCurrentID(row_data.id);
      ExceptionManagerServer.setCurrentCommand("Update");
      ExceptionManagerServer.api_data_details_get("users");
    }
  });

  $(document).on("click", ".command-delete", function (e) {
    deleteUser(e);
  });

  function deleteUser(e) {
    e.preventDefault();
    ExceptionManagerServer.setCurrentID(
      $("#grid").data("kendoGrid").dataItem($(e.currentTarget).closest("tr")).id
    );

    $("#deleteConfirmModal").modal("show");
  }

  /* toolbar buttons */

  // show the users empty form dialog
  $(".toolbar-top").on("click", "button#btnAdd", function () {
    ExceptionManagerServer.setCurrentCommand("Create");
    $("#form_users_id").hide();
   
    $("#modal_users")
      .on("hide.bs.modal", function (e) {
        $(this).find("form").trigger("reset");
        $("select").scrollTop(0);
        $(".dual-select").bootstrapDualListbox("refresh", true);
      })
      .on("shown.bs.modal", function (e) {
        $("input:text:visible:enabled", this)
          .not('[readonly="readonly"]')
          .first()
          .focus();
          $("#form_users_notify").change();
      })
      .modal("show");
  });

  $(".toolbar-top").on("click", "button#btnDelete", function () {
    $("#deleteConfirmModal").modal("show");
  });

  $("#form_users_notify").change(function (ev) {
    const notif_type = $(this).val();
    if (notif_type === 'D') {
      // enable start time element & disable end time element.
      $('#form_users_begins').prop("disabled", false);
      $('#form_users_ends').prop("disabled", true);
    } else if (notif_type === 'H') {
      // enable both start & end time elements
      $('#form_users_begins').prop("disabled", false);
      $('#form_users_ends').prop("disabled", false);
    } else {  // 'N' - NONE
      // disable both start & end time elements.
      $('#form_users_begins').prop("disabled", true);
      $('#form_users_ends').prop("disabled", true);
    }

  });

  // handle save of users dialog form data
  $("#dialog_users_save_id").click(function () {
    let groups_array = [];
    $("#form_users_groups  option:selected").each(function () {
      groups_array.push({ id: $(this).val(), name: $(this).text() });
    });

    let admin_value;
    if (jQuery("#form_users_admin").prop("checked")) admin_value = "T";
    else admin_value = "F";

    /*
    const notify = $("#form_users_notify").val();
    let begins = $("#form_users_begins").val();
    let ends = $("#form_users_ends").val();
 
    if (notify=='N') {
      begins = "";
      ends="";
    }
    else if (notfiy='D') ends="";
    */

    let user_name = $("#form_users_name").val();
    if (user_name.trim().length == 0) {
      $("#errors").html("User name is mandatory!");
      $("#messageModal").modal("show");
      return;
    }

    let user_login = $("#form_users_login").val();
    if (user_login.trim().length == 0) {
      $("#errors").html("User login is mandatory!");
      $("#messageModal").modal("show");
      return;
    }

    let user_email = $("#form_users_email").val();
    if (user_email.trim().length == 0) {
      $("#errors").html("User email is mandatory!");
      $("#messageModal").modal("show");
      return;
    }

    let user_notify_type = $("#form_users_notify").val();
    if (user_notify_type.trim().length == 0) {
      $("#errors").html("User notification is mandatory!");
      $("#messageModal").modal("show");
      return;
    }

    let user_type = $("#form_users_type").val();
    if (user_type.trim().length == 0) {
      $("#errors").html("User type is mandatory!");
      $("#messageModal").modal("show");
      return;
    }

    let user_initials = $("#form_users_initials").val();
    if (user_initials.trim().length == 0) {
      $("#errors").html("User initials is mandatory!");
      $("#messageModal").modal("show");
      return;
    }

    let form_data = {
      form_id: $("#form_users_id").val(),
      name: $("#form_users_name").val(),
      login: $("#form_users_login").val(),
      email: $("#form_users_email").val(),
      initials: $("#form_users_initials").val(),
      type: $("#form_users_type").val(),
      notify: $("#form_users_notify").val(),
      begins: $("#form_users_begins").val(),
      ends: $("#form_users_ends").val(),
      admin: admin_value,
      groups: groups_array,
    };

    // send data to server
    ExceptionManagerServer.api_data_details("users", form_data);
  });

  // event handler for search widget
  $("#search").keyup(function () {
    searchPhrase = $(this).val();
    // NOTE: pulling grid data from webserver maybe too 
    // expensive/slow for each key up???
    ExceptionManagerGrid.refreshGrid();
  });

});
