/**
 * Created by Luke Duguid on 12/23/2016.
 */

(function($) {
    // < start of closure within this block, $ = django.jQuery

    $(document).ready(function() {

        function update_webapp_server_type() {
            // ensure only windows server type 'Windows (NT) can be the web app server.
            var value = $("#id_server_type option:selected").text();
            if (value === "Windows") {
                $("#id_webapp_server").removeAttr("disabled");  // enable
            } else {
                $("#id_webapp_server").attr('checked', false);  // unchecked first
                $("#id_webapp_server").attr("disabled", true);  // now disable
            }
        }

        function select_all_users() {
            // ensure any users in select box are selected in UI when selecting 
            // appropiate checkbox, see event handlers below.
            $('#id_users option').prop('selected', true);
        }

        
        // Event handlers for admin portal behaviour

        $("#id_server_type").on("change", function() {
            update_webapp_server_type();
        });

        $("#id_webapp_server").on("change", function() {
            if (this.checked) select_all_users();
        });

        $("#id_default").on("change", function() {
            if (this.checked) select_all_users();
        });
        
    });

})(jQuery);
